block('p-api-certification-request-show').elem('form').elemMod('type', 'normal').content()(function() {
    return [
        {
            elem: 'grid',
            cells: [
                {
                    type: 'text',
                    value: this.getAccessText(this.request.access_type),
                    label: iget2('p-api-certification-request-show', 'dostup', 'Доступ'),
                    size: 's'
                },
                {
                    type: 'text',
                    value: this.getStatusText(this.request.status),
                    label: iget2('p-api-certification-request-show', 'status', 'Статус'),
                    size: 's'
                },
                {
                    type: 'text',
                    value: u.moment(this.request.create_time).format('DD.MM.YYYY'),
                    label: iget2('p-api-certification-request-show', 'data-zayavki', 'Дата заявки'),
                    size: 's',
                    float: 'right'
                }
            ]
        },
        {
            elem: 'grid',
            cells: [
                {
                    type: 'text',
                    value: this.getString(this.request.description),
                    label: iget2('p-api-certification-request-show', 'opisanie', 'Описание')
                },
                {
                    type: 'list',
                    value: this.request.app_goals.map(function(item) {
                        return item == 'other' ?
                            iget2('p-api-certification-request-show', 'drugoe', 'Другое') + ': ' + u.escapeHTML(this.request.other_app_goal) :
                            this.getAppGoalsList(item);
                    }, this),
                    label: iget2('p-api-certification-request-show', 'dlya-chego-prednaznacheno-prilozhenie', 'Для чего предназначено приложение') + ':'
                },
                {
                    type: 'list',
                    value: this.request.app_functions.map(function(item) {
                        return item == 'other' ?
                            iget2('p-api-certification-request-show', 'drugoe', 'Другое') + ': ' + u.escapeHTML(this.request.other_app_function) :
                            this.getAppFunctionsList(item);
                    }, this),
                    label: iget2('p-api-certification-request-show', 'osnovnye-funkcii-prilozheniya-v', 'Основные функции приложения в Директе') + ':'
                },
                {
                    type: 'text',
                    value: this.getString(this.request.app_profit),
                    label: iget2('p-api-certification-request-show', 'chem-polezno', 'Чем полезно')
                },
                {
                    type: 'text',
                    value: this.getString(this.request.using_api_functions),
                    label: iget2('p-api-certification-request-show', 'shema-vzaimodeystviya-prilozheniya-s', 'Схема взаимодействия приложения с Директом')
                },
                {
                    type: 'files-list',
                    value: {
                        specifications_and_screenshots: this.request.specifications_and_screenshots,
                        application_id: this.request.application_id,
                        ulogin: this.request.login.login
                    },
                    label: iget2('p-api-certification-request-show', 'specifikaciya-programmy-skrinshoty-s', 'Спецификация программы, скриншоты с UI')
                },
                {
                    type: 'text',
                    value: this.getTechnicalDataStr(
                        this.request.prog_language,
                        this.request.protocol,
                        this.request.library_version
                    ),
                    label: iget2('p-api-certification-request-show', 'tehnicheskaya-informaciya', 'Техническая информация'),
                    size: 'l'
                },
                {
                    type: 'text',
                    value: this.getString(this.request.app_demo_access),
                    label: iget2('p-api-certification-request-show', 'demo-dostup', 'Демо доступ'),
                    size: 'l'
                }
            ]
        },
        {
            elem: 'grid',
            cells: [
                {
                    type: 'text',
                    value: [
                        (this.request.login.link ?
                            {
                                block: 'link',
                                content: this.getString(this.request.login.login),
                                url: this.request.login.link
                            } :
                            u.escapeHTML(this.request.login.login)),
                        (this.request.login.approved_requests_count ?
                            ' (' + iget2('p-api-certification-request-show', 'zayavok', 'заявок') + ': ' + u.escapeHTML(this.request.login.approved_requests_count) + ')' :
                            '')
                    ],
                    label: iget2('p-api-certification-request-show', 'login-razrabotchika', 'Логин разработчика'),
                    size: 'm'
                },
                {
                    type: 'text',
                    value: this.getString(this.request.email),
                    label: iget2('p-api-certification-request-show', 'email-iz-akkaunta', 'Email из аккаунта'),
                    size: 'm'
                },
                {
                    type: 'text',
                    value: this.request.developer_email,
                    label: iget2('p-api-certification-request-show', 'email-iz-formy', 'Email из формы'),
                    size: 'm'
                },
                {
                    type: 'text',
                    value: this.getString(this.request.company_name),
                    label: iget2('p-api-certification-request-show', 'nazvanie-kompanii', 'Название компании'),
                    size: 'l'
                },
                {
                    type: 'text',
                    value: this.request.company_site ?
                        {
                            block: 'link',
                            content: this.getString(this.request.company_site),
                            url: !this.request.company_site.match('^http') ?
                                'http://' + this.request.company_site : this.getString(this.request.company_site)
                        } :
                        '&mdash;',
                    label: iget2('p-api-certification-request-show', 'sayt', 'Сайт'),
                    size: 'l'
                },
                {
                    type: 'text',
                    value: this.request.api_logins_list.reduce(function(data, login) {
                        data.push(
                            login.link ?
                                {
                                    block: 'link',
                                    content: u.escapeHTML(login.login),
                                    url: login.link
                                } :
                                u.escapeHTML(login.login),
                            login.approved_requests_count ?
                            ' (' + iget2('p-api-certification-request-show', 'zayavok', 'заявок') + ': ' + u.escapeHTML(login.approved_requests_count) + ')' :
                            ''
                        );

                        return data;
                    }, []),
                    label: iget2('p-api-certification-request-show', 'login-dlya-dostupa-v', 'Логин для доступа в Директ')
                },
                {
                    type: 'text',
                    value: this.request.business_type == 'other' ?
                        iget2('p-api-certification-request-show', 'drugoe', 'Другое') + ': ' + u.escapeHTML(this.request.other_business_type) : this.getBusinessTypeText(this.request.business_type),
                    label: iget2('p-api-certification-request-show', 'rod-deyatelnosti', 'Род деятельности')
                },
                {
                    type: 'text',
                    value: this.getString(this.request.comment),
                    label: iget2('p-api-certification-request-show', 'kommentariy-dlya-razrabotchika', 'Комментарий для разработчика')
                }
            ]
        }
    ];
});
