block('p-api-certification-request-show').elem('form').def()(function() {
    return applyNext({
        request: this.data.request,
        getString: function(str) {
            return str ? u.escapeHTML(str) : '&mdash;';
        },
        getRawString: function(str) {
            return str || '&mdash;';
        },
        getBusinessTypeText: function(str) {
            return {
                client: iget2(
                    'p-api-certification-request-show',
                    'pryamoy-reklamodatel-i-avtomatiziruete-102',
                    'Прямой рекламодатель и автоматизируете управление собственными рекламными кампаниями'
                ),
                agency: iget2(
                    'p-api-certification-request-show',
                    'reklamnoe-agentstvo-i-avtomatiziruete',
                    'Рекламное агентство и автоматизируете работу своих сотрудников с рекламными кампаниями клиентов'
                ),
                aggregator: iget2(
                    'p-api-certification-request-show',
                    'reklamnoe-agentstvo-i-predostavlyaete',
                    'Рекламное агентство и предоставляете своим клиентами сервисы для самостоятельного управления их кампаниями'
                ),
                developer: iget2(
                    'p-api-certification-request-show',
                    'razrabotchik-programmnogo-obespecheniya-i',
                    'Разработчик программного обеспечения и ваш основной бизнес не связан с работой с клиентами-рекламодателями'
                )
            }[str.toLowerCase()];
        },
        getAppFunctionsList: function(str) {
            return {
                get_statistics: iget2('p-api-certification-request-show', 'poluchenie-statistiki-i-otchetov', 'Получение статистики и отчетов'),
                manage_campaign: iget2('p-api-certification-request-show', 'upravlenie-kampaniyami-i-obyavleniyami', 'Управление кампаниями и объявлениями'),
                manage_bids: iget2('p-api-certification-request-show', 'upravlenie-stavkami-bidding', 'Управление ставками (биддинг)'),
                choice_keywords: iget2(
                    'p-api-certification-request-show',
                    'podbor-klyuchevyh-slov-ispolzovanie',
                    'Подбор ключевых слов (использование wordstat)'
                )
            }[str.toLowerCase()];
        },
        getAppGoalsList: function(str) {
            return {
                automation: iget2(
                    'p-api-certification-request-show',
                    'avtomatizirovat-regulyarnuyu-rabotu-po',
                    'Автоматизировать регулярную работу по управлению кампаниями в Директе'
                ),
                sync_with_inner_servise: iget2(
                    'p-api-certification-request-show',
                    'sinhronizirovat-reklamnye-materialy-s',
                    'Синхронизировать рекламные материалы с данными внутренних систем (товары, деньги, отчетность)'
                ),
                aggregation: iget2(
                    'p-api-certification-request-show',
                    'razmeshchat-reklamnye-materialy-na',
                    'Размещать рекламные материалы на нескольких рекламных площадках одновременно'
                ),
                upload_big_campaign: iget2(
                    'p-api-certification-request-show',
                    'zagruzhat-obemnye-kampanii-s',
                    'Загружать объемные кампании с большим количеством ключевых слов'
                )
            }[str.toLowerCase()];
        },
        getTechnicalDataStr: function(progLang, protocol, libsVer) {
            return (progLang ? u.escapeHTML(progLang) + ', ' : '') +
                    (protocol ? protocol.join(', ') + ', ' : '') +
                    (libsVer ? iget2('p-api-certification-request-show', 'versii-bibliotek', 'версии библиотек') + ': ' + u.escapeHTML(libsVer) : '');
        },
        getStatusText: function(str) {
            return {
                approve: iget2('p-api-certification-request-show', 'odobrena', 'одобрена'),
                reject: iget2('p-api-certification-request-show', 'otklonena', 'отклонена'),
                new: iget2('p-api-certification-request-show', 'novaya', 'новая')
            }[str.toLowerCase()];
        },
        getAccessText: function(str) {
            return {
                test: iget2('p-api-certification-request-show', 'testovyy', 'тестовый'),
                normal: iget2('p-api-certification-request-show', 'polnyy', 'полный')
            }[str.toLowerCase()];
        }
    });
});
