block('p-api-certification-request-show')(

    elem('header')(

        js()(true),

        content()(function() {
            return [
                applyNext(),
                { elem: 'clear' }
            ];
        })
    ),

    elem('header-title').tag()('h1'),

    elem('header-subtitle').content()(function() {
        return [
            {
                elem: 'header-subtitle-appname',
                content: u.escapeHTML(this.ctx.appName)
            },
            {
                elem: 'header-subtitle-appid',
                content: this.ctx.appId
            },
            { elem: 'clear' }
        ];
    }),

    elem('header-history-list')(
        tag()('ul'),

        content()(function() {
            return this.ctx.items.map(function(item) {
                return {
                    elem: 'header-history-list-item',
                    elemMods: { current: this.ctx.currentVersion == item.create_time ? 'yes' : '' },
                    appId: this.ctx.applicationId,
                    currentVer: this.ctx.currentVersion,
                    entity: item,
                    ulogin: this.ctx.ulogin
                };
            }, this);
        })
    ),

    elem('header-history-list-item')(
        tag()('li'),

        content()(function() {
            return {
                block: 'link',
                mods: { disabled: this.ctx.currentVer == this.ctx.entity.create_time ? 'yes' : '' },
                content: u.moment(this.ctx.entity.create_time).format('DD-MM-YYYY (HH:mm)'),
                url: u.getUrl('apiCertificationGetHistory', {
                    application_id: this.ctx.appId,
                    create_time: this.ctx.entity.create_time,
                    ulogin: this.ctx.ulogin
                })
            };
        })
    )
);
