block('p-api-certification-request-show').elem('header')(

    addJs()(true),

    content()(function() {
        return [
            {
                elem: 'header-title',
                content: iget2('p-api-certification-request-show', 'moderaciya-zayavki-na-prilozhenie', 'Модерация заявки на приложение')
            },
            {
                elem: 'header-subtitle',
                appName: this.data.request.name,
                appId: this.data.request.application_id
            },
            this.ctx.showHistoryDate && {
                elem: 'header-history-subtitle',
                content: iget2('p-api-certification-request-show', 'versiya', 'Версия') + ': ' + u.moment(this.data.request.create_time).format('DD.MM.YYYY (HH:mm)')
            },
            this.data.request.history.length > 0 && [
                {
                    block: 'link',
                    mix: {
                        block: 'p-api-certification-request-show',
                        elem: 'header-history-link'
                    },
                    mods: {
                        pseudo: 'yes',
                        theme: 'pseudo'
                    },
                    content: iget2('p-api-certification-request-show', 'istoriya-izmeneniy', 'История изменений') + ' (' + this.data.request.history.length + ')'
                },
                {
                    block: 'popup',
                    js: {
                        directions: 'bottom'
                    },
                    mix: {
                        block: 'p-api-certification-request-show',
                        elem: 'header-history-popup'
                    },
                    content: [
                        {
                            elem: 'tail'
                        },
                        {
                            elem: 'content',
                            mix: {
                                block: 'p-api-certification-request-show',
                                elem: 'header-history-popup-data'
                            },
                            content: {
                                block: 'p-api-certification-request-show',
                                elem: 'header-history-list',
                                applicationId: this.data.request.application_id,
                                currentVersion: this.data.request.create_time,
                                ulogin: this.data.request.login.login,
                                items: this.data.request.history
                            }
                        }
                    ]
                }
            ]
        ];
    })
);
