match(function() {
    return [
        'apiSettings',
        'saveApiSettings',
        'apiApplicationList',
        'apiCertificationRequestList',
        'apiFinanceSettings',
        'saveApiFinanceSettings',
        'dropFinanceOpsCounter',
        'dropMasterToken',
        'apiSandboxSettings',
        'initSandboxUser',
        'dropSandboxUser',
        'dropSandboxFinanceOpsCounter',
        'getMasterToken'
    ].indexOf(this.data.cmd) !== -1;
})(

    block('app-main')(

        // нужно для b-list-tabs
        mode('preprocess')(function() {
            var data = this.data || {};

            // сопоставляем cmd и табы, у одного таба несколько cmd
            data.FORM.tab = {
                saveApiFinanceSettings: 'apiFinanceSettings',
                getMasterToken: 'apiFinanceSettings',
                dropFinanceOpsCounter: 'apiFinanceSettings',
                saveApiSettings: 'apiSettings'
            }[data.cmd] || data.cmd;

            return data;
        }),

        mode('page-block')('p-api-management'),
        mode('is-dna-header-and-sidebar-enabled')(true)
    ),

    block('b-page')(

        def().match(function() {
            return !this.pageParams;
        })(function() {
            var title = iget2('p-api-management', 'nastroyki-api-ndash-parametry', 'Настройки API &ndash; Параметры'),
                financePageParams = {
                    title: iget2('p-api-management', 'nastroyki-api-ndash-finansovye', 'Настройки API &ndash; Финансовые операции'),
                    tabBlock: 'b-api-management-finance-settings'
                };

            return applyNext({
                pageParams: {
                    apiSettings: {
                        title: title,
                        tabBlock: 'b-api-management-settings'
                    },
                    saveApiSettings: {
                        title: title,
                        tabBlock: 'b-api-management-settings'
                    },
                    apiApplicationList: {
                        title: iget2('p-api-management', 'nastroyki-api-ndash-moi', 'Настройки API &ndash; Мои приложения'),
                        tabBlock: 'b-api-management-apps'
                    },
                    apiCertificationRequestList: {
                        title: iget2('p-api-management', 'nastroyki-api-ndash-moi-103', 'Настройки API &ndash; Мои заявки'),
                        tabBlock: 'b-api-management-cer-list'
                    },
                    apiFinanceSettings: financePageParams,
                    saveApiFinanceSettings: financePageParams,
                    dropFinanceOpsCounter: financePageParams,
                    getMasterToken: {
                        title: title,
                        tabBlock: 'b-api-management-master-token'
                    },
                    apiSandboxSettings: {
                        title: iget2('p-api-management', 'nastroyki-api-ndash-pesochnica', 'Настройки API &ndash; Песочница'),
                        tabBlock: 'b-api-management-sandbox'
                    }
                }
            });
        }),

        mode('title')(function() {
            return this.pageParams[this.data.cmd] && this.pageParams[this.data.cmd].title;
        })
    )
);

block('p-api-management')(
    content()(function() {
        var data = this.data,
            pageParams = this.pageParams[data.cmd] || {},
            mainContent,
            showTabs = false;

        if (data.api_offer === 'accepted') {
            mainContent = {
                block: 'p-api-management',
                elem: 'main',
                title: pageParams.title
            };
            showTabs = true;
        } else {
            mainContent = [
                {
                    block: 'b-page-title',
                    content: {
                        elem: 'title',
                        content: iget2('p-api-management', 'api-servisa-yandeks-direkt', 'API сервиса Яндекс.Директ')
                    }
                },
                data.FORM && data.FORM.api_welcome === 'yes' ?
                    {
                        block: 'p-api-management',
                        elem: 'offer-form',
                        tag: 'form',
                        js: true,
                        attrs: {
                            action: data.SCRIPT,
                            method: 'POST'
                        },
                        content: [
                            data.FORM.ulogin && data.login_rights.is_freelancer && {
                                block: 'b-hidden',
                                name: 'ulogin',
                                value: data.FORM.ulogin
                            },
                            {
                                block: 'b-hidden',
                                name: 'cmd',
                                value: 'certOffer'
                            },
                            {
                                block: 'b-oferta-accept',
                                mix: {
                                    block: 'p-api-management',
                                    elem: 'oferta-accept'
                                },
                                mods: {
                                    type: 'with-accept-button'
                                },
                                acceptRadioName: 'accept',
                                params: {
                                    source: 'direct_api',
                                    yandexDomain: this.data.yandex_domain
                                }
                            }
                        ]
                    } :
                    {
                        block: 'p-api-management',
                        elem: 'offer'
                    }
            ];
        }

        return [
            {
                block: 'l-page',
                mods: {
                    layout: '16-80'
                },
                content: [
                    {
                        elem: 'row',
                        left: {
                            block: 'b-campaign-menu',
                            mix: [{
                                block: 'p-api-management',
                                elem: 'text-decorated-menu'
                            }],
                            options: {
                                navMods: {
                                    type: 'xls'
                                }
                            }
                        },
                        center: mainContent,
                        ctxCells: {
                            center: {
                                attrs: {
                                    colspan: 2
                                }
                            }
                        }
                    }
                ]
            },
            showTabs && {
                block: 'l-page',
                mods: {
                    layout: '16-43-37'
                },
                mix: {
                    block: 'p-api-management',
                    elem: 'content'
                },
                content: [
                    {
                        elem: 'row',
                        left: '&nbsp',
                        center: {
                            block: 'p-api-management',
                            elem: 'tabs'
                        },
                        right: '&nbsp'
                    },
                    {
                        elem: 'row',
                        left: '&nbsp',
                        center: {
                            block: pageParams.tabBlock,
                            mix: [{
                                block: 'p-api-management',
                                elem: 'tab-viewport'
                            }]
                        },
                        right: data.yandex_domain === 'yandex.com.tr' || {
                            block: 'p-api-management',
                            elem: 'help-links'
                        }
                    }
                ]
            }
        ];
    }),

    elem('main').wrap()(function() {
        return [
            {
                block: 'b-page-title',
                content: {
                    elem: 'title',
                    content: this.ctx.title
                }
            },
            {
                block: 'p-api-management',
                elem: 'params'
            }
        ];
    }),

    elem('help-links').content()(function() {
        var lang = this.data.lang,
            isLangTrOrEn = lang === 'en' || lang === 'tr',
            techDomain = isLangTrOrEn ? 'com' : 'ru',
            protocol = 'https',
            techHost = 'tech.yandex.' + techDomain;

        return [
            {
                block: 'link',
                target: '_blank',
                url: u.formatUrl({
                    protocol: protocol,
                    host: techHost,
                    path: '/direct/'
                }),
                content: iget2('p-api-management', 'dokumentaciya-po-api', 'Документация по API')
            },
            {
                block: 'link',
                target: '_blank',
                url: u.formatUrl({
                    protocol: protocol,
                    host: techHost,
                    path: '/direct/doc/support/troubleshooting/faq-docpage/'
                }),
                content: iget2('p-api-management', 'chasto-zadavaemye-voprosy', 'Часто задаваемые вопросы')
            },
            lang === 'ru' ?
                {
                    block: 'link',
                    target: '_blank',
                    url: u.formatUrl({
                        protocol: 'https',
                        host: 'yandex.ru',
                        path: '/adv/edu/direct-api'
                    }),
                    content: iget2('p-api-management', 'onlayn-kurs-kak-nachat', 'Онлайн-курс «Как начать работать с API»')
                } :
                '',
            {
                block: 'link',
                target: '_blank',
                url: u.formatUrl({
                    protocol: protocol,
                    host: 'yandex.ru',
                    path: '/legal/direct_api/',
                    query: isLangTrOrEn ? { lang: 'en' } : undefined
                }),
                content: iget2('p-api-management', 'polzovatelskoe-soglashenie', 'Пользовательское соглашение')
            }
        ];
    }),

    elem('params').content()(function() {
        var data = this.data,
            hasLogin = /^(super|support|superreader)$/.test(data.login_rights.role) && !!data.FORM.ulogin,
            apiEnabled = data.api_enabled ?
                ({
                    elem: 'params-green',
                    content: iget2('p-api-management', 'otkryt', 'открыт'),
                    tag: 'span'
                }) :
                ({
                    elem: 'params-red',
                    content: iget2('p-api-management', 'zakryt', 'закрыт'),
                    tag: 'span'
                });

        return [
            hasLogin && {
                elem: 'params-item',
                content: [iget2('p-api-management', 'login', 'Логин') + ': ', data.FORM.ulogin]
            },
            {
                elem: 'params-item',
                content: [iget2('p-api-management', 'programmnyy-dostup', 'Программный доступ') + ': ', apiEnabled]
            },
            {
                elem: 'params-item',
                content: [
                    iget2('p-api-management', 'ostalos-ballov-api-versii', 'Осталось баллов (API версии 4 и Live 4)') + ': ',
                    data.api_units
                ]
            }
        ];
    }),

    elem('offer').content()(function() {
        var moreAboutApiUrl = u.formatUrl({
            protocol: 'https',
            host: 'tech.yandex.' + (this.data.lang.match(/en|tr/) ? 'com' : 'ru'),
            path: '/direct/'
        });

        return [
            {
                elem: 'offer-row',
                content: iget2(
                    'p-api-management',
                    'api-daet-vozmozhnost-razrabotchikam',
                    'API дает возможность разработчикам создавать собственные программные приложения для работы с Яндекс.Директом. С его помощью можно эффективно управлять большим количеством рекламных кампаний, точнее прогнозировать бюджеты и своевременно получать статистические отчеты.'
                )
            },
            {
                elem: 'offer-row',
                content: [
                    iget2('p-api-management', 'podrobnee-o-rabote-cherez', 'Подробнее о работе через API') + ': ',
                    {
                        block: 'link',
                        content: moreAboutApiUrl,
                        url: moreAboutApiUrl,
                        attrs: {
                            target: '_blank'
                        }
                    }
                ]
            },
            {
                elem: 'offer-accept',
                content: {
                    block: 'link',
                    content: iget2('p-api-management', 'poluchit-dostup-k-api', 'Получить доступ к API'),
                    url: u.getUrl(
                        'apiSettings',
                        this.data.FORM.ulogin ?
                            {
                                api_welcome: 'yes',
                                ulogin: u.escapeHTML(this.data.FORM.ulogin)
                            } :
                            { api_welcome: 'yes' })
                }
            }
        ];
    })
);
