match(function() {
    return this.data.cmd === 'autopaySettings';
})(

    block('app-main').mode('page-block')('p-autopay-settings'),

    block('b-page').mode('title')(function() {
        return iget2('p-autopay-settings', 'autopayment', 'Автоплатёж');
    })
);

block('p-autopay-settings')(

    addJs()(function() {

        return {
            retpath: this.data.FORM.retpath
        };
    }),

    content()(function() {
        var yandexDomain = this.data.yandex_domain,
            autopaySettings = this.data.autopay_settings || {},
            autopaySuggest = this.data.autopay_suggest || {},
            isOfferAccepted = this.data.is_offer_accepted,
            modelData;

        modelData = u._.pick(autopaySettings, [
            'autopay_mode',
            'wallet_cid',
            'paymethod_type',
            'paymethod_id',
            'remaining_sum',
            'payment_sum',
            'currency',
            'cards',
            'yandex_money',
            'person_id'
        ]);

        modelData.remaining_sum = modelData.remaining_sum || autopaySuggest.remaining_sum;
        modelData.payment_sum = modelData.payment_sum || autopaySuggest.payment_sum;

        modelData.available_paymethod_types = this.data.available_paymethod_types;
        modelData.allow_bind_unbind = !!this.data.allow_bind_unbind;
        modelData.read_only = !!this.data.read_only;
        modelData.client_nds = +this.data.client_nds || 0;

        return [
            {
                block: 'l-page',
                mods: {
                    layout: '12-60-16'
                },
                content: [
                    {
                        elem: 'row',
                        left: {
                            block: 'b-campaign-menu',
                            mix: [{
                                block: 'p-autopay-settings',
                                elem: 'text-decorated-menu'
                            }],
                            options: {
                                navMods: {
                                    type: 'autopay'
                                }
                            }
                        },
                        lgap: true,
                        center: [
                            {
                                block: 'b-page-title',
                                title: iget2('p-autopay-settings', 'autopayment', 'Автоплатёж')
                            },
                            {
                                block: 'p-autopay-settings',
                                elem: 'errors'
                            },
                            {
                                block: 'b-autopay-settings',
                                mix: [{
                                    block: 'p-autopay-settings',
                                    elem: 'settings'
                                }],
                                mods: {
                                    'autopay-mode': u.beminize(modelData.autopay_mode),
                                    'read-only': modelData.read_only ? 'yes' : ''
                                },
                                modelData: modelData
                            },
                            modelData.autopay_mode == 'none' && !this.data.read_only && {
                                block: 'p-autopay-settings',
                                elem: 'oferta',
                                content: [
                                    {
                                        block: 'checkbox',
                                        mods: {
                                            size: 's'
                                        },
                                        mix: {
                                            block: 'p-autopay-settings',
                                            elem: 'oferta-checkbox'
                                        },
                                        checkboxAttrs: {
                                            value: 'oferta',
                                            name: 'accept',
                                            autocomplete: 'off'
                                        }
                                    },
                                    iget2(
                                        'p-autopay-settings',
                                        'ya-oznakomilsya-i-soglasen',
                                        'Я ознакомился и согласен с {link} на оказание услуг «Яндекс.Директ»',
                                        {
                                            link: function(text) {
                                                return {
                                                    block: 'b-help-link',
                                                    mods: {
                                                        decoration: 'no',
                                                        margin: 'no'
                                                    },
                                                    mix: [{
                                                        block: 'p-autopay-settings',
                                                        elem: 'oferta-link'
                                                    }],
                                                    text: text,
                                                    url: u.getLegalHelpUrl('/oferta_direct/index.xml')
                                                };
                                            }(iget2('p-autopay-settings', 'ya-oznakomilsya-i-soglasen-param-link', 'Офертой')),

                                            context: 'link - Офертой'
                                        }
                                    )
                                ]
                            }
                        ],
                        rgap: true,
                        right: true
                    },
                    {
                        elem: 'row',
                        left: true,
                        lgap: true,
                        center: !this.data.read_only && [
                            {
                                block: 'button',
                                mods: {
                                    theme: 'normal',
                                    size: 's',
                                    disabled: 'yes'
                                },
                                mix: {
                                    block: 'p-autopay-settings',
                                    elem: 'save'
                                },
                                content: iget2('p-autopay-settings', 'sohranit', 'Сохранить')
                            },
                            {
                                block: 'p-autopay-settings',
                                elem: 'status-message',
                                content: [
                                    {
                                        block: 'spin',
                                        js: {
                                            animation: 'sprite'
                                        },
                                        mix: {
                                            block: 'p-autopay-settings',
                                            elem: 'status-spin'
                                        },
                                        mods: {
                                            theme: 'gray-16'
                                        }
                                    },
                                    {
                                        block: 'p-autopay-settings',
                                        elem: 'status-text',
                                        content: iget2('p-autopay-settings', 'vypolnyaetsya-sohranenie', 'Выполняется сохранение')
                                    }
                                ]
                            }
                        ],
                        rgap: true,
                        right: true
                    }
                ]
            }
        ];
    })
);
