BEM.DOM.decl('p-autopay-settings', {

    onSetMod: {

        js: function() {
            this.settingsModel = BEM.MODEL
                .getOne('m-autopay-settings')
                .on(
                    'autopay_mode paymethod_type payment_sum remaining_sum paymethod_id payerType person_id',
                    'change',
                    this._checkSaveButton,
                    this
                );

            this._saveButton = this.findBlockInside('save', 'button');

            if (this._saveButton) {
                this._saveButton.on('click', this._save, this);
            }

            if (this._getOferta()) {
                this._getOferta().on('change', this._checkSaveButton, this);
            }
        }
    },

    /**
     * Находит и кэширует блок оферты
     * @returns {*|BEM|BEM.DOM}
     * @private
     */
    _getOferta: function() {
        return this._oferta || (this._oferta = this.findBlockInside('oferta-checkbox', 'checkbox'));
    },

    /**
     * Возвращает true, если принята оферта или она отсутствует
     * @returns {boolean}
     * @private
     */
    _isOfertaAccept: function() {
        return this._getOferta() ? this._getOferta().isChecked() : true;
    },

    /**
     * Выставляет состояние disabled кнопке «Сохранить»
     * @private
     */
    _checkSaveButton: function() {
        var hasOferta = this._getOferta(),
            isOfertaAccept = this._isOfertaAccept(),
            isAutopayDisabled = this.settingsModel.get('autopay_mode') == 'none',
            isModelChanged = this.settingsModel.isChanged(),
            isModelValid = this.settingsModel.isValid(),
            buttonDisabled = '';

        if ((hasOferta && isAutopayDisabled) || !(isModelChanged && isModelValid && isOfertaAccept)) {
            buttonDisabled = 'yes';
        }

        this._saveButton.setMod('disabled', buttonDisabled);
    },

    /**
     * Возвращает параметры для сохранения настроек автоплатежа
     * @returns {Object}
     * @private
     */
    _getSubmitParams: function() {
        var params = {
            cmd: 'ajaxSaveAutopaySettings',
            csrf_token: u.consts('csrf_token'),
            json_autopay: JSON.stringify(this.settingsModel.value())
        };

        if (u.consts('ulogin')) {
            params.ulogin = u.consts('ulogin');
        }

        if (this._isOfertaAccept() && this.settingsModel.get('autopay_mode') != 'none') {
            params.offer_agreement = 1;
        }

        return params;
    },

    /**
     * Выполняет запрос
     * @param {Object} params - параметры запроса
     * @returns {*}
     * @private
     */
    _doRequest: function(params) {
        var deferred = $.Deferred();

        this._request || (this._request = BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            type: 'POST',
            dataType: 'json',
            cache: false,
            callbackCtx: this
        }));

        this._request.get(
            params,
            function(data) {
                data.result == 'ok' ?
                    deferred.resolveWith(this, arguments) :
                    deferred.rejectWith(this, arguments);
            },
            function(error) {
                deferred.rejectWith(this, arguments)
            });

        return deferred.promise();
    },

    /**
     * Запрос сохранения настроек
     * @private
     */
    _save: function() {
        this.setMod(this.elem('status-message'), 'progress', 'yes');

        this._saveButton.setMod('disabled', 'yes');

        u.payment.setOfferAccepted();
        this._doRequest(this._getSubmitParams())
            .done(this._onSaveSuccess)
            .fail(this._onSaveError);

    },

    /**
     * Редирект на страницу общего счета при успешном сохранении
     * @private
     */
    _onSaveSuccess: function(data) {
        window.location.href = this.params.retpath ?
            this.params.retpath :
            u.getUrl('showCamps', { ulogin: u.consts('ulogin') });
    },

    /**
     * Показывает ошибки
     * @param {Object} data
     * @private
     */
    _onSaveError: function(data) {
        this.elem('errors').text(typeof data.error == 'string' ? data.error : iget2('p-autopay-settings', 'oshibka-soedineniya-s-serverom', 'Ошибка соединения с сервером'));

        this.setMod(this.elem('errors'), 'show', 'yes');

        this._saveButton.delMod('disabled');
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('init', 'b-autopay-settings')
    }

});
