match(function() {
    return this.data.cmd === 'searchBanners';
})(

    block('app-main').mode('page-block')('p-banners-search'),

    block('b-page').mode('title')(function() {
        return iget2('p-banners-search', 'search-adds', 'Поиск объявлений');
    })
);

block('p-banners-search')(

    def()(function() {
        if (this.data.banners) {
            this.data.banners.forEach(function(banner) {
                banner.has_site_enum = 'yes';
                if (!banner.href && banner.turbolanding) {
                    banner.has_site_enum = 'no';
                }
            });
        }
        return applyNext({
            banners: this.data.banners
        });
    }),

    addJs()(true),

    content()(function() {
        var isAgency = this.data.login_rights.role === 'agency';

        return {
            block: 'l-page',
            mods: {
                layout: '16-80'
            },
            content: {
                elem: 'row',
                left: true,
                right: [
                    {
                        block: 'b-page-title',
                        mix: [{
                            block: 'p-banners-search',
                            elem: 'title'
                        }],
                        title: iget2('p-banners-search', 'search-adds', 'Поиск объявлений')
                    },
                    {
                        block: 'b-banners-search-form',
                        mods: {
                            type: isAgency ? 'agency' : ''
                        },
                        mix: [{
                            block: 'p-banners-search',
                            elem: 'form'
                        }]
                    },
                    (this.data.banners || []).length ?
                        {
                            block: 'p-banners-search',
                            elem: 'found'
                        } :
                    this.data.FORM.what && {
                        block: 'p-banners-search',
                        elem: 'nothing-found',
                        content: {
                            block: 'icon-text',
                            mods: {
                                size: 'xs',
                                theme: 'info'
                            },
                            text: iget2('p-banners-search', 'nothing-found', 'По запросу ничего не нашлось. Проверьте корректность запроса')
                        }
                    }
                ]
            }
        };
    }),

    elem('found')(

        def()(function() {
            var data = this.data,
                form = data.FORM,
                bannersCount = data.banners && data.banners.length,
                login_rights = data.login_rights,
                isBannersEditable = hasLoginRights('super_control', 'support_control', 'placer_control'),
                script_for_show = form.what && form.what.indexOf('media') != -1 ?
                    data.SCRIPT_BANNER :
                    data.SCRIPT_DIRECT,
                isAgency = this.data.login_rights.role === 'agency';

            return applyNext({
                dataTypes: {
                    cid: {
                        key: 'cid',
                        title: iget2('p-banners-search', 'kampaniya', 'кампания'),
                        transformData: function(banner) {
                            return [
                                {
                                    block: 'link',
                                    content: banner.cid,
                                    url: u.formatUrl({
                                        host: script_for_show,
                                        query: data.login_rights.manager_control ?
                                            {
                                                cmd: 'search',
                                                searchcid: banner.cid,
                                                who: 'camps'
                                            } :
                                            {
                                                cmd: 'showCamp',
                                                cid: banner.cid,
                                                ulogin: banner.login,
                                                tab: 'all'
                                            }
                                    })
                                },
                                !isAgency && {
                                    elem: 'billing',
                                    content: [
                                        '(',
                                        {
                                            block: 'link',
                                            content: iget2('p-banners-search', 'billing', 'биллинг'),
                                            url: u.formatUrl({
                                                protocol: 'https',
                                                host: u.consts('balance_admin'),
                                                path: 'order.xml',
                                                query: {
                                                    service_cc: 'PPC',
                                                    service_order_id: banner.cid
                                                }
                                            })
                                        },
                                        ')'
                                    ]
                                }
                            ];
                        }
                    },
                    campName: {
                        key: 'camp_name',
                        title: iget2('p-banners-search', 'nazvanie', 'название')
                    },
                    login: {
                        key: 'login',
                        title: iget2('p-banners-search', 'login-104', 'логин'),
                        transformData: function(banner) {
                            return {
                                block: 'link',
                                url: u.formatUrl({
                                    host: script_for_show,
                                    query: login_rights.manager_control ?
                                        {
                                            cmd: 'search',
                                            searchlogin: banner.login,
                                            who: 'camps'
                                        } :
                                        {
                                            cmd: 'showCamps',
                                            ulogin: banner.login
                                        }
                                }),
                                content: banner.FIO + ' (' + banner.login + ')'
                            };
                        }
                    },
                    campStatus: {
                        key: 'camp_status',
                        title: iget2('p-banners-search', 'status-105', 'статус'),
                        transformData: function(banner) {
                            return banner.camp_status.text;
                        }
                    },
                    bid: {
                        key: 'bid',
                        title: iget2('p-banners-search', 'ad', 'объявление'),
                        transformData: function(banner) {

                            var content = (form.what.match('media') ? 'T' : 'M') + '-' + banner.bid;

                            hasLoginRights('super_control', 'superreader_control', 'support_control',
                                'limited_support_control', 'placer_control') &&
                                banner.image_id &&
                                (content += ',<br/>М-' + banner.image_id); // eslint-disable-line require-iget2

                            return {
                                block: 'p-banners-search',
                                elem: 'banner-number',
                                content: content
                            };
                        }
                    },
                    price: {
                        key: 'price',
                        title: iget2('p-banners-search', 'cena', 'цена')
                    },
                    currency: {
                        key: 'currency',
                        title: iget2('p-banners-search', 'valyuta', 'валюта'),
                        transformData: function(banner) {
                            return u.currencies.getName(banner.currency);
                        }
                    },
                    href: {
                        key: 'href',
                        title: iget2('p-banners-search', 'ssylka', 'ссылка'),
                        transformData: function(banner) {
                            return {
                                block: 'link',
                                mix: [{
                                    block: 'p-banners-search',
                                    elem: 'banner-url'
                                }],
                                url: u.formatHref(banner.href),
                                content: form.what.match('media') ? banner.href : banner.domain
                            };
                        }
                    },
                    geoText: {
                        key: 'geo_text',
                        title: iget2('p-banners-search', 'region', 'регион'),
                        transformData: function(banner) {
                            return {
                                block: 'p-banners-search',
                                elem: 'geo-text',
                                attrs: {
                                    title: banner.geo_text
                                },
                                content: banner.banner_type === 'cpm_outdoor' ?
                                    '&mdash;' :
                                    u.hellipCut(banner.geo_text, 120)
                            };
                        }
                    },
                    mafio: {
                        key: 'mafio',
                        title: isAgency ?
                            iget2('p-banners-search', 'predstavitel-agentstva', 'представитель агентства') :
                            iget2('p-banners-search', 'menedzher-agentstvo', 'менеджер/агентство'), // DIRECT-71103
                        transformData: function(banner) {
                            var res = [],
                                agentInfo;

                            if (banner.alogin) {
                                agentInfo = u.escapeHTML(banner.afio) + ' (' + u.escapeHTML(banner.alogin) + ')';
                                if (!isAgency) {
                                    agentInfo = iget2('p-banners-search', 'agentstvo', 'Агентство') + ': ' + agentInfo;
                                }
                                res.push(agentInfo);
                            }
                            if (banner.mlogin && !isAgency) { // DIRECT-71103
                                if (res.length) res.push('<br/>');

                                res.push(
                                    iget2('p-banners-search', 'menedzher', 'Менеджер') + ': ' + u.escapeHTML(banner.mfio),
                                    ' (', {
                                        block: 'link',
                                        url: 'mailto:' + banner.memail,
                                        content: banner.mlogin
                                    },
                                    ')');
                            }

                            return res;
                        }
                    },
                    bannerPreview: {
                        title: bannersCount == 500 ?
                            {
                                block: 'p-banners-search',
                                elem: 'warning',
                                content: iget2('p-banners-search', 'naydeno-bolee-500-rezultatov', 'Найдено более 500 результатов, выводятся первые 500') + ':'
                            } :
                            iget2('p-banners-search', 'found-ads', 'Найденные объявления') + ':',
                        mods: {
                            sortable: 'no'
                        },
                        mix: [bannersCount == 500 && {
                            block: 'p-banners-search',
                            elem: 'warning'
                        }],
                        transformData: function(banner) {
                            var campaign = u._.find(data.campaigns_list, function(c) {
                                    return c.cid == banner.cid;
                                }) || {},
                                group = u._.find(campaign.groups, function(g) {
                                    return g.adgroup_id == banner.pid;
                                }) || {},
                                organizations = data.organizations || {};

                            return [
                                {
                                    block: 'b-banners-search-banner',
                                    mods: {
                                        type: u.beminize(banner.mediaType || 'text')
                                    },
                                    banner: banner,
                                    campaign: campaign,
                                    group: group,
                                    isBannersEditable: isBannersEditable,
                                    script_for_show: script_for_show,
                                    organization: banner.permalink && organizations[banner.permalink]
                                },
                                data.FORM.where == 'direct' && banner.archived != 'Yes' && isBannersEditable &&
                                    banner.mediaType != 'performance' && banner.type != 'cpm_price' && {
                                        block: 'link',
                                        target: '_blank',
                                        mix: [{
                                            block: 'p-banners-search',
                                            elem: 'stop-and-remoderate',
                                            js: { useBanner: group.adgroup_type == 'mcbanner' }
                                        }],
                                        url: u.getUrl('stopAndRemoderateBanner', {
                                            bid: banner.bid,
                                            bids: banner.bid,
                                            cid: banner.cid,
                                            adgroup_ids: banner.pid
                                        }),
                                        content: iget2('p-banners-search', 'ostanovit-i-peremoderirovat', 'Остановить и перемодерировать')
                                    }
                            ];
                        }
                    }
                }
            });
        }),

        content()(function() {

            var data = this.data,
                dataTypes = this.dataTypes,
                form = data.FORM || {},
                columns,
                sortBy = form.sort,
                banners = this.data.banners.map(function(banner) {
                    var b = banner;

                    // поле mafio используется для сортировки по столбцу
                    b.mafio = '';
                    if (b.alogin) {
                        b.mafio += iget2('p-banners-search', 'agentstvo', 'Агентство') + ': ' + b.afio;
                    }
                    if (b.mlogin) {
                        b.mafio += iget2('p-banners-search', 'menedzher', 'Менеджер') + ': ' + b.mfio;
                    }

                    return b;
                }, this),
                needToShowReportMessage = form.send_xls_report_by_email == 1,
                needToShowIncompleteSearchMessage = data.found_more_rows_than_limit == 1 && !needToShowReportMessage;

            columns = form.group_camp ? [
                dataTypes.cid,
                dataTypes.campName,
                dataTypes.login,
                dataTypes.campStatus,
                dataTypes.mafio
            ] : [
                dataTypes.bannerPreview,
                dataTypes.cid,
                dataTypes.bid,
                (form.what == 'phrase') && dataTypes.price,
                (form.what == 'phrase') && dataTypes.currency,
                dataTypes.href,
                dataTypes.geoText,
                dataTypes.login,
                dataTypes.campStatus,
                dataTypes.mafio
            ];

            return [
                data.strict_search_failed && {
                    elem: 'warning',
                    content: iget2(
                        'p-banners-search',
                        'rezultaty-po-tochnomu-sootvetstviyu',
                        'Результаты по точному соответствию не найдены. Показаны результаты поиска без учета точного соответствия'
                    )
                },
                needToShowReportMessage && {
                    elem: 'warning',
                    content: iget2(
                        'p-banners-search',
                        'zapros-na-formirovanie-otcheta',
                        'Запрос на формирование отчета с результатами поиска поставлен в очередь'
                    )
                },
                needToShowIncompleteSearchMessage && {
                    elem: 'warning',
                    content: iget2(
                        'p-banners-search',
                        'vyvedeny-ne-vse-poluchennye',
                        'Выведены не все полученные результаты. Вы можете получить всё, заказав {report}.',
                        {
                            report: function(text) {
                                var urlParams = u.getUrlParams(['cmd']);  // добавляем в текущий url send_xls_report_by_email

                                Object.keys(urlParams).forEach(function(key) {
                                    if (urlParams[key] == null) {
                                        urlParams[key] = '';
                                    }
                                });

                                urlParams['send_xls_report_by_email'] = 1;

                                return {
                                    block: 'link',
                                    url: u.getUrl(u.consts('cmd'), urlParams),
                                    content: text
                                };
                            }(iget2('p-banners-search', 'vyvedeny-ne-vse-poluchennye-param-report', 'отчет на почту')),

                            context: 'report - отчет на почту'
                        }
                    )
                },
                form.where === 'direct' && {
                    elem: 'models-data'
                },
                {
                    block: 'b-data-table',
                    mods: {
                        sortable: 'server',
                        'has-num-column': form.group_camp ? 'yes' : ''
                    },
                    mix: [
                        {
                            block: 'b-style-table',
                            mods: {
                                theme: 'gray-list'
                            }
                        },
                        {
                            block: 'p-banners-search',
                            elem: 'banners-table'
                        }
                    ],
                    mixes: {
                        row: [{
                            block: 'b-style-table',
                            elem: 'row'
                        }],
                        headerRow: [{
                            block: 'b-style-table',
                            elem: 'head'
                        }],
                        cell: function(key) {
                            return [{
                                block: 'b-style-table',
                                elem: 'cell'
                            }];
                        },
                        headerCell: function(key) {
                            return [{
                                block: 'b-style-table',
                                elem: 'cell'
                            }];
                        }
                    },
                    sortFunction: function(a, b) {
                        if (typeof a[sortBy] === 'undefined' || typeof b[sortBy] === 'undefined') return;

                        var first = typeof a[sortBy] === 'string' ?
                            a[sortBy].toLowerCase() :
                            a[sortBy].text ?
                            a[sortBy].text :
                            a[sortBy],
                            second = typeof b[sortBy] === 'string' ?
                            b[sortBy].toLowerCase() : b[sortBy].text ?
                            b[sortBy].text :
                            b[sortBy];

                        if (first < second) {
                            return -1;
                        } else if (first == second) {
                            return 0;
                        } else {
                            return 1;
                        }
                    },
                    columns: columns,
                    rows: banners
                }
            ];
        })
    ),

    elem('models-data').content()(function() {
        return {
            block: 'i-model-aggregator',
            content: (this.data.campaigns_list || []).map(function(campaign) {
                var mediaType = campaign.type;

                return [{
                    block: 'i-model',
                    modelParams: {
                        name: u.campaign.getCampaignModelName(mediaType),
                        id: campaign.cid,
                        data: u._.extend(campaign, {
                            mediaType: mediaType
                        })
                    }
                }].concat((campaign.groups || []).map(function(group) {
                    //cyn@DIRECT-74889: для кампаний типа сделки в группу adgroup_type приходит `cpm_banner`, вместо `cpm_deals`
                    if (mediaType === 'cpm_deals') {
                        group.adgroup_type = 'cpm_deals';
                    }

                    // skywhale@TODO: DIRECT-45870: унести на серверсайд
                    var type = group.adgroup_type === 'base' ? 'text' : group.adgroup_type,
                        groupName = u.campaign.getGroupModelName(type);

                    // заглушка под баннеры необходима для dm-dynamic-media-group.utils.js
                    group.banners || (group.banners = []);

                    return {
                        block: 'i-model',
                        modelParams: {
                            name: groupName,
                            id: group.adgroup_id,
                            data: u[groupName].transformData({
                                group: group
                            })
                        }
                    };
                }));
            }, this).concat(this.data.banners.map(function(banner) {
                var data = this.data,
                    campaign = u._.find(data.campaigns_list, function(c) {
                        return c.cid == banner.cid;
                    }) || {},
                    group = u._.find(campaign.groups, function(g) {
                        return g.adgroup_id == banner.pid;
                    }) || {},
                    // skywhale@TODO: DIRECT-45870: унести на серверсайд
                    type = group.adgroup_type === 'base' ? 'text' : group.adgroup_type;

                // DIRECT-61150 если с сервера не приходит протокол, пытаемся взять из href
                banner.url_protocol || (banner.url_protocol = u.getUrlProtocol(banner.href));

                return {
                    block: 'i-model',
                    modelParams: {
                        name: u.campaign.getBannerModelName(type),
                        parentName: u.campaign.getGroupModelName(type),
                        parentId: group.adgroup_id,
                        id: banner.bid,
                        data: u.bannerModelData({
                            banner: banner,
                            group: group
                        })
                    }
                };
            }, this))
        };
    })
);
