BEM.DOM.decl('p-banners-search', {

    /**
     * Обработчик события pointerclick по «Остановить и перемодерировать»
     * @param {Event} e
     * @private
     */
    _onStopAndRemoderateClick: function(e) {
        var href = e.data.domElem.attr('href');

        e.preventDefault();

        BEM.blocks['b-user-dialog'].confirm({
            message: this.elemParams('stop-and-remoderate').useBanner ?
                iget2(
                    'p-banners-search',
                    'vy-uvereny-chto-hotite',
                    'Вы уверены, что хотите ОСТАНОВИТЬ показы и отправить баннер на ПЕРЕМОДЕРАЦИЮ?'
                ) :
                iget2(
                    'p-banners-search',
                    'vy-uvereny-chto-hotite-106',
                    'Вы уверены, что хотите ОСТАНОВИТЬ показы и отправить объявление на ПЕРЕМОДЕРАЦИЮ?'
                ),
            confrimButtonText: iget2('p-banners-search', 'da', 'Да'),
            cancelButtonText: iget2('p-banners-search', 'net', 'Нет'),
            onConfirm: function() {
                window.open(href, '_blank');
            }
        });
    }

}, {
    live: function() {

        this.liveBindTo('stop-and-remoderate', 'pointerclick', function(e) {
            this._onStopAndRemoderateClick(e);
        });

    }
});
