match(function() {
    return this.data.cmd === 'sendCampaignOptimizingEmail';
})(
    block('app-main').mode('page-block')('p-campaign-help-request-success'),

    block('b-page').mode('title')(function() {
        return iget2(
            'p-campaign-help-request-success',
            'podtverzhdenie-zayavki-na-optimizaciyu',
            'Подтверждение заявки на оптимизацию рекламных кампаний'
        );
    })
);

/**
 * Страничный блок
 * @namespace p-campaign-help-request-success
 */
block('p-campaign-help-request-success').content()(function() {
    var ulogin = u.consts('ulogin');

    return {
        block: 'l-page',
        mods: {
            layout: '84'
        },
        mix: { block: this.block, elem: 'inner' },
        content: [
            {
                elem: 'row',
                center: {
                    block: 'b-page-title',
                    mix: { block: 'p-campaign-help-request-success', elem: 'title' },
                    title: iget2('p-campaign-help-request-success', 'vasha-zayavka-prinyata', 'Ваша заявка принята!')
                }
            },
            {
                elem: 'row',
                center: [
                    {
                        block: this.block,
                        elem: 'content-item',
                        content: iget2(
                            'p-campaign-help-request-success',
                            'zayavka-budet-rassmotrena-v',
                            'Заявка будет рассмотрена в ближайшие три рабочих дня.'
                        )
                    },
                    {
                        block: this.block,
                        elem: 'content-item',
                        content: iget2(
                            'p-campaign-help-request-success',
                            'kogda-my-zakonchim-rabotu',
                            'Когда мы закончим работу, в выбранной кампании появится раздел "Медиаплан" с готовыми ключевыми фразами и объявлениями.<br>Вы можете перенести их полностью или выборочно в существующую кампанию и сразу отправить на модерацию.<br>Мы оставляем за собой право отказать в выполнении заявки.'
                        )
                    },
                    {
                        block: 'link',
                        url: u.getUrl('showCamps', ulogin ? {
                            ulogin: ulogin
                        } : null),
                        content: {
                            block: 'button',
                            mods: {
                                size: 's'
                            },
                            content: iget2('p-campaign-help-request-success', 'vernutsya-v-direkt', 'Вернуться в Директ')
                        }
                    }
                ]
            }
        ]
    };
});
