match(function() {
    return this.data.cmd === 'orderCampaignOptimizing';
})(
    block('app-main')(
        mode('preprocess')(function() {
            var campaigns = this.data.campaigns.map(function(camp) {
                var total = +camp.total + +camp.wallet_total,
                    clicks = +camp.clicks;

                return {
                    login: camp.login,
                    cid: camp.cid,
                    name: camp.name,
                    clicks: isFinite(clicks) ? clicks : 0,
                    left: isFinite(total) ? total : null,
                    walletIsEnabled: Boolean(camp.wallet_is_enabled)
                }
            });

            this.data.dataPage = {
                campaigns: campaigns,
                currencyNameShort: this.data.work_currency
            };

            return this.data;
        }),

        mode('page-block')('p-campaign-help-request')
    ),

    block('b-page').mode('title')(function() {
        return iget2('p-campaign-help-request', 'kak-privlech-bolshe-klientov', 'Как привлечь больше клиентов?');
    })
);

/**
 * Страничный блок
 * @param {{ }[]} ctx.campaigns массив кампаний
 * @param {String} currencyNameShort название валюты клиента
 * @namespace p-campaign-help-request
 */
block('p-campaign-help-request').content()(function() {
    var ctx = this.data.dataPage;

    return {
        block: 'l-page',
        mods: {
            layout: '84'
        },
        content: [
            {
                elem: 'row',
                center: {
                    block: 'b-page-title',
                    mix: { block: 'p-campaign-help-request', elem: 'title' },
                    title: iget2('p-campaign-help-request', 'kak-privlech-bolshe-klientov', 'Как привлечь больше клиентов?')
                }
            },
            !this.data.campaigns.length ? {
                elem: 'row',
                center: {
                    block: this.block,
                    elem: 'no-active-camps'
                }
            } : [
                {
                    elem: 'row',
                    center: [
                        {
                            block: this.block,
                            elem: 'introduction',
                            content: [
                                iget2(
                                    'p-campaign-help-request',
                                    'chem-bolshe-polzovateley-yandeksa',
                                    'Чем больше пользователей Яндекса увидят вашу рекламу, соответствующую их запросам, тем больше клиентов вы сможете получить.'
                                ),
                                iget2(
                                    'p-campaign-help-request',
                                    'odnako-pri-podbore-klyuchevyh',
                                    'Однако при подборе ключевых фраз сложно учесть все запросы, по которым ищут ваши товары и услуги, и есть риск упустить потенциально конверсионные фразы.'
                                )
                            ].join(' ')
                        },
                        {
                            block: this.block,
                            elem: 'introduction',
                            content: iget2(
                                'p-campaign-help-request',
                                'my-besplatno-pomozhem-nayti',
                                'Мы бесплатно поможем найти такие фразы, а ещё подготовим для них тексты объявлений и посадочные страницы.'
                            )
                        },
                        ctx.campaigns.length > 2 && {
                            block: this.block,
                            elem: 'manual',
                            content: iget2('p-campaign-help-request', 'vyberite-do-2-h', 'Выберите до 2-х кампаний, которые вы хотите улучшить') + ':'
                        }
                    ]
                },
                {
                    elem: 'row',
                    center: {
                        block: 'b-campaign-optimizer-request',
                        mix: {
                            block: this.block,
                            elem: 'indent-inner'
                        },
                        currencyNameShort: ctx.currencyNameShort,
                        campaigns: ctx.campaigns
                    }
                }
            ]
        ]
    };
});
