match(function() {
    return this.data.campaign && this.data.campaign.mediaType == 'content-promotion' &&
        (/^(editCamp|saveCamp|saveNewCamp|showCampSettings)$/).test(this.data.cmd);
})(
    block('app-main')(

        mode('preprocess')(function() {
            var data = applyNext(),
                campaign = data.campaign;

            campaign.metrika = {
                campaign_goals: Object.keys(campaign.campaign_goals).map(function(id) {
                    return campaign.campaign_goals[id];
                }),
                compaign_domains_count: data.compaign_domains_count,
                cpa_deviation: !!+(campaign.autobudget_cpa_warning && campaign.autobudget_cpa_warning.cpa_deviation) ||
                    false,
                apc_deviation: !!+(campaign.autobudget_cpa_warning && campaign.autobudget_cpa_warning.apc_deviation) ||
                    false
            };

            return data;
        }),

        mode('page-block')({
            block: 'p-campaign-settings',
            mods: {
                type: 'content-promotion'
            }
        })
    )
);
