match(function() {
    return this.data.campaign && this.data.campaign.mediaType === 'cpm_yndx_frontpage' &&
        (/^(editCamp|saveCamp|saveNewCamp|showCampSettings)$/).test(this.data.cmd);
})(
    block('app-main')(

        mode('preprocess')(function() {
            var data = applyNext(),
                campaign = data.campaign,
                campaignFrontpageTypes = campaign.allowed_frontpage_types || [];

            campaign.dmParams = {
                name: 'dm-cpm-yndx-frontpage-campaign',
                id: campaign.cid
            };

            // по дефолту должны быть выбраны все варинты размещения
            if (!campaignFrontpageTypes.length) {
                campaign.allowed_frontpage_types = ['frontpage', 'frontpage_mobile', 'browser_new_tab'];
            }

            return data;
        }),

        mode('page-block')({
            block: 'p-campaign-settings',
            mods: {
                type: 'cpm-yndx-frontpage'
            }
        })
    )
);
