match(function() {
    return this.data.campaign && this.data.campaign.mediaType == 'mobile_content' &&
            (/^(editCamp|saveCamp|saveNewCamp|showCampSettings)$/).test(this.data.cmd);
})(

    block('app-main')(

        mode('preprocess')(function() {
            var data = applyNext(),
                campaign = data.campaign,
                autobudgetCPIWarnings = campaign.autobudget_cpi_warning || {};

            campaign.device_type_targeting = campaign.device_type_targeting ?
                campaign.device_type_targeting.split(',') :
                ['phone', 'tablet'];

            campaign.network_targeting = campaign.network_targeting ?
                campaign.network_targeting.split(',') :
                ['wifi', 'cell'];

            campaign.dmParams = {
                name: 'dm-mobile-content-campaign',
                id: campaign.cid
            };

            campaign.rmpCounters = {
                allow_autobudget_avg_cpi: 1,
                decrease_setup: autobudgetCPIWarnings.decrease_setup,
                cpi_deviation: autobudgetCPIWarnings.cpi_deviation,
                apps_count: autobudgetCPIWarnings.apps_count,
                setup_deviation: autobudgetCPIWarnings.setup_deviation
            };

            if (data.app_list && data.app_list.length === 1) {
                campaign.selected_mobile_app = data.app_list[0];
            }

            return data;
        }),

        mode('page-block')({
            block: 'p-campaign-settings',
            mods: {
                type: 'mobile-content'
            }
        })
    )
);
