match(function() {
    return this.data.campaign && this.data.campaign.mediaType == 'performance' &&
            (/^(editCamp|saveCamp|saveNewCamp|showCampSettings)$/).test(this.data.cmd);
})(

    block('app-main')(

        mode('preprocess')(function() {
            var data = applyNext(),
                campaign = data.campaign,
                defStrategy = {
                    name: 'autobudget_avg_cpc_per_camp',
                    avg_bid: null,
                    bid: null,
                    sum: null
                };

            campaign.dmParams = {
                name: 'dm-dynamic-media-campaign',
                id: campaign.cid
            };

            campaign.strategy || (campaign.strategy = {
                is_search_stop: '',
                search: defStrategy,
                is_net_stop: '',
                name: 'autobudget_avg_cpc_per_camp',
                net: defStrategy,
                is_autobudget: ''
            });

            // Для СМАРТ кампаний настройка «Размечать ссылки для Метрики»
            // всегда выбрана и не активна, поэтому всегда тут true
            // на случай серверной валидации
            campaign.status_click_track = true;

            return data;
        }),

        mode('page-block')({
            block: 'p-campaign-settings',
            mods: {
                type: 'performance'
            }
        })
    )
);
