match(function() {
    return (/^(editCamp|saveCamp|saveNewCamp|showCampSettings)$/).test(this.data.cmd);
})(

    block('app-main')(

        mode('preprocess')(
            (function() {
                var data = this.data,
                    addToDropdown = data.add_to_dropdown,
                    defaultCamp = data.default_new_camp,
                    campaign = data.campaign || {},
                    campaignOpts = campaign.opts || {},
                    // campaign.strategy приходит пустое на Баяне
                    strategy = campaign.strategy = campaign.strategy || {
                        is_search_stop: '',
                        search: {
                            name: 'default'
                        },
                        is_net_stop: '',
                        name: '',
                        net: {
                            name: 'default'
                        },
                        is_autobudget: ''
                    },
                    times = campaign.sms_time ? campaign.sms_time.split(':') : [],
                    platforms,
                    isCPMCampaign = u._.includes(['cpm_banner', 'cpm_deals'], campaign.mediaType);

                campaign.dmParams = {
                    name: 'm-campaign',
                    id: campaign.cid
                };

                data.FORM.retpath = data.FORM.retpath || ''; // может придти null

                strategy.search = strategy.search || {};
                strategy.net = strategy.net || {};
                campaign.campaign_goals = campaign.campaign_goals || {};
                // Особенности настройки «Размечать ссылки для Метрики»
                // Если снять чекбокс и отправить форму с ошибкой, то сервер вернет undefined
                // После из default_new_camp берем его, а там он всегда 1
                // Поэтому именно тут запоминаем и преобразовываем значение настройки
                campaign.status_click_track = !!+campaign.status_click_track;

                if (defaultCamp) {
                    Object.keys(defaultCamp).forEach(function(f) {
                        if (typeof campaign[f] === 'undefined' || campaign[f] === null)
                            campaign[f] = defaultCamp[f];
                    });
                }

                // Поле "last_bidder_restart_time" на фронте никак не используется и не должно передаваться на сервер при сохранении кампании.
                // Со стороны backend'а поле сложно убрать из данных передаваемых на фронт, поэтому нужно со стороны фронта тоже его убрать.
                // Правка из-за бага в проде: https://st.yandex-team.ru/DIRECTSUP-35094
                delete strategy.last_bidder_restart_time;
                delete strategy.search.last_bidder_restart_time;
                delete strategy.net.last_bidder_restart_time;

                platforms = u['b-dont-show-domains'].separatePlatforms(campaign.DontShow, data.ssp_platforms);

                campaign = data.campaign = u._.extend(campaign, {
                    day_budget2: campaign.day_budget,
                    strategy2: u['b-campaign-strategy2'].buildStrategy(campaign),
                    isCampaign: true,
                    is_finish_date_set: !!campaign.finish_date,
                    ssp_platforms: platforms.sspDictionary,
                    disabled_ssp: platforms.disabledSsp,
                    DontShow: platforms.disabledDomains,
                    require_filtration_by_dont_show_domains: !!campaignOpts.require_filtration_by_dont_show_domains,
                    sms_flags: campaign.sms_flags || {},
                    sms_phone: data.sms_phone,
                    sms_time_hour_from: times[0],
                    sms_time_min_from: times[1],
                    sms_time_hour_to: times[2],
                    sms_time_min_to: times[3],
                    ContextPriceCoef: campaign.hasOwnProperty('ContextPriceCoef') ? campaign.ContextPriceCoef : 100,
                    search_strategy: strategy.search.name,
                    // бэк не может гарантировать тип переменной, поэтому не строгое равенство
                    isCpaPayForConversionEnabled: strategy.search.pay_for_conversion == 1 ||
                        strategy.net.pay_for_conversion == 1,
                    all_goals_deleted: 1,
                    all_counters_deleted: 1,
                    statusContextStop: campaign.statusContextStop || 0,
                    autobudget_limit_clicks: campaign.autobudget_limit_clicks || data.FORM.autobudget_limit_clicks,
                    metrika_counters: campaign.metrika_counters || '',
                    minus_words: data.FORM.json_campaign_minus_words || campaign.minus_words || [],
                    email_notify_paused_by_day_budget: campaign.email_notifications ?
                        campaign.email_notifications.paused_by_day_budget :
                        campaign.email_notify_paused_by_day_budget,
                    new_camp: data.FORM.new_camp === '1'
                });

                Object.keys(campaign.campaign_goals).forEach(function(goalId) {
                    if (campaign.campaign_goals[goalId].goal_status === 'Active' ||
                            goalId == campaign.autobudget_goal_id) {
                        campaign.all_goals_deleted = 0;
                    }

                    if (campaign.campaign_goals[goalId].counter_status == 'Active' ||
                            goalId == campaign.autobudget_goal_id) {
                        campaign.all_counters_deleted = 0;
                    }
                });

                campaign.timetargeting.timeTarget || (campaign.timetargeting.timeTarget = '');

                u._.assign(campaign, campaign.sms_flags);

                if (data.product_type) {
                    campaign.product_type = data.product_type;
                }

                if (campaign.strategy.name == 'different_places') {
                    campaign.ContextLimit = 0;
                    campaign.ContextPriceCoef = 100;
                }
                //для работы u.contextLimit
                campaign.ContextLimit = u.contextLimit.prepareValue(campaign.ContextLimit);

                campaign.device_targeting = Object.keys(campaign.device_targeting || {}).filter(function(device) {
                    return campaign.device_targeting[device] == 1;
                }).join(',');

                // Список доменов конкурентов. Может приходит с пробелами и с запятыми вперемешку.
                // Заменяем все на ", "
                campaign.competitors_domains = campaign.competitors_domains ?
                    campaign.competitors_domains.replace(/[,\s]+/gi, ', ') : '';

                // агентства
                if (addToDropdown == 'just_one_agency') {
                    data.currentAgency = data.for_agencies[0];
                } else if (addToDropdown == 'full' || addToDropdown == 'agencies') {
                    data.for_agencies.forEach(function(agency) {
                        if (data.new_camp_belonging === agency.login)
                            data.currentAgency = agency;
                    });
                }

                //  Данные для корректировки ставок
                u['i-adjustment-rates-data'].patchMultipliers(campaign, {
                    multipliers_meta: u._.get(campaign, 'multipliers_meta') || u._.get(data, 'multipliers_meta'),
                    modelId: campaign.cid || 'new_camp',
                    isDevicesEnabled: isCPMCampaign ||
                        (hasEnabledFeatures('cpc_device_modifiers') || u.consts('isMobileOsBidModifierEnabled')) &&
                        u._.includes(['text', 'dynamic', 'performance', 'content_promotion'], campaign.mediaType),
                    isWithoutDeviceRestrictions: isCPMCampaign || hasEnabledFeatures('cpc_device_modifiers'),
                    isCpmGroupTypeEnabled: u.consts('rights').allowedCpmVideoBanners
                });

                // @see DIRECT-86153
                var retargetingMultipliers = campaign.hierarchicalMultipliers.retargeting,
                    retargetingConditionIds = Object.keys(
                        u.retargeting.filterConditionsByType(this.data.all_retargeting_conditions, 'metrika_goals')
                    ).reduce(function(acc, next) {
                        acc[next] = true;
                        return acc;
                    }, {});

                // фильтруем корректировки в campaign.hierarchicalMultipliers, оставляем только те, у которых существуют ретаргетинги
                retargetingMultipliers.rates = retargetingMultipliers.rates.filter(function(rate) {
                    return retargetingConditionIds[rate.retargetingId];
                });

                return data;
            }),

            match(function() {
                return /mcb|performance|text|dynamic|content_promotion/.test(this.data.campaign.mediaType);
            })(function() {
                var data = applyNext(),
                    campaign = data.campaign;

                campaign.metrika = {
                    campaign_goals: Object.keys(campaign.campaign_goals).map(function(id) {
                        return campaign.campaign_goals[id];
                    }),
                    compaign_domains_count: data.compaign_domains_count,
                    cpa_deviation: !!+(campaign.autobudget_cpa_warning &&
                        campaign.autobudget_cpa_warning.cpa_deviation) || false,
                    apc_deviation: !!+(campaign.autobudget_cpa_warning &&
                        campaign.autobudget_cpa_warning.apc_deviation) || false
                };

                return data;
            })
        ),

        mode('page-block')('p-campaign-settings')
    ),

    block('b-page')(
        mode('content-only')(function() {
            return this.data.FORM.popupMode === '1';
        }),

        elem('stat').match(function() {
            return this.data.FORM.new_camp == 1;
        }).mode('metrikaParams')(function() {
            return u.getMetrikaVisitParams({
                'yd.point_create_camp_visit_page': true,
                'yd.first': (this.data.has_text_camps == 0 && this.data.has_media_camps == 0)
            });
        }),

        mode('title')(
            match(function() {
                return !(this.data.new_camp || this.data.continue_creating) && this.data.campaign.cid;
            })(function() {
                return iget2('p-campaign-settings', 'parametry-kampanii', 'Параметры кампании');
            }),

            match(function() {
                return (this.data.new_camp || this.data.continue_creating);
            })(function() {
                return iget2('p-campaign-settings', 'sozdanie-kampanii', 'Создание кампании');
            })
        ),

        elem('foot-js').match(function() {
            var data = this.data;

            return (/^(editCamp|saveCamp|saveNewCamp|showCampSettings)$/).test(data.cmd) &&
                (/text|dynamic/).test(data.campaign.mediaType);
        }).content()(function() {
            var result = applyNext(),
                langList = {
                    ru: 'ru-RU',
                    en: 'en-US',
                    tr: 'tr-TR',
                    ua: 'uk-UA'
                },
                langDnaVals = {
                    ru: 'ru',
                    en: 'en',
                    ua: 'uk',
                    by: 'be',
                    kz: 'kk',
                    tr: 'tr'
                },
                langDna = langDnaVals[this.data.lang];

            result.push({
                elem: 'js',
                url: u.formatUrl({
                    host: '//api-maps.yandex.ru',
                    path: '2.1',
                    query: {
                        lang: langList[this.data.lang] || langList.ru,
                        coordorder: 'longlat'
                    }
                })
            });

            return result;
        })
    )

);

block('p-campaign-settings')(
    content()(function() {
        var data = this.data;

        return {
            block: 'b-campaign-settings',
            mods: {
                edit: data.cmd === 'showCampSettings' ? 'no' : 'yes',
                type: u.beminize(data.campaign.mediaType || '')
            },
            campaign: data.campaign,
        };
    }),

    prependContent().match(function() {
        return this.data.cmd !== 'showCampSettings';
    })(function() {
        return { block: 'b-retargetings-data' };
    })
);
