match(function() {
    return this.data.cmd === 'showCampStatOfflineMessage';
})(

    block('app-main').mode('page-block')('p-campaign-stat-offline-message'),

    block('b-page').mode('title')(function() {
        return iget2('p-campaign-stat-offline-message', 'zakaz-xls-otchetov', 'Заказ xls-отчетов');
    })
);

block('p-campaign-stat-offline-message')(

    addJs()(function() {
        return {
            actionUrl: this.data.script
        };
    }),

    content()(function() {
        var cid = this.data.cid,
            ulogin = this.data.user_login;

        return [
            {
                block: 'l-page',
                mods: {
                    layout: '16-60-16'
                },
                content: [
                    iget2(
                        'p-campaign-stat-offline-message',
                        'statistika-v-xls-formate',
                        'Статистика в xls-формате будет подготовлена в соответствии с выбранными параметрами. Вы можете скачать готовый файл в разделе {link} на странице просмотра статистики.',
                        {
                            link: function(text) {
                                return {
                                    block: 'link',
                                    url: u.getUrl('listOfflineReports', {
                                        cid: cid,
                                        ulogin: ulogin
                                    }),
                                    content: text
                                };
                            }(iget2('p-campaign-stat-offline-message', 'statistika-v-xls-formate-param-link', '«Статистика в xls»')),

                            context: 'link - «Статистика в xls»'
                        }
                    ),
                    iget2(
                        'p-campaign-stat-offline-message',
                        'vremya-podgotovki-dannyh-zavisit',
                        'Время подготовки данных зависит от размера кампании и обычно составляет от 5 минут до часа.'
                    ),
                    {
                        block: 'p-campaign-stat-offline-message',
                        elem: 'form',
                        action: this.data.script,
                        cid: this.data.cid,
                        userLogin: this.data.user_login
                    }
                ]
                    .map(function(content) {
                        return {
                            elem: 'row',
                            left: '&nbsp',
                            right: '&nbsp',
                            rgap: true,
                            center: {
                                block: 'p-campaign-stat-offline-message',
                                elem: 'page-row',
                                content: content
                            }
                        };
                    })
            }
        ];
    }),

    elem('form').wrap()(function() {
        return {
            block: 'b-layout-form',
            mix: [
                {
                    block: 'i-form',
                    mods: {
                        submit: 'bem-event'
                    }
                },
                {
                    block: 'p-campaign-stat-offline-message',
                    elem: 'form'
                }
            ],
            method: 'GET',
            action: this.ctx.action,
            hiddenInputs: [
                {
                    name: 'cmd',
                    value: '',
                    mix: [{
                        block: 'p-campaign-stat-offline-message',
                        elem: 'hidden-cmd'
                    }]
                },
                {
                    name: 'detail',
                    value: 'Yes'
                },
                {
                    name: 'ulogin',
                    value: this.ctx.userLogin
                },
                {
                    name: 'cid',
                    value: this.ctx.cid
                }
            ],
            rows: [
                applyCtx({
                    block: 'p-campaign-stat-offline-message',
                    elem: 'buttons',
                    content: [
                        {
                            elem: 'cancel-button',
                            content: iget2('p-campaign-stat-offline-message', 'vernutsya-v-statistiku', 'Вернуться в статистику'),
                            type: 'reset'
                        },
                        {
                            elem: 'proceed-button',
                            content: iget2('p-campaign-stat-offline-message', 'pereyti-v-kampaniyu', 'Перейти в кампанию'),
                            type: 'submit'
                        }
                    ]
                })
            ]
        };
    }),

    elem('buttons').content()(function() {
        return (this.ctx.content || []).map(function(button) {
            return {
                block: 'button',
                mods: u._.extend({
                    size: 's',
                    theme: 'normal'
                }, button.mods),
                mix: [{
                    block: 'p-campaign-stat-offline-message',
                    elem: button.elem
                }],
                type: button.type,
                content: button.content
            };
        });
    })
);
