block('p-campaign-stat').elem('charts-manager').replace()(function() {
    var data = this.data,
        form = data.FORM,
        columns = data.columns,
        group_by = data.group_by,
        clientCurrency = data.client_currency,
        currencyName = u.currencies.getName(clientCurrency),
        goals = form.goals;

    return {
        block: 'b-charts-manager',
        mods: { 'save-user-options': 'yes' },
        mix: {
            block: 'p-campaign-stat',
            elem: 'charts-manager'
        },
        js: {
            clientCurrency: clientCurrency,
            reportData: {
                cid: data.cid,
                statType: data.statType,
                filters: data.filters,
                groupByDate: form.group_by_date,
                withNds: data.with_nds || 0,
                date: {
                    from: data.date_from,
                    to: data.date_to
                },
                attribution_model: data.attribution_model,
                goals: goals,
            }
        },
        content: [
            { elem: 'switcher' },
            {
                elem: 'filters',
                filtersMods: { limits: 'columns-groups' },
                view: data.USER_OPTIONS.stat_chart_view || undefined,
                columns: u['b-charts-manager'].applyGroup(columns.map(function(column, index) {
                    return {
                        text: u['text-store'].get({ currency: currencyName }, 'chart', column),
                        selected: index === 0 || index === 1 ? 'yes' : '',
                        value: column
                    };
                })),
                groups: group_by.map(function(group, index) {
                    return {
                        text: u['text-store'].get({ currency: currencyName }, 'chart', group),
                        selected: index === 0 && columns.length === 1 ? 'yes' : '',
                        value: group
                    };
                })
            },
            {
                elem: 'export',
                types: [
                    { text: 'PNG', MIME: 'image/png' },
                    { text: 'JPEG', MIME: 'image/jpeg' },
                    { text: 'SVG', MIME: 'image/svg+xml' }
                ],
                print: true
            },
            { elem: 'chart' }
        ]
    };
});
