block('p-campaign-stat').elem('info').replace()(function() {
    var data = this.data,
        ulogin = data.user_login,
        campsList = [],
        campaign = data.campaign,
        isInternalCampaign = u.consts('rights').enableInternalCampaigns && u.campaign.isInternal(campaign.type),
        briefRows = [];

    // В некоторых случаях ключ data.camps_name_only не приходит (например для МОК)
    !data.campaign.currency_archived && (data.camps_name_only || []).forEach(function(camp) {
        if (camp.cid != data.cid) {

            campsList.push({
                url: u.getUrl('showCampStat', {
                    detail: 'Yes',
                    types: 'days',
                    cid: camp.cid,
                    ulogin: ulogin
                }),
                name: camp.name,
                mediaType: camp.mediaType,
                cid: camp.cid,
                total: u.currencies.formatSum(camp.currency, camp.total, {
                    isPseudo: data.usePseudoCurrency
                })
            });
        }
    });

    if (+campaign.wallet_cid) {
        briefRows.push(
            ['start-date'],
            u._.compact([data.isCpmStat && 'shows', 'clicks'])
        );
    } else {
        data.campaign.currency != 'YND_FIXED' ?
            briefRows.push(
                ['start-date', 'rest-block'],
                u._.compact([data.isCpmStat && 'shows', 'clicks'])
            ) :
            briefRows.push(
                ['start-date', 'sum-block'],
                u._.compact([data.isCpmStat && 'shows', 'clicks', 'rest-block'])
            );
    }

    return {
        block: 'b-campaign-info',
        header: {
            headword: iget2('p-campaign-stat', 'statistika-kampanii', 'Статистика кампании'),
            allCampsUrl: isInternalCampaign ?
                u.formatUrl({
                    path: '/dna/grid/campaigns',
                    query: {
                        ulogin: ulogin
                    }
                }) :
                u.getUrl('showCamps', {
                    ulogin: ulogin
                }),
            campsList: campsList,
            cname: campaign.cname,
            cid: data.cid
        },
        isStatPage: true,
        state: {
            text: campaign.status.text
        },
        brief: {
            rows: briefRows,
            startDate: campaign.dd + '.' + campaign.mm + '.' + campaign.yyyy,
            clicks: campaign.clicks,
            sum: campaign.sum,
            total: campaign.total,
            walletCid: campaign.wallet_cid,
            blockedPayment: campaign.statusNoPay == 'Yes',
            blockedMoney: campaign.sum && campaign.money_type == 'blocked',
            canPay: campaign.statusNoPay == 'No' && (campaign.statusModerate == 'Yes' ||
                campaign.manager_uid || campaign.agency_uid),
            shows: campaign.shows
        }
    };
});
