block('p-campaign-stat').elem('wallet-budget-recommendation-notification')(
    content()(function() {
        var data = this.data,
            wallet = data.wallet,
            allWalletsArray = [],
            showAnyBudgetLimitNotification = !u._.isEmpty(data.daily_budget_notification) ||
                !u._.isEmpty(data.auction_probability_notification);

        if (!showAnyBudgetLimitNotification) {
            return null;
        }

        if (wallet.self) {
            allWalletsArray.push(u._.extend({}, wallet.self));
        }

        allWalletsArray = allWalletsArray.concat(u._.map(wallet.agencies, function(value, key) {
            return u._.extend({}, value, { agencyID: key });
        }));

        var activeWallet = u._.find(allWalletsArray, 'enabled', 1) || {},
            dayBudgetWarning = activeWallet.camp_stop_daily_budget_warning || {},
            dayLimitMessageId = 'day-budget-warning-' + activeWallet.wallet_cid + '-' + dayBudgetWarning.stop_time,
            dayLimitDismissed = data.COOKIES[u['b-page-warning'].generateCookieKey(dayLimitMessageId)] === '1';

        return {
            block: 'p-campaigns',
            elem: 'budget-limit-notification',
            wallet: activeWallet,
            auctionProbability: data.auction_probability_notification,
            dayLimit: {
                showTitle: allWalletsArray.length > 1
            },
            dayLimitMessageId: dayLimitMessageId,
            dayLimitDismissed: dayLimitDismissed,
            ulogin: data.user_login,
            place: 'stat',
            containerBlock: 'p-campaign-stat',
            isOldTheme: false
        };
    })
);
