block('app-main').match(function() {
    return this.data.cmd === 'showCampStat';
}).match(function() {
    return this.data.statistic_page_type === 'brand_safety';
})(
    block('app-main').mode('page-block')({
        block: 'p-campaign-stat',
        mods: {
            type: 'brand_safety'
        }
    }),

    block('b-page')(
        mode('title')(function() {
            return iget2('p-campaign-stat', 'brand-safety', 'Статитика по Brand Safety');
        })
    )
);

block('p-campaign-stat').mod('type', 'brand_safety')(
    elem('actions').def()(''),

    elem('stat-data').def()(''),

    elem('stat-footer').def()(''),

    elem('mass-actions').def()(''),

    elem('stat-actions-rows').def()(''),

    elem('show-banners-stat-button').def()(''),

    content()(function() {
        var data = this.data,
            showNewDailyBudgetRecommendations =
                data.features_enabled_for_client.show_daily_budget_recommendations_in_old_interface == 1;

        return [
            {
                block: 'p-campaign-stat',
                elem: 'models-data'
            },
            {
                block: 'l-page',
                content: [
                    {
                        elem: 'row',
                        right: true,
                        left: {
                            block: 'b-layout-table',
                            mix: [{
                                block: 'p-campaign-stat',
                                elem: 'head-layout'
                            }],
                            content: [
                                {
                                    elem: 'row',
                                    content: [{
                                        elem: 'cell',
                                        content: {
                                            block: 'p-campaign-stat',
                                            elem: 'info'
                                        }
                                    }, {
                                        elem: 'cell',
                                        content: {
                                            block: 'b-campaign-menu',
                                            options: {
                                                navMods: {
                                                    border: 'yes',
                                                    type: 'stat'
                                                },
                                                campOptionsViewOnly: (this.data.allow_edit_camp ||
                                                    this.data.campaign.allow_edit_camp) && !hasLoginRights('media_control')
                                            },
                                            mix: {
                                                block: 'p-campaign-stat',
                                                elem: 'campaign-menu-cell'
                                            }
                                        }
                                    }]
                                },
                                showNewDailyBudgetRecommendations && {
                                    elem: 'row',
                                    content: {
                                        elem: 'cell',
                                        content: {
                                            block: 'p-campaign-stat',
                                            elem: 'day-budget-recommendation-notification'
                                        }
                                    }
                                },
                                {
                                    elem: 'row',
                                    content: {
                                        elem: 'cell',
                                        content: [
                                            {
                                                block: 'b-stat-tabs',
                                                mods: { type: 'single-camp' },
                                                mix: {
                                                    block: 'p-campaign-stat',
                                                    elem: 'tabs'
                                                }
                                            },
                                            {
                                                block: 'b-statistics-form',
                                                mods: { type: 'brand_safety' }
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                    this.data.filteredTag && {
                        elem: 'row',
                        center: true,
                        ctxCells: {
                            center: {
                                mix: {
                                    block: 'p-campaign-stat',
                                    elem: 'tag-cell'
                                },
                                attrs: {
                                    colspan: 2
                                },
                                content: {
                                    block: 'b-group-tag-button',
                                    mix: {
                                        block: 'p-campaign-stat',
                                        elem: 'tag-button'
                                    },
                                    mods: {
                                        size: 'big'
                                    },
                                    content: [
                                        this.data.filteredTag,
                                        {
                                            elem: 'count',
                                            content: [
                                                '&nbsp;',
                                                isNaN(+this.data.stat_banners_num) ?
                                                    (this.data.banners || []).length :
                                                    this.data.stat_banners_num
                                            ]
                                        },
                                        {
                                            block: 'link',
                                            url: u.formatUrl({
                                                host: this.data.SCRIPT,
                                                query: this.tagUrlQuery
                                            }),
                                            content: {
                                                block: 'b-icon',
                                                mix: {
                                                    block: 'p-campaign-stat',
                                                    elem: 'tag-cross'
                                                },
                                                mods: {
                                                    'size-13': 'grey-cross'
                                                }
                                            }
                                        }
                                    ]
                                }
                            }
                        }
                    }
                ]
            },
            {
                elem: 'dna-statistic-wrapper',
                content: {
                    block: 'dna-statistic'
                }
            }
        ];
    })
);
