block('app-main').match(function() {
    return this.data.cmd === 'showCampStat' && this.data.statistic_page_type === 'brand_safety_mol';
})(
    block('app-main').mode('page-block')({
        block: 'p-campaign-stat',
        mods: {
            type: 'brand_safety_mol'
        }
    }),

    block('b-page')(
        def()(function() {
            var data = this.data,
                form = data.FORM,
                clientInfo = data.client_info,
                managerInfo = data.manager_info,
                loginRights = data.login_rights,
                isManagerControl = !!loginRights.manager_control,
                isShowForManager = !!form.show_for_manager,
                cmd = data.FORM.cmd,
                login = data.user_login,
                name = data.user_fio,
                token = data.csrf_token,
                userLink = loginRights.role !== 'client' ?
                    loginRights.is_internal_user ?
                        ({
                            block: 'link',
                            content: u.escapeHTML(name) + ' (' + u.escapeHTML(login) + ')',
                            url: u.formatUrl({
                                path: 'registered/main.pl',
                                query: {
                                    cmd: 'modifyUser',
                                    rcmd: cmd,
                                    rulogin: login,
                                    ulogin: login,
                                    csrf_token: token
                                }
                            })
                        }) :
                        u.escapeHTML(name) + ' (' + u.escapeHTML(login) + ')' :
                    '',
                getTexts = function() {
                    var resp = {
                        title: iget2('p-campaign-stat', 'statistika-po-vsem-kampaniyam', 'Статистика по всем кампаниям'),
                        header: u.consts('isMy') ?
                            iget2('p-campaign-stat', 'statistika-po-vsem-kampaniyam', 'Статистика по всем кампаниям') :
                            iget2('p-campaign-stat', 'statistika-po-vsem-kampaniyam-111', 'Статистика по всем кампаниям: {link}', {
                                link: userLink
                            })
                    };

                    if (isManagerControl && clientInfo && isShowForManager) {
                        resp.title = iget2(
                            'p-campaign-stat',
                            'statistika-po-kampaniyam-klienta-120',
                            'Статистика по кампаниям клиента: {cl.Fio} ({cl.login}), менеджер {mng.Fio} ({mng.login})',
                            {
                                cl: clientInfo,
                                mng: managerInfo
                            }
                        );
                        resp.header = iget2(
                            'p-campaign-stat',
                            'statistika-po-kampaniyam-klienta-121',
                            'Статистика по кампаниям клиента: {link}, менеджер {managerFio} ({managerLogin})',
                            {
                                link: userLink,
                                managerFio: u.escapeHTML(managerInfo.Fio),
                                managerLogin: u.escapeHTML(managerInfo.login)
                            }
                        );
                    } else if (form.cid) {
                        resp.title = iget2(
                            'p-campaign-stat',
                            'statistika-po-vybrannym-kampaniyam-122',
                            'Статистика по выбранным кампаниям клиента {name} ({login}): {cid}',
                            {
                                name: data.user_fio,
                                login: data.user_login,
                                cid: form.cid
                            }
                        );
                        resp.header = iget2('p-campaign-stat', 'statistika-po-vybrannym-kampaniyam-117', 'Статистика по выбранным кампаниям {link}: {cid}', {
                            link: userLink,
                            cid: u.escapeHTML(form.cid)
                        });
                    }

                    if (u.consts('rights').enableStatsMultiClientsMode) {
                        resp.header = iget2('p-campaign-stat', 'statistika-po-vsem-clientam', 'Статистика по всем клиентам');
                        resp.title = iget2('p-campaign-stat', 'statistika-po-vsem-clientam', 'Статистика по всем клиентам')
                    }

                    return resp;
                };

            return applyNext({
                pageTexts: getTexts()
            });
        }),
        mode('title')(function() {
            return this.pageTexts.title;
        })
    )
);

block('p-campaign-stat').mod('type', 'brand_safety_mol')(
    elem('info').replace()(function() {

        return {
            block: 'b-page-title',
            mix: [{
                block: 'p-campaign-stat',
                elem: 'user-title-link'
            }],
            elem: 'title',
            content: this.pageTexts.header
        };
    }),
    //для статистики по всем кампаниям не создаем модель кампании, так что данные про модель в js передавать не нужно
    js()(function() {
        return {
            offline: (this.data.offline_stat || this.data.FORM.offline_stat) === 1,
            clientCurrency: this.data.client_currency
        };
    }),

    elem('actions').def()(''),

    elem('stat-data').def()(''),

    elem('stat-footer').def()(''),

    elem('mass-actions').def()(''),

    elem('stat-actions-rows').def()(''),

    elem('show-banners-stat-button').def()(''),

    content()(function() {
        return [
            u.hasClientFeature('direct_birthday_rebranding') && {
                block: 'b-header-title-portal-dna',
                title: iget2(
                    'p-campaign-stat',
                    'campaign-stat-page-header-title',
                    'Статистика'
                )
            },
            {
                block: 'l-page',
                content: [
                    {
                        elem: 'row',
                        right: true,
                        left: {
                            block: 'b-layout-table',
                            mix: [{
                                block: 'p-campaign-stat',
                                elem: 'head-layout'
                            }],
                            content: [
                                {
                                    elem: 'row',
                                    content: {
                                        elem: 'cell',
                                        content: [
                                            {
                                                block: 'p-campaign-stat',
                                                mods: { type: 'brand_safety_mol' },
                                                elem: 'info'
                                            },
                                            {
                                                block: 'b-stat-tabs',
                                                mix: {
                                                    block: 'p-campaign-stat',
                                                    elem: 'tabs'
                                                }
                                            },
                                            {
                                                block: 'b-statistics-form',
                                                mods: { type: 'brand_safety_mol' }
                                            },
                                            !u.consts('rights').enableStatsMultiClientsMode && {
                                                elem: 'cell',
                                                content: {
                                                    block: 'b-campaign-menu',
                                                    options: {
                                                        navMods: {
                                                            border: 'yes',
                                                            type: 'campdate'
                                                        },
                                                        isMol: true
                                                    },
                                                    mix: {
                                                        block: 'p-campaign-stat',
                                                        elem: 'campaign-menu-cell'
                                                    }
                                                }
                                            }
                                        ].filter(Boolean)
                                    }
                                }
                            ]
                        }
                    }
                ]
            },
            {
                elem: 'dna-statistic-wrapper',
                content: {
                    block: 'dna-statistic'
                }
            }
        ];
    })
);
