match(function() {
    return this.data.cmd === 'showCampStat' && this.data.FORM.stat_type === 'campdate';
})(

    block('app-main').mode('page-block')({
        block: 'p-campaign-stat',
        mods: {
            type: 'campdate'
        }
    }),

    block('b-page')(
        def()(function() {
            var data = this.data,
                form = data.FORM,
                clientInfo = data.client_info,
                managerInfo = data.manager_info,
                loginRights = data.login_rights,

                isAnyClient = !!loginRights.is_any_client,
                isAgencyControl = !!loginRights.agency_control,
                isManagerControl = !!loginRights.manager_control,
                isShowForManager = !!form.show_for_manager,
                isFavorites = !!+data.show_favorites,
                cids = [],
                cmd = data.FORM.cmd,
                login = data.user_login,
                token = data.csrf_token,
                userLink = loginRights.role != 'client' ?
                hasLoginRights('agency_control', 'is_internal_user') ?
                {
                    block: 'link',
                    content: u.escapeHTML(data.user_fio) + ' (' + u.escapeHTML(login) + ')',
                    url: u.formatUrl({
                        path: 'registered/main.pl',
                        query: {
                            cmd: 'modifyUser',
                            rcmd: cmd,
                            rulogin: login,
                            ulogin: login,
                            csrf_token: token
                        }
                    })
                } :
                u.escapeHTML(data.user_fio) + ' (' + u.escapeHTML(login) + ')' : '',
                getTexts = function() {
                    var resp = {
                        title: iget2('p-campaign-stat', 'statistika-po-vsem-kampaniyam', 'Статистика по всем кампаниям'),
                        header: u.consts('isMy') ?
                            iget2('p-campaign-stat', 'statistika-po-vsem-kampaniyam', 'Статистика по всем кампаниям') :
                            iget2('p-campaign-stat', 'statistika-po-vsem-kampaniyam-111', 'Статистика по всем кампаниям: {link}', {
                                link: userLink
                            })
                    };

                    if (isAnyClient && isFavorites) {
                        resp.title = resp.header = iget2('p-campaign-stat', 'statistika-po-samym-vazhnym', 'Статистика по самым важным кампаниям');

                    } else if (isAgencyControl && isFavorites) {
                        resp.title = iget2('p-campaign-stat', 'statistika-po-samym-vazhnym-112', 'Статистика по самым важным кампаниям клиента: {foo} ({bar})', {
                            foo: data.user_fio,
                            bar: data.user_login
                        });
                        resp.header = iget2('p-campaign-stat', 'statistika-po-samym-vazhnym-113', 'Статистика по самым важным кампаниям клиента: {link}', {
                            link: userLink
                        });
                    } else if (isManagerControl && clientInfo && isFavorites && isShowForManager) {
                        resp.title = iget2(
                            'p-campaign-stat',
                            'statistika-po-samym-vazhnym-114',
                            'Статистика по самым важным кампаниям клиента: {foo} ({bar}), менеджер {baz} ({quux})',
                            {
                                foo: clientInfo.FIO,
                                bar: clientInfo.login,
                                baz: managerInfo.FIO,
                                quux: managerInfo.login
                            }
                        );

                        resp.header = iget2(
                            'p-campaign-stat',
                            'statistika-po-samym-vazhnym-115',
                            'Статистика по самым важным кампаниям клиента: {link}, менеджер {managerFIO} ({managerLogin})',
                            {
                                link: userLink,
                                managerFIO: u.escapeHTML(managerInfo.FIO),
                                managerLogin: u.escapeHTML(managerInfo.login)
                            }
                        );
                    } else if (isManagerControl && clientInfo && isFavorites) {
                        resp.title = iget2('p-campaign-stat', 'statistika-po-samym-vazhnym-112', 'Статистика по самым важным кампаниям клиента: {foo} ({bar})', {
                            foo: clientInfo.FIO,
                            bar: clientInfo.login
                        });
                        resp.header = iget2('p-campaign-stat', 'statistika-po-samym-vazhnym-113', 'Статистика по самым важным кампаниям клиента: {link}', {
                            link: userLink
                        });
                    } else if (isManagerControl && clientInfo && isShowForManager) {
                        resp.title = iget2(
                            'p-campaign-stat',
                            'statistika-po-kampaniyam-klienta',
                            'Статистика по кампаниям клиента: {foo} ({bar}), менеджер {baz} ({quux})',
                            {
                                foo: clientInfo.FIO,
                                bar: clientInfo.login,
                                baz: managerInfo.FIO,
                                quux: managerInfo.login
                            }
                        );
                        resp.header = iget2(
                            'p-campaign-stat',
                            'statistika-po-kampaniyam-klienta-116',
                            'Статистика по кампаниям клиента: {link}, менеджер {managerFIO} ({managerLogin})',
                            {
                                link: userLink,
                                managerFIO: u.escapeHTML(managerInfo.FIO),
                                managerLogin: u.escapeHTML(managerInfo.login)
                            }
                        );
                    } else if (form.cid) {
                        cids = data.orders.reduce(function(list, order) {
                            (!isFavorites || order.is_favorite_cid) && list.push(order.cid);

                            return list;
                        }, []);

                        resp.title = iget2(
                            'p-campaign-stat',
                            'statistika-po-vybrannym-kampaniyam',
                            'Статистика по выбранным кампаниям клиента {foo} ({bar}): {baz}',
                            {
                                foo: data.user_fio,
                                bar: data.user_login,
                                baz: cids.length ? cids.join(', ') : form.cid
                            }
                        );
                        resp.header = iget2('p-campaign-stat', 'statistika-po-vybrannym-kampaniyam-117', 'Статистика по выбранным кампаниям {link}: {cid}', {
                            link: userLink,
                            cid: u.escapeHTML(cids.length ? cids.join(', ') : form.cid)
                        });
                    }

                    return resp;
                };

            if (data.banners) {
                data.banners.forEach(function(banner) {
                    banner.has_site_enum = 'yes';
                    if (!banner.href && banner.turbolanding) {
                        banner.has_site_enum = 'no';
                    }
                });
            }

            return applyNext({
                pageTexts: getTexts()
            });
        }),

        mode('title')(function() {
            return this.pageTexts.title;
        })
    )
);

block('p-campaign-stat').mod('type', 'campdate')(
    elem('info').replace()(function() {

        return {
            block: 'b-page-title',
            mix: [{
                block: 'p-campaign-stat',
                elem: 'user-title-link'
            }],
            elem: 'title',
            content: this.pageTexts.header
        };
    }),

    elem('stat-data').replace()(function() {

        var data = this.data;

        return u._.extend(
            applyNext(), {
                block: 'b-campaign-stat-data',
                mods: {
                    type: 'campdate'
                },
                campstat: data,
                plotGroup: data.plot_group,
                //DIRECT-54001 пробрасываем currency для графиков статистики
                currency: data.currency
            });
    }),

    //для статистики по всем кампаниям не создаем модель кампании, так что данные про модель в js передавать не нужно
    js()(function() {
        return {
            offline: (this.data.offline_stat || this.data.FORM.offline_stat) === 1
        };
    }),

    content()(function() {
        var showNewDailyBudgetRecommendations =
            this.data.features_enabled_for_client.show_daily_budget_recommendations_in_old_interface == 1;

        return [
            u.hasClientFeature('direct_birthday_rebranding') && {
                block: 'b-header-title-portal-dna',
                title: iget2(
                    'p-campaign-stat',
                    'campaign-stat-page-header-title',
                    'Статистика'
                )
            },
            {
                block: 'l-page',
                content: [
                    {
                        elem: 'row',
                        right: true,
                        left: {
                            block: 'b-layout-table',
                            mix: [{
                                block: 'p-campaign-stat',
                                elem: 'head-layout'
                            }],
                            content: {
                                elem: 'row',
                                content: [{
                                    elem: 'cell',
                                    content: [
                                        {
                                            block: 'p-campaign-stat',
                                            mods: { type: 'campdate' },
                                            elem: 'info'
                                        },
                                        {
                                            block: 'p-campaign-stat',
                                            elem: 'params',
                                            content: [
                                                {
                                                    block: 'b-stat-tabs',
                                                    mix: {
                                                        block: 'p-campaign-stat',
                                                        elem: 'tabs'
                                                    }
                                                },
                                                {
                                                    block: 'b-statistics-form',
                                                    mods: this.mods
                                                }
                                            ]
                                        }
                                    ]
                                }, {
                                    elem: 'cell',
                                    content: {
                                        block: 'b-campaign-menu',
                                        options: {
                                            navMods: {
                                                border: 'yes',
                                                type: 'campdate'
                                            }
                                        },
                                        mix: {
                                            block: 'p-campaign-stat',
                                            elem: 'campaign-menu-cell'
                                        }
                                    }
                                }]
                            }
                        }
                    },
                    showNewDailyBudgetRecommendations && {
                        elem: 'row',
                        center: true,
                        ctxCells: {
                            center: {
                                attrs: {
                                    colspan: '2'
                                },
                                content: {
                                    block: 'p-campaign-stat',
                                    elem: 'wallet-budget-recommendation-notification'
                                }
                            }
                        }
                    },
                    {
                        elem: 'row',
                        center: true,
                        ctxCells: {
                            center: {
                                content: {
                                    block: 'p-campaign-stat',
                                    elem: 'stat-data',
                                    mods: { type: (this.mods || {}).type }
                                },
                                attrs: {
                                    colspan: 2
                                }
                            }
                        }
                    },
                    {
                        elem: 'row',
                        center: true,
                        ctxCells: {
                            center: {
                                content: {
                                    block: 'p-campaign-stat',
                                    elem: 'download-xsl',
                                    content: {
                                        block: 'link',
                                        mods: {
                                            inner: 'yes'
                                        },
                                        target: '_top',
                                        content: [
                                            {
                                                block: 'b-icon',
                                                mods: {
                                                    type: 'xls'
                                                },
                                                mix: [{ block: 'link', elem: 'icon' }],
                                                alt: ''
                                            },
                                            {
                                                elem: 'inner',
                                                content: iget2('p-campaign-stat', 'skachat-v-vide-xls', 'скачать в виде XLS-файла')
                                            }
                                        ],
                                        url: u.formatUrl({
                                            path: '/registered/' + [
                                                this.data.d1,
                                                this.data.m1 + '-' + this.data.d2,
                                                this.data.m2 + '_main',
                                                'xls'
                                            ].join('.'),
                                            query: u.getUrlParams(['xsl'], {
                                                xls: 1
                                            })
                                        })
                                    }
                                },
                                attrs: {
                                    colspan: 2
                                }
                            }
                        }
                    }
                ]
            }
        ];
    })
);
