match(function() {
    return this.data.cmd === 'showStat' && !+this.data.FORM.single_camp;
})(

    block('app-main').mode('page-block')({
        block: 'p-campaign-stat',
        mods: {
            type: 'mol'
        }
    }),

    block('b-page')(
        def()(function() {
            var data = this.data,
                form = data.FORM,
                clientInfo = data.client_info,
                managerInfo = data.manager_info,
                loginRights = data.login_rights,
                isManagerControl = !!loginRights.manager_control,
                isShowForManager = !!form.show_for_manager,
                cmd = data.FORM.cmd,
                login = data.user_login,
                name = data.user_fio,
                token = data.csrf_token,
                userLink = loginRights.role !== 'client' ?
                    loginRights.is_internal_user ?
                        ({
                            block: 'link',
                            content: u.escapeHTML(name) + ' (' + u.escapeHTML(login) + ')',
                            url: u.formatUrl({
                                path: 'registered/main.pl',
                                query: {
                                    cmd: 'modifyUser',
                                    rcmd: cmd,
                                    rulogin: login,
                                    ulogin: login,
                                    csrf_token: token
                                }
                            })
                        }) :
                        u.escapeHTML(name) + ' (' + u.escapeHTML(login) + ')' :
                    '',
                getTexts = function() {
                    var resp = {
                        title: iget2('p-campaign-stat', 'statistika-po-vsem-kampaniyam', 'Статистика по всем кампаниям'),
                        header: u.consts('isMy') ?
                            iget2('p-campaign-stat', 'statistika-po-vsem-kampaniyam', 'Статистика по всем кампаниям') :
                            iget2('p-campaign-stat', 'statistika-po-vsem-kampaniyam-111', 'Статистика по всем кампаниям: {link}', {
                                link: userLink
                            })
                    };

                    if (isManagerControl && clientInfo && isShowForManager) {
                        resp.title = iget2(
                            'p-campaign-stat',
                            'statistika-po-kampaniyam-klienta-120',
                            'Статистика по кампаниям клиента: {cl.Fio} ({cl.login}), менеджер {mng.Fio} ({mng.login})',
                            {
                                cl: clientInfo,
                                mng: managerInfo
                            }
                        );
                        resp.header = iget2(
                            'p-campaign-stat',
                            'statistika-po-kampaniyam-klienta-121',
                            'Статистика по кампаниям клиента: {link}, менеджер {managerFio} ({managerLogin})',
                            {
                                link: userLink,
                                managerFio: u.escapeHTML(managerInfo.Fio),
                                managerLogin: u.escapeHTML(managerInfo.login)
                            }
                        );
                    } else if (form.cid) {
                        resp.title = iget2(
                            'p-campaign-stat',
                            'statistika-po-vybrannym-kampaniyam-122',
                            'Статистика по выбранным кампаниям клиента {name} ({login}): {cid}',
                            {
                                name: data.user_fio,
                                login: data.user_login,
                                cid: form.cid
                            }
                        );
                        resp.header = iget2('p-campaign-stat', 'statistika-po-vybrannym-kampaniyam-117', 'Статистика по выбранным кампаниям {link}: {cid}', {
                            link: userLink,
                            cid: u.escapeHTML(form.cid)
                        });
                    }

                    if (u.consts('rights').enableStatsMultiClientsMode) {
                        resp.header = iget2('p-campaign-stat', 'statistika-po-vsem-clientam', 'Статистика по всем клиентам');
                        resp.title = iget2('p-campaign-stat', 'statistika-po-vsem-clientam', 'Статистика по всем клиентам')
                    }

                    return resp;
                },
                needMassActions,
                incompleteData = {},
                tableColumns = u._.union(
                    data.group_by,
                    data.columns,
                    Object.keys(data.filters)
                );

            !data.statType && (data.statType = 'mol');

            // DIRECT-65239 - статусы выпиливаем не окончательно, пока что-просто скрываем
            // вместо срезов ext_phrase_status и search_query_status ориентируемся по типу статистики statType
            //
            // slicesFields = this.data.group_by || [],
            needMassActions = data.statType === 'search_queries' &&
                (this.data.data_array || []).length && this.data.FORM.show_stat;
                    // (slicesFields.indexOf('ext_phrase_status') !== -1 ||
                        // slicesFields.indexOf('search_query_status') !== -1);

            if (data.banners) {
                data.banners.forEach(function(banner) {
                    banner.has_site_enum = 'yes';
                    if (!banner.href && banner.turbolanding) {
                        banner.has_site_enum = 'no';
                    }
                });
            }

            // https://st.yandex-team.ru/DIRECT-127046 - прокидываю дополнительно content_promotion_type для data_array,
            // чтобы в рендере ячейки кампании сравнивать с content_promotion_type.
            var allCampaigns = u._.indexBy(this.data.campaigns_list, 'cid');

            (data.data_array || []).forEach(function(campaign) {
                if ((allCampaigns[campaign.cid] || {})['type'] === 'content_promotion') {
                    campaign['content_promotion_type'] = (allCampaigns[campaign.cid] || {})['content_promotion_type'];
                }
            });

            // https://st.yandex-team.ru/DIRECT-152781
            if (u.consts('relevanceMatchCategoriesStatWarnsEnabled') &&
                tableColumns.indexOf('targeting_category') !== -1 &&
                u.moment(this.data.date_from).diff('2021-09-03', 'day') >= 0) {

                incompleteData = { targeting_category: '2021-09-03' };
            }

            return applyNext({
                pageTexts: getTexts(),
                needMassActions: needMassActions,
                incompleteData: u._.extend(incompleteData, data.incomplete_data)
            });
        }),

        mode('title')(function() {
            return this.pageTexts.title;
        })
    )

);

block('p-campaign-stat').mod('type', 'mol')(

    elem('info').replace()(function() {

        return {
            block: 'b-page-title',
            mix: [{
                block: 'p-campaign-stat',
                elem: 'user-title-link'
            }],
            elem: 'title',
            content: this.pageTexts.header
        };
    }),

    // Убираем ссылки "скачать" и "распечатать"
    elem('actions').def()(function() {
        return '';
    }),

    //для статистики по всем кампаниям не создаем модель кампании, так что данные про модель в js передавать не нужно
    js()(function() {
        var allCampaigns = u._.indexBy(this.data.campaigns_list, 'cid');

        return {
            offline: (this.data.offline_stat || this.data.FORM.offline_stat) === 1,
            clientCurrency: this.data.client_currency,
            needMassActions: this.needMassActions,
            campaigns: (this.data.data_array || []).reduce(function(campaigns, row) {
                if (!campaigns[row.cid]) {
                    campaigns[row.cid] = u._.pick(allCampaigns[row.cid], ['strategy', 'type', 'name']);
                }

                return campaigns;
            }, {}),
            minusWordsLength: {
                campaigns: this.data.campaigns_minus_words_length,
                groups: this.data.adgroups_minus_words_length
            }
        };
    }),

    content()(function() {
        var data = this.data,
            columns = data.columns,
            group_by = data.group_by,
            showNewDailyBudgetRecommendations =
                data.features_enabled_for_client.show_daily_budget_recommendations_in_old_interface == 1;

        return [
            u.hasClientFeature('direct_birthday_rebranding') && {
                block: 'b-header-title-portal-dna',
                title: iget2(
                    'p-campaign-stat',
                    'campaign-stat-page-header-title',
                    'Статистика'
                )
            },
            {
                block: 'l-page',
                content: [
                    {
                        elem: 'row',
                        right: true,
                        left: {
                            block: 'b-layout-table',
                            mix: [{
                                block: 'p-campaign-stat',
                                elem: 'head-layout'
                            }],
                            content: {
                                elem: 'row',
                                content: [
                                    {
                                        elem: 'cell',
                                        content: [
                                            !u.hasClientFeature('direct_birthday_rebranding') && {
                                                block: 'p-campaign-stat',
                                                mods: { type: 'mol' },
                                                elem: 'info'
                                            },
                                            {
                                                block: 'p-campaign-stat',
                                                elem: 'params',
                                                content: [
                                                    !u.hasClientFeature('direct_unavailable_goals_allowed') && {
                                                        block: 'b-statistics-metrika-counter-access'
                                                    },
                                                    {
                                                        block: 'b-stat-tabs',
                                                        mix: {
                                                            block: 'p-campaign-stat',
                                                            elem: 'tabs'
                                                        }
                                                    },
                                                    {
                                                        block: 'b-statistics-form',
                                                        mods: this.mods,
                                                        isFirstValueByDefault: true
                                                    }
                                                ]
                                            }
                                        ]
                                    },

                                    !u.consts('rights').enableStatsMultiClientsMode && {
                                        elem: 'cell',
                                        content: {
                                            block: 'b-campaign-menu',
                                            options: {
                                                navMods: {
                                                    border: 'yes',
                                                    type: 'campdate'
                                                },
                                                isMol: true
                                            },
                                            mix: {
                                                block: 'p-campaign-stat',
                                                elem: 'campaign-menu-cell'
                                            }
                                        }
                                    }
                                ].filter(Boolean)
                            }
                        }
                    },
                    showNewDailyBudgetRecommendations && {
                        elem: 'row',
                        left: true,
                        right: true,
                        ctxCells: {
                            left: {
                                attrs: {
                                    colspan: '2'
                                },
                                content: {
                                    block: 'p-campaign-stat',
                                    elem: 'wallet-budget-recommendation-notification',
                                    elemMods: { type: 'mol' }
                                }
                            },
                            right: true
                        }
                    },
                    this.data.FORM.show_stat ?
                        (this.data.data_array || []).length ?
                            [
                                !this.data.compare_periods && this.data.statType === 'mol' && {
                                    elem: 'row',
                                    center: true,
                                    ctxCells: {
                                        center: {
                                            attrs: { colspan: 2 },
                                            content: {
                                                block: 'p-campaign-stat',
                                                elem: 'charts-manager'
                                            }
                                        }
                                    }
                                },
                                {
                                    elem: 'row',
                                    center: true,
                                    ctxCells: {
                                        center: {
                                            attrs: { colspan: 2 },
                                            content: this.data.FORM.show_stat ? {
                                                block: 'b-mol-stat-data',
                                                needModel: this.needMassActions,
                                                content: Object.keys(this.incompleteData || {}).length ? {
                                                    block: 'b-stat-data-available-from',
                                                    dateTo: this.data.date_to,
                                                    dateFrom: this.data.date_from,
                                                    availableFrom: this.incompleteData,
                                                    tableColumns: u._.union(
                                                        group_by,
                                                        columns,
                                                        Object.keys(this.data.filters))
                                                } : ''
                                            } : ''
                                        }
                                    }
                                }
                            ] :
                            [
                                !this.data.xls_rows_limit_exceeded && !this.data.too_much_statistics_error && {
                                    elem: 'row',
                                    right: true,
                                    left: {
                                        block: 'p-campaign-stat',
                                        elem: 'no-data',
                                        content: (function() {
                                            var minDate = u['b-statistics-form']
                                                    .getDateLimits(this.data.statType || 'mo')
                                                    .minDate,
                                                dateTo = u.moment(this.data.date_to);

                                            if (this.data.FORM.stat_type === 'search_queries') {
                                                // дата начала сбора статистики по поисковым запросам
                                                var startDate = u.moment(
                                                    u.consts('BS_SEARCH_QUERIES_SINCE_DATE'),
                                                    'YYYYMMDD'
                                                );

                                                if (dateTo.isBefore(startDate) &&
                                                    (dateTo.isAfter(minDate) || dateTo.isSame(minDate))) {

                                                    return iget2('p-campaign-stat', 'net-dannyh-za-vybrannyy', 'Нет данных за выбранный период. Отчеты доступны с {foo}', {
                                                        foo: startDate.format('DD MMMM YYYY')
                                                    });
                                                } else if (dateTo.isBefore(minDate)) {
                                                    return iget2('p-campaign-stat', 'net-dannyh-za-vybrannyy', 'Нет данных за выбранный период. Отчеты доступны с {foo}', {
                                                        foo: minDate.format('DD MMMM YYYY')
                                                    });
                                                } else {
                                                    return iget2('p-campaign-stat', 'dannye-za-ukazannyy-diapazon', 'Данные за указанный диапазон дат не найдены');
                                                }
                                            } else {
                                                return dateTo.isBefore(minDate) ?
                                                    iget2('p-campaign-stat', 'net-dannyh-za-vybrannyy-123', 'Нет данных за выбранный период. Отчеты доступны {foo}', {
                                                        foo: minDate.format('DD MMMM YYYY')
                                                    }) :
                                                    iget2('p-campaign-stat', 'dannye-za-ukazannyy-diapazon', 'Данные за указанный диапазон дат не найдены');
                                            }
                                        }).call(this)
                                    }
                                },
                                {
                                    elem: 'row',
                                    right: true,
                                    left: {
                                        attrs: { colspan: 2 },
                                        content: Object.keys(this.incompleteData || {}).length ? {
                                            block: 'b-stat-data-available-from',
                                            dateTo: this.data.date_to,
                                            dateFrom: this.data.date_from,
                                            availableFrom: this.incompleteData,
                                            tableColumns: u._.union(
                                                group_by,
                                                columns,
                                                Object.keys(this.data.filters))
                                        } : ''
                                    }
                                }
                            ] :
                        '',
                    !!(this.data.data_array || []).length && [
                        this.needMassActions ?
                            applyCtx({
                                elem: 'mol-stat-actions-row'
                            }) :
                            {
                                elem: 'row',
                                center: true,
                                ctxCells: {
                                    center: {
                                        content: applyCtx({
                                            block: 'p-campaign-stat',
                                            elem: 'pager',
                                            elemMods: {
                                                type: 'mo'
                                            }
                                        }),
                                        attrs: {
                                            colspan: 2
                                        }
                                    }
                                }
                            }
                    ],
                    applyCtx({
                        elem: 'stat-actions-row'
                    })
                ]
            }
        ];
    })
);
