block('app-main').match(function() {
    return this.data.cmd === 'showCampStat';
}).match(function() {
    return this.data.statistic_page_type === 'phrase-detail';
}).mode('preprocess')(function() {
    var data = applyNext(),
        defaultSortDirection = 0,
        defaultSortField = 'date',
        form = data.FORM;

    form.sort || (form.sort = defaultSortField);

    if (typeof form.reverse === 'undefined') {
        form.reverse || (form.reverse = defaultSortDirection);
    }

    if (data.banners) {
        data.banners.forEach(function(banner) {
            banner.has_site_enum = 'yes';
            if (!banner.href && banner.turbolanding) {
                banner.has_site_enum = 'no';
            }
        });
    }

    return data;
});

block('p-campaign-stat').mod('type', 'phrase-detail')(

    elem('stat-data').replace()(function() {
        var data = this.data,
            banners = data.banners || [];

        return this.extend(
            applyNext(), {
                mods: {
                    type: 'phrase-detail'
                },
                skipSlice: true,
                bannersOnPage: data.banners_on_page,
                banners: banners,
                campstat: banners,
                plotGroup: data.plot_group,
                b: data.b
            });
    }),

    // @todo: DIRECT-33651 оторвать при тестировании статистики по площадкам
    elem('stat-footer').def()(function() {
        var actionsRow = applyCtx({
                elem: 'stat-actions-row'
            }),
            data = this.data;

        return [
            {
                elem: 'row',
                center: true,
                ctxCells: {
                    center: {
                        content: applyCtx({
                            elem: 'pager',
                            params: {
                                totalCount: data.stat_banners_num,
                                allpages: data.FORM.allpages,
                                perpageCount: data.banners_on_page
                            }
                        }),
                        attrs: {
                            colspan: 2
                        }
                    }
                }
            },
            actionsRow
        ];
    })
);

// @todo: DIRECT-33651 открыть при тестировании статистики по площадкам
/*
elem stat-footer, default: {
    var data = this.data,
        form = data.FORM;

    this.data.pagination || (this.data.pagination = {
        currentPage: form.allpages ? -1 : (form.page || 1),
        totalCount: data.stat_banners_num,
        allpages: form.allpages,
        perpageCount: data.banners_on_page,
        addNavigation: true
    });

    return applyCtx({ elem: 'stat-actions-rows' });
}
*/
