block('app-main').match(function() {
    return this.data.cmd === 'showCampStat';
}).match(function() {
    return this.data.statistic_page_type === 'pages';
}).mode('preprocess')(function() {
    var data = applyNext(),
        defaultSortDirection = 1,
        defaultSortField = 'clicks',
        form = data.FORM,
        countPerPage = data.onpage || 100,
        page = form.page || 1;

    data.data || (data.data = []);

    data.pagination = {
        hideButtonAll: true,
        currentPage: page,
        totalCount: data.row_num,
        perpageCount: countPerPage
    };

    form.sort || (form.sort = defaultSortField);

    if (typeof form.reverse === 'undefined') {
        form.reverse || (form.reverse = defaultSortDirection);
    }

    data.canChangePlatformsState = data.data.some(function(rowData) {
        // проверка на то, является ли площадка обычной
        // для спец площадок значение page_sorting меньше 9
        // для обычных площадок доступны групповые действия
        // а конкретно в тут идет проверка на доступность
        // смены состояния площадки
        return rowData.page_sorting === 9 && !!(rowData.can_be_disabled || rowData.is_disabled);
    });

    // без массовых действий можно показать более полную пагинацию
    data.pagination.addNavigation = !data.canChangePlatformsState;

    data.blockedMassActions = /^(superreader|media)$/.test(data.login_rights.role);

    if (data.banners) {
        data.banners.forEach(function(banner) {
            banner.has_site_enum = 'yes';
            if (!banner.href && banner.turbolanding) {
                banner.has_site_enum = 'no';
            }
        });
    }

    return data;
});

block('p-campaign-stat').mod('type', 'platform')(

    js()(function() {
        return this.extend(applyNext(), {
            blockedMassActions: this.data.blockedMassActions
        });
    }),

    elem('stat-data').replace()(function() {
        var data = this.data,
            form = data.FORM;

        return {
            block: 'p-campaign-stat',
            elem: 'campaign-stat-data',
            mix: [{
                block: 'b-checkboxes-group',
                js: true
            }],
            content: [
                {
                    block: 'checkbox',
                    mods: {
                        disabled: 'yes'
                    },
                    mix: [
                        {
                            block: 'b-checkboxes-group',
                            elem: 'item'
                        },
                        {
                            block: 'p-campaign-stat',
                            elem: 'checkbox',
                            elemMods: { hidden: 'yes' }
                        }
                    ]
                },
                this.extend(
                    applyNext(), {
                        mods: {
                            type: 'platform'
                        },
                        dataArray: data.data,
                        detailed: hasLoginRights('super_control', 'support_control', 'limited_support_control', 'superreader_control') &&
                            form.use_page_id,
                        blockedMassActions: data.blockedMassActions,
                        // так как блоки подготовки данных одинаковые для остальных вкладок, то
                        // по площадкам эти параметры не учитываются, убираются тут
                        form: u._.omit(form, ['target_all', 'target_0', 'target_1']),
                        hrefParams: {
                            online_stat: 1,
                            stat_type: 'page_dates',
                            cid: data.cid,
                            d1: data.d1,
                            m1: data.m1,
                            y1: data.y1,
                            d2: data.d2,
                            m2: data.m2,
                            y2: data.y2,
                            target_type: form.target_type,
                            goals: data.goals || '',
                            ulogin: data.user_login,
                            attribution_model: form.attribution_model
                        }
                    })
            ]
        };
    }),

    elem('stat-footer').replace()(function() {
        return {
            elem: 'stat-actions-rows'
        };
    }),

    elem('mass-actions').match(function() {
        return this.data.canChangePlatformsState;
    }).def()(function() {
        var data = this.data,
            hasVideoBlackList = u.consts('rights').allowedCpmVideoBanners &&
                u.campaign.isCpm(data.campaign.mediaType) && data.campaign.mediaType !== 'cpm_yndx_frontpage',
            massActions = {
                keys: ['disable', 'enable'],
                values: {
                    disable: iget2('p-campaign-stat', 'zapretit-pokazy', 'запретить показы'),
                    enable: iget2('p-campaign-stat', 'razreshit-pokazy', 'разрешить показы')
                }
            };

        // TODO: DIRECT-99054 переименовать hasVideoBlackList
        // здесь будет еще и черный список Аудио
        if (hasVideoBlackList) {
            massActions = {
                // TODO: DIRECT-99054 добавить новые действия для Аудио
                // keys: ['disable', 'enable', 'video-disable', 'video-enable', 'audio-disabled', 'audio-enabled'],
                keys: ['disable', 'enable', 'video-disable', 'video-enable'],
                values: {
                    disable: iget2('p-campaign-stat', 'disable-media-banners', 'Запретить показы медийных баннеров'),
                    enable: iget2('p-campaign-stat', 'enable-media-banners', 'Разрешить показы медийных баннеров'),
                    'video-disable': iget2('p-campaign-stat', 'disable-video-banners', 'Запретить показы видео баннеров'),
                    'video-enable': iget2('p-campaign-stat', 'enable-video-banners', 'Разрешить показы видео баннеров')
                    // TODO: DIRECT-99054 расскоментить действия для Аудио
                    // 'audio-disable': iget2('p-campaign-stat', 'disable-audio-banners', 'Запретить показы аудио баннеров'),
                    // 'audio-enable': iget2('p-campaign-stat', 'enable-audio-banners', 'Разрешить показы аудио баннеров')
                }
            };
        }

        return {
            block: 'b-mass-actions',
            mods: {
                type: 'stat-platform',
                disabled: 'yes'
            },
            mix: [{
                block: 'p-campaign-stat',
                elem: 'mass-actions'
            }],
            url: data.SCRIPT,
            cid: data.cid,
            ulogin: data.user_login,
            disableLimit: data.max_limit_dont_show,
            disabledItems: Object.keys(data.campaign.DontShowDomains || {}),
            videoDisabledItems: u.consts('rights').allowedCpmVideoBanners ?
                data.campaign.disabled_video_placements :
                undefined,
            // TODO: DIRECT-99054 расскоментировать
            // audioDisabledItems: data.campaign.disabled_audio_placements,
            massActions: massActions,
            // TODO: DIRECT-99054 переименовать hasVideoBlackList
            hasVideoBlackList: hasVideoBlackList,
            defOption: iget2('p-campaign-stat', 'vyberite-ploshchadku', 'Выберите площадку')
        };
    })
);
