BEM.DOM.decl({ block: 'p-campaign-stat', modName: 'type', modVal: 'platform' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._initEvents();
        }
    },

    /**
     * Возвращает блок группы чекбоксов
     * @returns {BEM}
     * @private
     */
    _getCheckboxGroup: function() {
        return this._checkboxGroup ||
            (this._checkboxGroup = this.findBlockOn('campaign-stat-data', 'b-checkboxes-group'));
    },

    /**
     * Возвращает блок таблицы статистики
     * @returns {BEM}
     * @private
     */
    _getStatTable: function() {
        return this._statTable || (this._statTable = this.findBlockInside('campaign-stat-data', 'b-stat-table'));
    },

    /**
     * Инициализирует события связывания группы чекбоксов и блока групповых дейтсвий
     * @private
     */
    _initEvents: function() {
        var massActions = this._getMassActions(),
            checkboxGroup = this._getCheckboxGroup(),
            table;

        if (massActions && checkboxGroup) {
            table = this._getStatTable();

            checkboxGroup.on('change', function(e, data) {
                if (this.params.blockedMassActions) {
                    data = { indexes: [], checkboxes: [] };
                }

                massActions.updateActions(
                    // ['0', '95', '100', ...]
                    data.indexes,
                    // { 0: 'yandex.ru', 95: 'yandex.ua', '100': 'yandex.com', ... }
                    data.indexes.reduce(function(keysData, key, index) {
                        keysData[key] = data.checkboxes[index].val();

                        return keysData;
                    }, {}));
            }, this);

            massActions
                // перед выполнением блокируются все чекбоксы
                .on('before-execute', function() {
                    var checkboxes = checkboxGroup.getCheckboxes();

                    checkboxes.forEach(function(checkbox) {
                        checkbox.setMod('disabled', 'yes');
                    });

                    table.toggleDisabledBlackListLink(true);
                }, this)
                // после выполнения снимается блокировка с чекбоксов и переключается
                // состояние блокировки у элементов строк блока таблицы статистики
                .on('complete-execute error-execute', function(e, data) {
                    var checkboxes = checkboxGroup.getCheckboxes();

                    checkboxes.forEach(function(checkbox, index) {
                        var row = table.closestElem(checkbox.domElem, 'row');

                        if (e.type === 'complete-execute' && row.length) {
                            if (checkbox.isChecked() || index === data.index ||
                                data.checkedPages[table.getRowPageDomain(row)]) {
                                table.toggleDisabled(row, data);
                            }
                        }

                        checkbox.delMod('disabled');
                    });

                    checkboxGroup.unCheckAll();
                    table.toggleDisabledBlackListLink(false);
                }, this);

            table
                .on('blackListEnable', function(e, data) {
                    massActions.updateBlackList(e, data);
                }, this);
        }
    }
});
