block('app-main').match(function() {
    return this.data.cmd === 'showCampStat' || this.data.cmd === 'showStat';
})(

    mode('preprocess')(function() {
        var data = this.data,
            form = data.FORM,
            campaign = data.campaign || {},
            strategy = campaign.strategy = campaign.strategy || {
                is_search_stop: '',
                search: {
                    name: 'default'
                },
                is_net_stop: '',
                name: '',
                net: {
                    name: 'default'
                },
                is_autobudget: ''
            };

        strategy.search = strategy.search || {};
        strategy.net = strategy.net || {};

        data.statType = {
            'phrase-detail': 'phrase-detail',
            pages: 'platform',
            default: 'common',
            detail: 'detail',
            brand_safety: 'brand_safety',
            brand_safety_mol: 'brand_safety_mol'
        }[data.statistic_page_type] || data.FORM.stat_type;

        data.isCpmStat = u.campaign.isCpm((data.campaign || data).mediaType);

        //если таблица со статистикой по единичной кампании,
        if (data.campaign) {
            data.campaign.tags = data.campaign.tags.map(function(tag) {
                data.FORM.tag && tag.tag_id == data.FORM.tag && (data.filteredTag = tag.value);

                return {
                    value: tag.value,
                    id: tag.tag_id
                };
            });

            data.campaignTags = data.campaign.tags;
        }

        if (form.sort === 'null') {
            form.sort = '';
        }

        if (data.banners) {
            data.banners.forEach(function(banner) {
                banner.has_site_enum = 'yes';
                if (!banner.href && banner.turbolanding) {
                    banner.has_site_enum = 'no';
                }
            });
        }

        // бэк не может гарантировать тип, поэтому не строгое равенство
        campaign.isCpaPayForConversionEnabled = strategy.search.pay_for_conversion == 1 ||
            strategy.net.pay_for_conversion == 1;

        return data;
    }),

    // Мода `page-block` отрабатывает до `preprocess`, поэтому дублируем логику про получение `statType`
    mode('page-block')(function() {
        var data = this.data,
            statType = {
                'phrase-detail': 'phrase-detail',
                pages: 'platform',
                default: 'common',
                detail: 'detail',
                brand_lift: 'brand-lift',
                brand_safety: 'brand_safety',
                brand_safety_mol: 'brand_safety_mol'
            }[data.statistic_page_type] || data.FORM.stat_type;

        return {
            block: 'p-campaign-stat',
            mods: {
                type: statType
            }
        };
    })
);

block('b-page').match(function() {
    return this.data.cmd === 'showCampStat';
})(

    mode('title')(function() {
        return iget2('p-campaign-stat', 'statistika', 'Статистика');
    }),

    def()(function() {
        var data = this.data,
            tagUrlQuery = u.getUrlParams();

        delete tagUrlQuery.tag;
        delete tagUrlQuery.page;

        data.banners && data.banners.forEach(function(banner) {
            banner.sitelinks && banner.sitelinks.length && banner.sitelinks.forEach(function(sitelink) {
                sitelink.href &&
                    (sitelink.href = u.formatHref(
                        sitelink.href,
                        data.campaign && data.campaign.statusOpenStat == 'Yes'));
            });

            banner.tagUrlQuery = tagUrlQuery;
        });

        if (data.campaign) {
            data.campaign.mediaType = data.campaign.mediaType || data.mediaType;
        }

        return applyNext({
            tagUrlQuery: tagUrlQuery
        });
    })
);

block('p-campaign-stat')(

    js()(function() {
        return {
            campaign: u._.extend(this.data.campaign, {
                editable: !!this.data.allow_edit_camp
            }),
            offline: (this.data.offline_stat || this.data.FORM.offline_stat) === 1,
            modelParams: {
                name: u.campaign.getCampaignModelName(this.data.campaign.mediaType),
                id: this.data.campaign.cid
            }
        };
    }),

    content()(function() {
        var data = this.data,
            form = data.FORM,
            isDaysReportPage = (data.statistic_page_type || form.stat_type) === 'detail',
            organizations = data.organizations,
            showStat = u.getShowStat(),
            mocUrl = u.getUrl('showStat', u._.extend({
                stat_type: 'moc',
                single_camp: 1,
                with_auto_added_phrases: 1
            }, showStat)),
            showNewDailyBudgetRecommendations =
                data.features_enabled_for_client.show_daily_budget_recommendations_in_old_interface == 1;

        return [
            u.hasClientFeature('direct_birthday_rebranding') && {
                block: 'b-header-title-portal-dna',
                title: iget2(
                    'p-campaign-stat',
                    'campaign-stat-page-header-title',
                    'Статистика'
                )
            },
            isDaysReportPage && {
                block: 'b-camp-stat-day-report-warning',
                mocUrl: mocUrl
            },
            {
                block: 'p-campaign-stat',
                elem: 'models-data'
            },
            {
                block: 'l-page',
                content: [
                    {
                        elem: 'row',
                        right: true,
                        left: {
                            block: 'b-layout-table',
                            mix: [{
                                block: 'p-campaign-stat',
                                elem: 'head-layout'
                            }],
                            content: [
                                {
                                    elem: 'row',
                                    content: [{
                                        elem: 'cell',
                                        content: {
                                            block: 'p-campaign-stat',
                                            elem: 'info'
                                        }
                                    }, {
                                        elem: 'cell',
                                        content: {
                                            block: 'b-campaign-menu',
                                            options: {
                                                navMods: {
                                                    border: 'yes',
                                                    type: 'stat'
                                                },
                                                campOptionsViewOnly: (this.data.allow_edit_camp ||
                                                    this.data.campaign.allow_edit_camp) && !hasLoginRights('media_control')
                                            },
                                            mix: {
                                                block: 'p-campaign-stat',
                                                elem: 'campaign-menu-cell'
                                            }
                                        }
                                    }]
                                },
                                showNewDailyBudgetRecommendations && {
                                    elem: 'row',
                                    content: {
                                        elem: 'cell',
                                        content: {
                                            block: 'p-campaign-stat',
                                            elem: 'day-budget-recommendation-notification'
                                        }
                                    }
                                },
                                {
                                    elem: 'row',
                                    content: {
                                        elem: 'cell',
                                        content: [
                                            {
                                                block: 'b-stat-tabs',
                                                mods: { type: 'single-camp' },
                                                mix: {
                                                    block: 'p-campaign-stat',
                                                    elem: 'tabs'
                                                }
                                            },
                                            {
                                                block: 'b-statistics-form',
                                                mods: this.mods
                                            }
                                        ]
                                    }
                                }
                            ]
                        }
                    },
                    this.data.filteredTag && {
                        elem: 'row',
                        center: true,
                        ctxCells: {
                            center: {
                                mix: {
                                    block: 'p-campaign-stat',
                                    elem: 'tag-cell'
                                },
                                attrs: {
                                    colspan: 2
                                },
                                content: {
                                    block: 'b-group-tag-button',
                                    mix: {
                                        block: 'p-campaign-stat',
                                        elem: 'tag-button'
                                    },
                                    mods: {
                                        size: 'big'
                                    },
                                    content: [
                                        this.data.filteredTag,
                                        {
                                            elem: 'count',
                                            content: [
                                                '&nbsp;',
                                                isNaN(+this.data.stat_banners_num) ?
                                                    (this.data.banners || []).length :
                                                    this.data.stat_banners_num
                                            ]
                                        },
                                        {
                                            block: 'link',
                                            url: u.formatUrl({
                                                host: this.data.SCRIPT,
                                                query: this.tagUrlQuery
                                            }),
                                            content: {
                                                block: 'b-icon',
                                                mix: {
                                                    block: 'p-campaign-stat',
                                                    elem: 'tag-cross'
                                                },
                                                mods: {
                                                    'size-13': 'grey-cross'
                                                }
                                            }
                                        }
                                    ]
                                }
                            }
                        }
                    },
                    {
                        elem: 'row',
                        center: true,
                        ctxCells: {
                            center: {
                                content: {
                                    block: 'p-campaign-stat',
                                    elem: 'stat-data',
                                    mods: { type: (this.mods || {}).type }
                                },
                                attrs: {
                                    colspan: 2
                                }
                            }
                        }
                    }
                ].concat(applyCtx({
                    elem: 'stat-footer'
                }))
            }
        ];
    }),

    elem('stat-data').def()(function() {
        var data = this.data;

        return {
            block: 'b-campaign-stat-data',
            date: {
                from: data.date_from,
                to: data.date_to
            },
            withNds: data.FORM.with_nds || data.with_nds || 0,
            campaign: data.campaign,
            tasesnum: data.tasesnum,
            sesnumForWeek: data.sesnum_for_week,
            directya: data.directya,
            fraudClicks: data.fraud_clicks,
            fraudGiftClicks: data.fraud_gift_clicks,
            fraudShows: data.fraud_shows,
            fraudGiftShows: data.fraud_gift_shows,
            form: data.FORM,
            cid: data.cid,
            noDataFound: data.no_data_found,
            isInternalUser: !!data.login_rights.is_internal_user,
            group: data.group,
            spec: data.spec,
            all: data.all,
            avGrouping: data.av_grouping,
            uidUrl: data.uid_url,
            period: iget2('p-campaign-stat', 's', 'с') + ' ' + data.d1 + '.' + data.m1 + '.' + data.y1 + ' ' +
                iget2('p-campaign-stat', 'po', 'по') + ' ' + data.d2 + '.' + data.m2 + '.' + data.y2
        };
    }),

    // @todo: DIRECT-33651 оторвать при тестировании статистики по площадкам
    elem('stat-footer').def()(function() {
        var actionsRow = applyCtx({
                elem: 'stat-actions-row'
            }),
            data = this.data;

        if (data.FORM.show_banners_stat) {
            return [
                {
                    elem: 'row',
                    center: true,
                    ctxCells: {
                        center: {
                            content: applyCtx({
                                block: 'p-campaign-stat',
                                elem: 'pager',
                                params: {
                                    totalCount: isNaN(+data.stat_banners_num) ?
                                        (data.banners || []).length :
                                        data.stat_banners_num,
                                    allpages: data.FORM.allpages,
                                    perpageCount: data.banners_on_page
                                }
                            }),
                            attrs: {
                                colspan: 2
                            }
                        }
                    }
                },
                actionsRow
            ];
        } else {
            return [
                actionsRow,
                {
                    elem: 'row',
                    center: true,
                    ctxCells: {
                        center: {
                            content: applyCtx({
                                block: 'p-campaign-stat',
                                elem: 'show-banners-stat-button'
                            }),
                            attrs: {
                                colspan: 2
                            }
                        }
                    }
                }
            ];
        }
    }),

    // @todo: DIRECT-33651 оторвать при тестировании статистики по площадкам
    elem('pager').content()(function() {
        var script = this.data.script,
            params = this.ctx.params;

        return {
            block: 'b-pager',
            mods: {
                type: 'show-all'
            },
            mix: [{
                block: 'p-campaign-stat',
                elem: 'pager',
                elemMods: { type: (this.mods || {}).type }
            }],
            currentPage: this.data.FORM.page || (params.allpages ? -1 : 1),
            pageParam: 'page',
            startFrom: 1,
            totalCount: params.totalCount,
            perpageCount: params.perpageCount,
            allUrl: params.allpages ?
                '' : u.formatUrl({
                    host: script,
                    query: u.getUrlParams([], {
                        allpages: 1,
                        page: 0
                    })
                }),
            pageUrl: u.formatUrl({
                host: script,
                query: u.getUrlParams(['page', 'allpages', 'showstat_button'])
            }),
            keydownReaction: false, //скрываем вывод шортката DIRECT-32382
            js: {
                keydownReaction: true
            }, // но оставляем js реализацию DIRECT-32382
            content: [
                {
                    elem: 'button-prev',
                    content: [{
                        elem: 'key',
                        dir: 'l'
                    }, iget2('p-campaign-stat', 'nbsp-predydushchaya', '&nbsp;предыдущая')]
                },
                params.hideButtonAll ? '' : {
                    elem: 'button-all',
                    content: iget2('p-campaign-stat', 'vse', 'все')
                },
                {
                    elem: 'button-next',
                    content: [iget2('p-campaign-stat', 'sleduyushchaya-nbsp', 'следующая&nbsp;'), {
                        elem: 'key',
                        dir: 'r'
                    }]
                },
                {
                    elem: 'pages',
                    showFirst: true,
                    showLast: true
                }
            ]
        };
    }),

    elem('pager').elemMod('type', 'mo').content()(function() {
        var data = this.data,
            script = data.script,

            // Всего строк
            totalCount = data.row_num,

            // Строк на страницу
            perpageCount = !data.page_size || data.page_size > 10000 ? 100 : this.data.page_size,

            // Количество страниц
            pageCount = Math.ceil(totalCount / perpageCount),

            needStartLink = false,
            currentPage,
            startFrom = 1,

            formatUrlQuery = function(params) {
                return u._.keys(params).reduce(function(acc, key) {
                    var param = params[key];

                    // DIRECT-126128, чтобы убрать пустые параметры
                    if (param) {
                        acc[key] = encodeURIComponent(param);
                    }

                    return acc;
                }, {});
            };

        if (data.page) {
            currentPage = data.page < 1 ? 1 : data.page;
        } else {
            currentPage = 1;
        }

        // skywhale: DIRECT-49467
        // Временный b-pager для МОЛ
        if (pageCount > 9 && currentPage > 9) {
            needStartLink = true;
        }

        return {
            block: 'b-pager',
            mods: {
                type: 'mol'
            },
            mix: [{
                block: 'p-campaign-stat',
                elem: 'pager',
                elemMods: { type: (this.mods || {}).type }
            }],
            currentPage: currentPage,
            pageParam: 'page',
            startFrom: startFrom,
            totalCount: totalCount,
            perpageCount: perpageCount,
            allUrl: u.formatUrl({
                host: script,
                query: formatUrlQuery(u.getUrlParams([], {
                    allpages: 1,
                    page: 0
                }))
            }),
            // DIRECT-136121: формирование ссылок лишнее, так как запросы уходят через  prepareSubmit формы 'b-statistics-form'
            // pageUrl: u.formatUrl({
            //     host: script,
            //     query: formatUrlQuery(u.getUrlParams(['page', 'allpages', 'showstat_button']))
            // }),
            keydownReaction: false, //скрываем вывод шортката DIRECT-32382
            js: {
                keydownReaction: true
            }, // но оставляем js реализацию DIRECT-32382
            content: [
                needStartLink && {
                    elem: 'button-start',
                    content: iget2('p-campaign-stat', 'v-nachalo', 'В начало')
                },
                {
                    elem: 'button-prev',
                    content: [{
                        elem: 'key',
                        dir: 'l'
                    }, iget2('p-campaign-stat', 'nbsp-predydushchaya', '&nbsp;предыдущая')]
                },
                {
                    elem: 'pages',
                    pagerRadius: 10,
                    showFirst: false,
                    showLast: false
                },
                {
                    elem: 'button-next',
                    content: [iget2('p-campaign-stat', 'sleduyushchaya-nbsp', 'следующая&nbsp;'), {
                        elem: 'key',
                        dir: 'r'
                    }]
                }
            ]
        };
    }),

    // @todo: DIRECT-33651 открыть при тестировании статистики по площадкам
    /*
    elem stat-footer, default: {
        var data = this.data,
            form = data.FORM,
            showBannersStat = form.show_banners_stat;

        // пагинация по умолчанию для баннеров
        if (showBannersStat && Array.isArray(data.banners)) {
            this.data.pagination || (this.data.pagination = {
                currentPage: form.allpages ? -1 : (form.page || 1),
                totalCount: isNaN(+data.stat_banners_num) ? (data.banners || []).length : data.stat_banners_num,
                allpages: form.allpages,
                perpageCount: data.banners_on_page,
                addNavigation: true
            });
        }

        return [
            applyCtx({ elem: 'stat-actions-rows' }),
            !showBannersStat && {
                elem: 'row',
                center: true,
                ctxCells: {
                    center: {
                        content: applyCtx({ block: 'p-campaign-stat', elem: 'show-banners-stat-button' }),
                        attrs: { colspan: 2 }
                    }
                }
            }
        ];
    }
    */

    elem('mass-actions').def()(''),

    elem('stat-actions-rows').def()(function() {
        var data = this.data,
            timeStamp = data.stat_ts && data.stat_ts * 1000, // таймстамп приходит в секундах
            lastUpdate = timeStamp && u.moment(timeStamp).format('DD.MM.YYYY HH:mm'),

            massActions = applyCtx({
                elem: 'mass-actions'
            }),
            pagination = data.pagination;

        pagination && pagination.totalCount > pagination.perpageCount || (pagination = null);

        return [
            {
                elem: 'row',
                left: {
                    block: 'p-campaign-stat',
                    elem: 'last-update',
                    content: lastUpdate ? (iget2('p-campaign-stat', 'obnovleno', 'Обновлено') + ': ' + lastUpdate) : ''
                },
                right: {
                    block: 'p-campaign-stat',
                    elem: 'actions'
                }
            },
            (pagination || massActions) && {
                elem: 'row',
                center: true,
                ctxCells: {
                    center: {
                        content: {
                            block: 'b-floater',
                            mods: {
                                'never-fixed': data.uatraits.isMobile ? 'yes' : '',
                                to: 'bottom',
                                theme: 'grey'
                            },
                            content: {
                                block: 'p-campaign-stat',
                                elem: 'actions-panel',
                                content: [
                                    massActions,
                                    pagination && {
                                        block: 'p-campaign-stat',
                                        elem: 'pagination',
                                        content: {
                                            block: 'b-pager',
                                            mods: {
                                                theme: 'embossed',
                                                type: pagination.addNavigation ? 'show-all' : ''
                                            },
                                            currentPage: +pagination.currentPage || 1,
                                            pageParam: 'page',
                                            startFrom: 1,
                                            totalCount: +pagination.totalCount,
                                            perpageCount: +pagination.perpageCount,
                                            allUrl: pagination.allpages ?
                                                '' : u.formatUrl({
                                                    host: data.script,
                                                    query: u.getUrlParams([], {
                                                        allpages: 1,
                                                        page: 0
                                                    })
                                                }),
                                            pageUrl: u.formatUrl({
                                                host: data.script,
                                                query: u.getUrlParams(['page', 'allpages', 'showstat_button'])
                                            }),
                                            keydownReaction: false, //скрываем вывод шортката DIRECT-32382
                                            js: {
                                                keydownReaction: true
                                            }, // но оставляем js реализацию DIRECT-32382

                                            content: [
                                                {
                                                    elem: 'pages',
                                                    mix: [{
                                                        block: 'p-campaign-stat',
                                                        elem: 'pagination-pages'
                                                    }],
                                                    showFirst: true,
                                                    showLast: true
                                                }
                                            ]
                                                .concat(
                                                    pagination.addNavigation ? [
                                                        {
                                                            elem: 'button-prev',
                                                            mix: [{
                                                                block: 'p-campaign-stat',
                                                                elem: 'button-prev'
                                                            }],
                                                            content: [{
                                                                elem: 'key',
                                                                dir: 'l'
                                                            }, '&nbsp;', iget2('p-campaign-stat', 'predydushchaya', 'предыдущая')]
                                                        },
                                                        pagination.hideButtonAll ? '' : {
                                                            elem: 'button-all',
                                                            mix: [{
                                                                block: 'p-campaign-stat',
                                                                elem: 'button-all'
                                                            }],
                                                            content: iget2('p-campaign-stat', 'vse', 'все')
                                                        },
                                                        {
                                                            elem: 'button-next',
                                                            mix: [{
                                                                block: 'p-campaign-stat',
                                                                elem: 'button-next'
                                                            }],
                                                            content: [iget2('p-campaign-stat', 'sleduyushchaya', 'следующая'), '&nbsp;', {
                                                                elem: 'key',
                                                                dir: 'r'
                                                            }]
                                                        }
                                                    ] : [])
                                        }
                                    }
                                ]
                            }
                        },
                        attrs: {
                            colspan: 2
                        }
                    }
                }
            }
        ];
    }),

    elem('stat-actions-row').def()(function() {
        var timeStamp = this.data.stat_ts && this.data.stat_ts * 1000, // таймстамп приходит в секундах

            lastUpdate = timeStamp && u.moment(timeStamp).format('DD.MM.YYYY HH:mm');

        return {
            elem: 'row',
            center: true,
            ctxCells: {
                center: {
                    content: {
                        block: 'p-campaign-stat',
                        elem: 'actions-row',
                        content: [{
                            block: 'p-campaign-stat',
                            elem: 'last-update',
                            content: lastUpdate ? (iget2('p-campaign-stat', 'obnovleno', 'Обновлено') + ': ' + lastUpdate) : ''
                        }]
                            .concat(applyCtx({ elem: 'actions' }))
                    },
                    attrs: {
                        colspan: 2
                    }
                }
            }
        };
    }),

    elem('actions').content()(function() {
        var data = this.data,
            actions = [];

        !data.pilfer_xls && actions.push({
            block: 'b-statistics-form',
            elem: 'download-as-xls'
        });

        actions.push({
            block: 'link',
            mods: {
                pseudo: 'yes',
                inner: 'yes'
            },
            mix: [{
                block: 'p-campaign-stat',
                elem: 'print'
            }],
            content: [
                {
                    block: 'b-icon',
                    mods: {
                        type: 'print'
                    },
                    mix: [{ block: 'link', elem: 'icon' }],
                    alt: iget2('p-campaign-stat', 'raspechatat', 'распечатать')
                },
                {
                    elem: 'inner',
                    content: iget2('p-campaign-stat', 'raspechatat', 'распечатать')
                }
            ],
            url: '#'
        });

        return actions;
    }),

    elem('show-banners-stat-button').content()(function() {
        var data = this.data;

        return {
            block: 'link',
            content: iget2('p-campaign-stat', 'pokazat-detalnuyu-statistiku-po', 'Показать детальную статистику по объявлениям'),
            url: u.formatUrl({
                host: data.SCRIPT,
                query: u.getUrlParams([], {
                    show_banners_stat: 1
                })
            })
        };
    }),

    elem('mol-stat-actions-row').def()(function() {
        return {
            elem: 'row',
            center: true,
            ctxCells: {
                center: {
                    content: {
                        block: 'b-floater',
                        mix: {
                            block: 'p-campaign-stat',
                            elem: 'floater'
                        },
                        mods: {
                            to: 'bottom',
                            theme: 'grey'
                        },
                        content: {
                            block: 'p-campaign-stat',
                            elem: 'mol-actions-panel',
                            content: [
                                {
                                    block: 'button',
                                    mods: { disabled: 'yes' },
                                    mix: [{
                                        block: 'p-campaign-stat',
                                        elem: 'add-plus-phrases'
                                    }],
                                    content: iget2('p-campaign-stat', 'dobavit-v-klyuchevye-frazy', 'Добавить в ключевые фразы')
                                },
                                {
                                    block: 'button',
                                    mods: { disabled: 'yes' },
                                    mix: [{
                                        block: 'p-campaign-stat',
                                        elem: 'add-minus-phrases'
                                    }],
                                    content: iget2('p-campaign-stat', 'dobavit-v-minus-frazy', 'Добавить в минус-фразы')
                                },
                                applyCtx({
                                    block: 'p-campaign-stat',
                                    elem: 'pager',
                                    elemMods: { type: 'mo' }
                                })
                            ]
                        }
                    },
                    attrs: {
                        colspan: 2
                    }
                }
            }
        };
    })
);
