BEM.DOM.decl('p-campaign-stat', {

    onSetMod: {
        js: function() {
            if (this.params.campaign && this.params.modelParams) {
                BEM.MODEL.create(this.params.modelParams, this.params.campaign);
            }

            this.bindTo('print', 'click', function(e) {
                e.preventDefault();

                window.print();
            });

            if (this.params.offline) {
                this.findBlockInside('b-statistics-form').showWarning();
            }

            if (this.params.needMassActions) {
                this._initPhrasesEvents();
                this._checkFloater();
            }

            var oldDayBudgetWarning = this.findBlockOn('day-budget-warning-container', 'b-page-warning');

            if (oldDayBudgetWarning) {
                BEM.blocks['b-metrika2'].params({
                    params: {
                        'day-budget-recommendation': {
                            type: 'new',
                            place: 'stat',
                            event: 'show'
                        }
                    }
                });

                oldDayBudgetWarning.on('close', function() {
                    BEM.blocks['b-metrika2'].params({
                        params: {
                            'day-budget-recommendation': {
                                type: 'new',
                                place: 'stat',
                                event: 'close'
                            }
                        }
                    });
                });
            }

            BEM.blocks['b-pager'].on(this.domElem, 'change-page', function(e, data) {
                this.findBlockInside('b-statistics-form').prepareSubmit({ page: data.page });
            }, this);
        }
    },

    /**
     * Общие методы для работы с фраза для МО и МОЛ
     */

    /**
     * Возвращает блок массовых действий
     * @returns {BEM}
     * @private
     */
    _getMassActions: function() {
        return this._massActions || (this._massActions = this.findBlockOn('mass-actions', 'b-mass-actions'));
    },

    /**
     * Выполняет подписку на события
     * @returns {BEM}
     * @private
     */
    _initPhrasesEvents: function() {
        var togglePhrasesButtonDebounce = $.debounce(this._togglePhrasesButton, 50, this);

        this._statTable = this.findBlockInside('b-stat-table');
        this._tableModel = this._statTable.getStatModel();
        this._addPlusPhrasesButton = this.findBlockInside('add-plus-phrases', 'button');
        this._addMinusPhrasesButton = this.findBlockInside('add-minus-phrases', 'button');
        this._pager = this.findBlockInside('pager', 'b-pager');

        this._addPlusPhrasesButton.on('click', function() {
            this._buildPlusPhrasesPopup();
        }, this);

        this._addMinusPhrasesButton.on('click', function() {
            this._buildMinusPhrasesPopup();
        }, this);

        this._tableModel
            .on('detailed-rows', 'change', function(e, data) {
                switch (data.innerField) {
                    case 'search_query_checkbox':
                    case 'contextcond_ext_checkbox':
                        togglePhrasesButtonDebounce();
                }
            }, this);

        return this;
    },

    /**
     * Возвращает информацию о занятом количестве символов минус-фразами в группах/кампаниях
     * @return {{campaigns: Object, groups: Object}}
     * @private
     */
    _getMinusWordsLength: function() {
        return this._minusWordsLength || (this._minusWordsLength = this.params.minusWordsLength);
    },

    /**
     * Обновляет информацию о занятом количестве символов минус-фразами в группах/кампаниях
     * @private
     * @param {Object} data
     * @param {{phrase: String, id: String}[]} data.groups
     * @param {{phrase: String, id: String}[]} data.campaigns
     */
    _updateMinusWordsLength: function(data) {
        var minusWordsLength = this._getMinusWordsLength();

        data.groups && data.groups.forEach(function(group) {
            minusWordsLength.groups[group.id] = group.newLength;
        });

        data.campaigns && data.campaigns.forEach(function(campaign) {
            minusWordsLength.campaigns[campaign.id] = campaign.newLength;
        });
    },

    _getDataForMinusPhrasesPopup: function() {
        var cids = [],
            adgroupIds = [],
            groupsInfo = this._tableModel.getGroupsInfo(),
            campaignsInfo = this.params.campaigns,
            minusWordsLength = this._getMinusWordsLength(),
            phrases = this._tableModel.getSelectedPhrasesData().map(function(phrase) {
                var adgroupId = phrase.pid,
                    cid = groupsInfo[adgroupId].cid;

                cids.push(cid);
                adgroupIds.push(adgroupId);

                return {
                    cid: cid,
                    campName: campaignsInfo[cid].name,
                    adgroupId: adgroupId,
                    groupName: groupsInfo[adgroupId].groupName,
                    bid: phrase.bid,
                    text: u.minusWords.wrapInQuotes(phrase.src_phrase),
                    report_row_hash: phrase.report_row_hash
                };
            });

        return {
            phrases: phrases,
            groupsSymbolsCounter: u._.uniq(adgroupIds).reduce(function(res, adgroupId) {
                res[adgroupId] = minusWordsLength.groups[adgroupId];

                return res;
            }, {}),
            campaignsSymbolsCounter: u._.uniq(cids).reduce(function(res, cid) {
                res[cid] = minusWordsLength.campaigns[cid];

                return res;
            }, {}),
            statType: this.getMod('type')
        }
    },

    /**
     * Строит попап для работы с выбранными фразами
     * @private
     */
    _buildPlusPhrasesPopup: function() {
        var subMan = BEM.create('i-subscription-manager'),
            modal = BEM.DOM.blocks['b-modal-popup-decorator'].create(
                null,
                { bodyScroll: false, childState: true }
            ),
            statPhrasesPopup = modal
                .setPopupContent({
                    block: 'b-stat-table-phrases-popup',
                    mods: { type: 'plus' },
                    ctxData: {
                        phrases: this._tableModel.getSelectedPhrasesData(),
                        groups: this._tableModel.getGroupsInfo(),
                        campaigns: this.params.campaigns,
                        currency: this.params.clientCurrency,
                        statType: this.getMod('type')
                    }
                });

        subMan
            .on(statPhrasesPopup, 'cancel', function() {
                modal.hide({ force: true });
            })
            .on(statPhrasesPopup, 'prepare-stat-phrases-error', function() {
                BEM.blocks['b-confirm'].open({
                    type: 'alert',
                    message: [
                        iget2(
                            'p-campaign-stat',
                            'proizoshla-neizvestnaya-oshibka-poprobuyte',
                            'Произошла неизвестная ошибка. Попробуйте перегрузить страницу или обратитесь к сервису позже.'
                        ),
                        iget2('p-campaign-stat', 'prinosim-izvineniya-za-neudobstva', 'Приносим извинения за неудобства.')
                    ].join('</br>'),
                    onYes: function() {
                        modal.hide({ force: true });
                    }
                }, this);
            }, this)
            .on(statPhrasesPopup, 'phrases-added', function() {
                // DIRECT-65239 - статусы выпиливаем не окончательно, пока что-просто скрываем
                // вместо updatePhrasesStatus сбрасываем выбранные resetCheckboxes
                // this._statTable.updatePhrasesStatus(data.added || []);
                // this._checkFloater();
                this._statTable.resetCheckboxes();

                modal.hide({ force: true });
            }, this)
            .on(modal, 'close', function() {
                subMan.dispose();
                subMan.destruct();

                modal.destruct();
            });

        modal.show();
    },
    /**
     * Строит попап для работы с выбранными фразами
     * @private
     */
    _buildMinusPhrasesPopup: function() {
        var subMan = BEM.create('i-subscription-manager'),
            modal = BEM.DOM.blocks['b-modal-popup-decorator'].create(
                null,
                { bodyScroll: false, childState: true }
            ),
            statPhrasesPopup = modal
                .setPopupContent({
                    block: 'b-stat-table-phrases-popup',
                    mods: { type: 'minus' },
                    ctxData: this._getDataForMinusPhrasesPopup()
                });

        subMan
            .on(statPhrasesPopup, 'cancel', function() {
                modal.hide({ force: true });
            }, this)
            .on(statPhrasesPopup, 'phrases-excluded', function(e, data) {
                this._updateMinusWordsLength(data.newMinusWordsLength);
                this._statTable.resetCheckboxes();

                modal.hide({ force: true });

                BEM.blocks['b-confirm'].open({
                    type: 'alert',
                    message: iget2('p-campaign-stat', 'dobavleno-unikalnyh-minus-fraz', 'Добавлено уникальных минус-фраз: {foo}', {
                        foo: data.addedCount
                    })
                });
            }, this)
            .on(modal, 'close-blocked', function() {
                BEM.DOM.blocks['b-confirm'].open({
                    message: iget2(
                        'p-campaign-stat',
                        'v-forme-est-nesohranennye',
                        'В форме есть несохраненные изменения. Если закрыть форму, они будут утеряны.'
                    ),
                    textYes: iget2('p-campaign-stat', 'ok', 'ОК'),
                    textNo: iget2('p-campaign-stat', 'otmenit', 'Отменить'),
                    fromPopup: modal.getPopup(),
                    onYes: function() {
                        modal.hide({ force: true });
                    }
                });
            }, this)
            .on(modal, 'close', function() {
                subMan.dispose();
                subMan.destruct();

                modal.destruct();
            });

        modal.show();
    },

    /**
     * Возвращает true, если хоть одна фраза выбрана
     * @returns {Boolean}
     * @private
     */
    _isAnyChecked: function() {
        return this._tableModel.isAnyChecked('search_query_checkbox') ||
            this._tableModel.isAnyChecked('contextcond_ext_checkbox')
    },

    /**
     * Выставляет модификатор disabled в зависимости от выбранных фраз
     * @private
     */
    _togglePhrasesButton: function() {
        var isDisabled = !this._isAnyChecked();

        this._addPlusPhrasesButton.toggleMod('disabled', 'yes', isDisabled);
        this._addMinusPhrasesButton.toggleMod('disabled', 'yes', isDisabled);
    },

    /**
     * Показывает/скрывает кнопки действий в зависимости от доступных фраз
     * Удаляет b-floater если внутри него нет пагинации и нет доступных действий
     * @private
     */
    _checkFloater: function() {
        var mediaType = this.params.mediaType,
            hasAvailableSearchQuery = this._tableModel.hasPhrasesForAdding('search_query_status'),
            hasAvailableExtPhrase = this._tableModel.hasPhrasesForAdding('ext_phrase_status');

        if (hasAvailableSearchQuery || hasAvailableExtPhrase) {
            // запрещает добавление плюс фраз для ОД в отчете по одной кампании и для смартов
            if (['dynamic', 'performance'].indexOf(mediaType) === -1) {
                this.setMod(this._addPlusPhrasesButton.domElem, 'visible', 'yes');
            }

            this.setMod(this._addMinusPhrasesButton.domElem, 'visible', 'yes');
        } else {
            this.delMod(this._addPlusPhrasesButton.domElem, 'visible')
                .delMod(this._addMinusPhrasesButton.domElem, 'visible');
        }

        // решение нехорошее необходимо в таком случае не создавать блок,
        // т.к. данные для таблицы формируются в блоке b-mol-stat-data и p-campaign-stat о них ничего не знает
        if (!this._pager && !(hasAvailableSearchQuery || hasAvailableExtPhrase)) {
            this.findBlockInside('floater', 'b-floater').destruct();
        }
    }

});
