block('p-campaign').elem('info').replace()(function() {
    var data = this.data,
        ulogin = data.user_login,
        optimizeCamp = data.optimize_camp,
        campaign = data.campaign,
        isInternalCampaign = u.consts('rights').enableInternalCampaigns && u.campaign.isInternal(campaign.type),
        modelParams = {
            id: campaign.cid,
            name: u.campaign.getCampaignModelName(campaign.mediaType)
        },
        campsList = [],
        text = [],
        briefRows = [],
        briefStatsInfo = u.campaign.isCpm(campaign.mediaType) ? 'shows' : 'clicks',
        hasWallet = data.wallet_is_enabled == '1',
        walletTotal = data.sums_uni.wallet_total;

    data.agency_uid && !data.agency_client_relation && text.push({
        block: 'icon-text',
        mods: { theme: 'alert', size: 'ms' },
        text: hasLoginRights('is_any_client') ?
            iget2('p-campaign', 'vashe-obsluzhivanie-v-etom', 'Ваше обслуживание в этом агентстве завершено') : iget2('p-campaign', 'obsluzhivanie-klienta-zaversheno', 'Обслуживание клиента завершено')
    }, {
        block: 'b-metrika2',
        js: {
            immediate: {
                showCamp: 'agency-stopped'
            }
        }
    });

    data.is_camp_locked && text.push({
        block: 'icon-text',
        mods: { theme: 'alert', size: 'ms' },
        text: [
            iget2(
                'p-campaign',
                'kampaniya-zablokirovana-posle-vygruzki',
                'Кампания заблокирована после выгрузки в XLS/XLSX файл. Функции редактирования временно недоступны.'
            ) + ' ',
            {
                block: 'link',
                url: u.getUrl('unlockCamp', {
                    cid: data.cid,
                    ulogin: ulogin
                }),
                content: iget2('p-campaign', 'razblokirovat', 'Разблокировать')
            },
            {
                block: 'b-metrika2',
                js: {
                    immediate: {
                        showCamp: 'xls-blocked'
                    }
                }
            }
        ]
    });

    !campaign.currency_archived && data.camps_name_only.forEach(function(camp) {
        if (camp.cid != data.cid) {

            campsList.push({
                url: u.getUrl('showCamp', {
                    cid: camp.cid,
                    ulogin: ulogin
                }),
                name: camp.name,
                cid: camp.cid,
                mediaType: camp.mediaType,
                total: u.currencies.formatSum(camp.currency, hasWallet ? walletTotal : camp.total)
            });
        }
    });

    if (+data.wallet_cid) {
        briefRows.push(['start-date'], [briefStatsInfo]);
    } else {
        campaign.currency !== 'YND_FIXED' ?
            briefRows.push(['start-date', 'rest-block'], [briefStatsInfo]) :
            briefRows.push(['start-date', 'sum-block'], [briefStatsInfo, 'rest-block']);
    }

    return {
        block: 'b-campaign-info',
        modelParams: modelParams,
        header: {
            headword: iget2('p-campaign', 'kampaniya-110', 'Кампания'),
            allCampsUrl: isInternalCampaign ?
                u.formatUrl({
                    path: '/dna/grid/campaigns',
                    query: {
                        ulogin: ulogin
                    }
                }) :
                u.getUrl('showCamps', {
                    ulogin: ulogin
                }),
            campsList: campsList,
            cname: data.cname,
            cid: data.cid,
            text: text
        },
        js: {
            modelParams: modelParams,
            cid: data.cid,
            optimizeRequestId: (optimizeCamp || {}).request_id,
            ulogin: ulogin
        },
        showOptToolbox: (optimizeCamp && optimizeCamp.status.match('Ready') && !+optimizeCamp.hide_optimize_ready) ||
            u.consts('hasOptimizedCampMediaplan'),
        details: true,
        migration: this.ctx.migration,
        state: {
            text: data.status.text,
            mods: {
                with: 'direct-warning'
            }
        },
        actionsBar: !(hasLoginRights('media_control') || !data.allow_edit_camp) && data.archived != 'Yes' && {
            showModerate: data.statusModerate == 'New' && !!data.banners.length,
            addBannerMultiEdit: true,
            optimizeCamp: optimizeCamp,
            canOptimizeCamp: data.login_rights.role != 'client' && optimizeCamp &&
                optimizeCamp.request_id && optimizeCamp.status.match(/^(New|InProcess|AutoRequest)$/)
        },
        brief: {
            rows: briefRows,
            startDate: data.dd + '.' + data.mm + '.' + data.yyyy,
            clicks: data.clicks,
            shows: data.shows,
            sum: data.sum,
            total: data.total,
            bonus: data.bonus,
            blockedPayment: data.statusNoPay == 'Yes',
            blockedMoney: data.sum && data.money_type == 'blocked',
            canPay: data.statusNoPay == 'No' && !campaign.currency_archived &&
                (data.statusModerate == 'Yes' || data.manager_uid || data.agency_uid) &&
                !hasLoginRights('agency_limited_no_pay')
        }
    };
});
