block('p-campaign').elem('models-data').content()(

    match(function() {
        return this.data.campaign.mediaType === 'text';
    })(function() {
        var campaign = this.data.campaign;
        var organizations = this.data.organizations;

        return {
            block: 'i-model-aggregator',
            content: campaign.groups.reduce(function(result, group) {

                return result.concat([
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'm-group',
                            id: group.modelId,
                            data: u['m-group'].transformData({
                                group: group,
                                loadVCardFromClient: this.data.loadVCardFromClient,
                                campaignTags: campaign.tags
                            })
                        }
                    },
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'm-geo-regions',
                            parentName: 'm-group',
                            id: group.modelId,
                            parentId: group.modelId,
                            data: {
                                geo: group.geo,
                                geo_names: group.geo_names
                            }
                        }
                    },
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'm-adjustment-rates',
                            id: group.modelId,
                            data: group.hierarchicalMultipliers
                        }
                    }
                ]);
            }.bind(this), []).concat(Object.keys(organizations).reduce(function(result, permalink) {
                var organizationData = organizations[permalink];

                return result.concat([

                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'm-organization',
                            id: permalink,
                            data: u['m-organization'].transformData({
                                organization: organizationData
                            })
                        }
                    }
                ]);
            }.bind(this), []))
        };
    }),

    match(function() {
        return this.data.campaign.mediaType === 'mobile_content';
    })(function() {
        var campaign = this.data.campaign;

        return {
            block: 'i-model-aggregator',
            content: campaign.groups.reduce(function(result, group) {
                return result.concat([
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'dm-mobile-content-group',
                            id: group.modelId,
                            data: u['dm-mobile-content-group'].transformData({
                                group: group,
                                campaign: campaign,
                                campaignTags: campaign.tags
                            })
                        }
                    },
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'm-geo-regions',
                            parentName: 'dm-mobile-content-group',
                            id: group.modelId,
                            parentId: group.modelId,
                            data: {
                                geo: group.geo,
                                geo_names: group.geo_names
                            }
                        }
                    },
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'm-adjustment-rates',
                            id: group.modelId,
                            data: group.hierarchicalMultipliers
                        }
                    }
                ]);
            }.bind(this), [])
        };
    }),

    match(function() {
        return this.data.campaign.mediaType === 'dynamic';
    })(function() {
        var campaign = this.data.campaign,
            loadVCardFromClient = this.data.loadVCardFromClient;

        return [
            {
                block: 'i-model-aggregator',
                content: campaign.groups.map(function(group) {
                    return {
                        block: 'i-model',
                        modelParams: {
                            name: 'dm-dynamic-group',
                            id: group.adgroup_id,
                            data: u['dm-dynamic-group'].transformData({
                                group: group,
                                campaignTags: campaign.tags,
                                loadVCardFromClient: loadVCardFromClient
                            })
                        }
                    };
                })
            }
        ];
    }),

    match(function() {
        return this.data.campaign.mediaType == 'performance';
    })(function() {
        var campaign = this.data.campaign;

        return [
            {
                block: 'i-model-aggregator',
                content: campaign.groups.map(function(group) {
                    return {
                        block: 'i-model',
                        modelParams: {
                            name: 'dm-dynamic-media-group',
                            id: group.adgroup_id,
                            data: u['dm-dynamic-media-group'].transformData({
                                group: group,
                                campaignTags: campaign.tags
                            })
                        }
                    };
                })
            }
        ];
    }),

    match(function() {
        return this.data.campaign.mediaType == 'mcbanner'
    })(function() {
        var campaign = this.data.campaign;

        return {
            block: 'i-model-aggregator',
            content: campaign.groups.reduce(function(result, group) {
                return result.concat([
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'dm-mcbanner-group',
                            id: group.modelId,
                            data: u['dm-mcbanner-group'].transformData({
                                group: group,
                                campaignTags: campaign.tags
                            })
                        }
                    },
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'm-geo-regions',
                            parentName: 'dm-mcbanner-group',
                            id: group.modelId,
                            parentId: group.modelId,
                            data: {
                                geo: group.geo,
                                geo_names: group.geo_names
                            }
                        }
                    },
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'm-adjustment-rates',
                            id: group.modelId,
                            data: group.hierarchicalMultipliers
                        }
                    }
                ]);
            }.bind(this), [])
        };
    }),

    match(function() {
        return this.data.campaign.mediaType === 'cpm_banner';
    })(function() {
        var data = this.data,
            campaign = data.campaign;

        return {
            block: 'i-model-aggregator',
            content: campaign.groups.reduce(function(result, group) {
                group.cpmGroupType = group.cpm_banners_type || 'cpm_banner';

                return result.concat([
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'dm-cpm-banner-group',
                            id: group.modelId,
                            data: u['dm-cpm-banner-group'].transformData({
                                isAllowEmptyRetCondInterests: !!(data.features_enabled_for_client || {}).cpm_banner_enable_empty_ret_cond_json, // eslint-disable-line
                                group: group,
                                campaignTags: campaign.tags
                            })
                        }
                    },
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'm-geo-regions',
                            parentName: 'dm-cpm-banner-group',
                            id: group.modelId,
                            parentId: group.modelId,
                            data: {
                                geo: group.geo,
                                geo_names: group.geo_names
                            }
                        }
                    },
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'm-adjustment-rates',
                            id: group.modelId,
                            data: group.hierarchicalMultipliers
                        }
                    }
                ]);
            }, [])
        };
    }),

    match(function() {
        return this.data.campaign.mediaType === 'cpm_yndx_frontpage';
    })(function() {
        var data = this.data,
            campaign = data.campaign;

        return {
            block: 'i-model-aggregator',
            content: campaign.groups.reduce(function(result, group) {
                return result.concat([
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'dm-cpm-yndx-frontpage-banner-group',
                            id: group.modelId,
                            data: u['dm-cpm-yndx-frontpage-banner-group'].transformData({
                                isAllowFrontpageProfile: hasEnabledFeatures('cpm_yndx_frontpage_profile'),
                                group: group,
                                campaignTags: campaign.tags
                            })
                        }
                    },
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'm-geo-regions',
                            parentName: 'dm-cpm-yndx-frontpage-banner-group',
                            id: group.modelId,
                            parentId: group.modelId,
                            data: {
                                geo: group.geo,
                                geo_names: group.geo_names
                            }
                        }
                    },
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'm-adjustment-rates',
                            id: group.modelId,
                            data: group.hierarchicalMultipliers
                        }
                    }
                ]);
            }, [])
        };
    }),

    match(function() {
        return this.data.campaign.mediaType === 'cpm_price';
    })(function() {
        var data = this.data,
            campaign = data.campaign;

        return {
            block: 'i-model-aggregator',
            content: campaign.groups.reduce(function(result, group) {
                return result.concat([
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'dm-cpm-price-banner-group',
                            id: group.modelId,
                            data: u['dm-cpm-price-banner-group'].transformData({
                                isAllowFrontpageProfile: true,
                                group: group,
                                campaignTags: campaign.tags
                            })
                        }
                    },
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'm-geo-regions',
                            parentName: 'dm-cpm-price-banner-group',
                            id: group.modelId,
                            parentId: group.modelId,
                            data: {
                                geo: group.geo,
                                geo_names: group.geo_names
                            }
                        }
                    },
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'm-adjustment-rates',
                            id: group.modelId,
                            data: group.hierarchicalMultipliers
                        }
                    }
                ]);
            }, [])
        };
    }),

    match(function() {
        return this.data.campaign.mediaType === 'cpm_deals';
    })(function() {
        var data = this.data,
            campaign = data.campaign;

        return {
            block: 'i-model-aggregator',
            content: campaign.groups.reduce(function(result, group) {
                return result.concat([
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'dm-cpm-deals-group',
                            id: group.modelId,
                            data: u['dm-cpm-deals-group'].transformData({
                                group: group,
                                campaignTags: campaign.tags
                            })
                        }
                    },
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'm-geo-regions',
                            parentName: 'dm-cpm-deals-group',
                            id: group.modelId,
                            parentId: group.modelId,
                            data: {
                                geo: group.geo,
                                geo_names: group.geo_names
                            }
                        }
                    },
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'm-adjustment-rates',
                            id: group.modelId,
                            data: group.hierarchicalMultipliers
                        }
                    }
                ]);
            }, [])
        };
    }),

    match(function() {
        return this.data.campaign.mediaType === 'content_promotion';
    })(function() {
        var data = this.data,
            campaign = data.campaign;

        return {
            block: 'i-model-aggregator',
            content: campaign.groups.reduce(function(result, group) {
                return result.concat([
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'dm-content-promotion-group',
                            id: group.modelId,
                            data: u['dm-content-promotion-group'].transformData({
                                group: group,
                                campaignTags: campaign.tags
                            })
                        }
                    },
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'm-geo-regions',
                            parentName: 'dm-content-promotion-group',
                            id: group.modelId,
                            parentId: group.modelId,
                            data: {
                                geo: group.geo,
                                geo_names: group.geo_names
                            }
                        }
                    },
                    {
                        block: 'i-model',
                        modelParams: {
                            name: 'm-adjustment-rates',
                            id: group.modelId,
                            data: group.hierarchicalMultipliers
                        }
                    }
                ]);
            }, [])
        };
    })
);
