//interface == 'std' - посмотреть легкую кампанию в профи
//media_control - для медиапланеров всегда показываем профи-интерфейс
match(function() { return this.data.cmd === 'showCamp'; })(

    block('app-main')(

        mode('preprocess')(function() {
            var data = this.data,
                form = data.FORM,
                campaign = data.campaign,
                loginRights = data.login_rights,
                autobudgetCPIWarnings = campaign.autobudget_cpi_warning || {};

            data.tab || (data.tab = 'active');

            //для работы u.contextLimit и u['b-strategy-settings2'].buildStrategy
            applyCtx({
                block: 'i-utils'
            });

            campaign.archived = data.archived;

            campaign.allAdgroupIds = [];

            campaign.strategy.search = campaign.strategy.search || {};
            campaign.strategy.net = campaign.strategy.net || {};

            //todo - скоро вместо  data.banners будут приходить data.campaign.groups
            campaign.groups = data.banners.reduce(function(groups, group) {
                campaign.allAdgroupIds.push(group.adgroup_id);

                campaign.hasOutDoorGroup || (campaign.hasOutDoorGroup = group.cpm_banners_type === 'cpm_outdoor');

                //cyn@DIRECT-74889: для кампаний типа сделки в группу adgroup_type приходит `cpm_banner`, вместо `cpm_deals`
                if (campaign.mediaType === 'cpm_deals') {
                    group.adgroup_type = 'cpm_deals'
                }

                if (campaign.mediaType === 'cpm_yndx_frontpage') {
                    campaign.allowed_frontpage_types = data.allowed_frontpage_types;
                }

                if (campaign.mediaType === 'cpm_price') {
                    campaign.allowed_frontpage_types = data.allowed_frontpage_types;
                }

                if (group.adgroup_type == 'dynamic') {
                    group.title = u.dynamicGroupsData.getBannerTitle();
                    group.href = group.main_domain;
                    group.domain = group.main_domain;
                }

                group.isBidable = true;
                group.has_site_enum = group.href ? 'yes' : 'no';
                group.banners = group.isEmptyGroup ? [] : [u._.extend({}, group)];

                // для баннера в Яндекс.Метро данные по турбо находятся в поле "turbolandingGeoproduct"
                if (group.cpm_banners_type === 'cpm_geoproduct') {
                    group.banners.forEach(function(banner) {
                        banner.turbolandingGeoproduct = banner.turbolanding;
                        banner.turbolanding = undefined;
                    })
                }

                // DIRECT-49050
                // На странице кампании статусы модерации группы приходят в полях `pstatusModerate` и `pstatusPostModerate` объекта баннера,
                // переносим их в `statusModerate` и `statusPostModerate` объекта группы, для консистентности с данными на других страницах
                group.statusModerate = group.pstatusModerate;
                group.statusPostModerate = group.pstatusPostModerate;

                groups.push(group);

                return groups;
            }, []);

            form.ulogin = form.ulogin || '';

            //на этом уровне еще не определен hasLoginRights
            campaign.readonly = !data.allow_edit_camp || data.login_rights.media_control ||
                campaign.currency_archived || data.archived == 'Yes';

            campaign.sum_rest = data.total;
            campaign.minus_words = {
                minus_words: data.minus_words
            };
            campaign.strategy_name = campaign.strategy.name;

            //DIRECT-54416 в campaign не приходят значения про ограничения на тематических площадках
            campaign.ContextPriceCoef = campaign.ContextPriceCoef || data.ContextPriceCoef;
            // skywhale DIRECT-56236:
            // на странице кампании ContextLimit приходит не в campaign а лежит на одном уровне с campaign
            // исторические причины, изначально весь стеш и был campaign
            if (!campaign.ContextLimit && data.ContextLimit) {
                campaign.ContextLimit = data.ContextLimit;
            }

            if (campaign.strategy.name == 'different_places') { // DIRECT-13939
                campaign.ContextLimit = 100;
                campaign.ContextPriceCoef = 100;
            }

            campaign.ContextLimit = u.contextLimit.prepareValue(campaign.ContextLimit);

            campaign.day_budget2 = campaign.day_budget;
            campaign.strategy2 = u['b-campaign-strategy2'].buildStrategy(campaign);
            // бэк не может гарантировать тип переменной, поэтому не строгое равенство
            campaign.isCpaPayForConversionEnabled = campaign.strategy.search.pay_for_conversion == 1 ||
                campaign.strategy.net.pay_for_conversion == 1;

            campaign.metrika = {
                campaign_goals: Object.keys(campaign.campaign_goals).map(function(id) {
                    return campaign.campaign_goals[id];
                }),
                compaign_domains_count: data.compaign_domains_count,
                cpa_deviation: !!+(campaign.autobudget_cpa_warning && campaign.autobudget_cpa_warning.cpa_deviation) ||
                    false,
                apc_deviation: !!+(campaign.autobudget_cpa_warning && campaign.autobudget_cpa_warning.apc_deviation) ||
                    false
            };

            campaign.rmpCounters = {
                allow_autobudget_avg_cpi: 1,
                decrease_setup: autobudgetCPIWarnings.decrease_setup,
                cpi_deviation: autobudgetCPIWarnings.cpi_deviation,
                apps_count: autobudgetCPIWarnings.apps_count,
                setup_deviation: autobudgetCPIWarnings.setup_deviation
            };

            campaign.broad_match_flag = data.broad_match_flag;
            campaign.broad_match_limit = data.broad_match_limit;

            data.CAMP_OPTIONS.platform = data.CAMP_OPTIONS.platform == 'both' ? '' : data.CAMP_OPTIONS.platform;

            campaign.platform = campaign.strategy.name == 'different_places' ?
                (campaign.strategy.search.name != 'stop' ? this.data.CAMP_OPTIONS.platform || 'search' : 'context') :
                'search';

            ['cid', 'ulogin'].forEach(function(name) {
                campaign[name] = form[name] || campaign[name];
            });

            campaign.has_editable_banners = false;

            campaign.groups.forEach(function(group, i) {
                group = u['i-banners-group-data'].patch({
                    count: i,
                    isBannersEditable: hasLoginRights('super_control', 'support_control', 'placer_control'),
                    bannersGroup: group,
                    campaignTags: campaign.tags || [],
                    tagIds: form.tags_ids || (group.isEmptyGroup ? form['tags_ids-' + group.banners[0].bid] : '') || ''
                }, data);

                if (group.is_banner_oversized) { //@see DIRECT-28474
                    campaign.hasOversizedBanners = true;
                }

                // @see: DIRECT-50241
                campaign.hasOversizedPhrases |= !!(+group.does_phrase_exceed_max_length);
                campaign.hasOversizedPhraseWordCount |= !!(+group.does_phrase_exceed_max_words);
                campaign.hasOversizedPhraseWordLength |= !!(+group.does_phrase_exceed_word_max_length);
                campaign.hasOversizedPhraseMinusWordLength |= !!(+group.does_phrase_exceed_minus_word_max_length);

                group.minus_words = group.minus_words || group.banner_minus_words;
                group.editable_price = (data.allow_edit_camp || loginRights.limited_support_control) &&
                    !loginRights.media_control &&
                    data.archived !== 'Yes' && !group.isEmptyGroup && group.is_completed_group;

                if (group.editable_price) campaign.has_editable_banners = true;

                // нормализация фильтров для создания моделей для ДМО и ДО
                ~['performance', 'dynamic'].indexOf(campaign.mediaType) && u['p-campaign'].fulfill(group, campaign, {
                    viewOnly: data.view_only,
                    allowEdit: !!data.allow_edit_camp && !loginRights.media_control && data.archived !== 'Yes'
                });
            }, this);

            campaign.tags = campaign.tags.map(function(tag) {
                return {
                    id: tag.tag_id,
                    value: tag.value,
                    uses_count: tag.uses_count
                };
            });

            data = u['i-phrases-separate-into-groups'].patch(data);

            if (campaign.mediaType === 'cpm_banner' || campaign.mediaType === 'text') {
                data.contentCategoriesData = u['content-categories-targeting'].getSegmentsIdsAndTree(data.java_crypta_segments);
            }

            return data;
        }),

        mode('page-block')('p-campaign')
    ),

    block('b-page').mode('title')(function() {
        return iget2('p-campaign', 'kampaniya-s', 'Кампания "{foo}"', {
            foo: this.data.cname
        });
    })
);

block('p-campaign')(

    addJs()(function() {
        var cpmYndxFrontpageGroups = [];

        if (this.data.campaign.mediaType === 'cpm_yndx_frontpage') {
            cpmYndxFrontpageGroups = this.data.campaign.groups.map(function(group) {
                return {
                    geo: group.geo,
                    price: +group.general_limit_price,
                    adgroup_id: group.adgroup_id
                }
            });
        }

        return {
            modelParams: {
                id: this.data.campaign.cid,
                name: u.campaign.getCampaignModelName(this.data.campaign.mediaType)
            },
            ageVariants: (this.data.AD_WARNINGS.age && this.data.AD_WARNINGS.age.variants) || [18, 16, 12, 6, 0],
            babyAgeVariants: (this.data.AD_WARNINGS.baby_food && this.data.AD_WARNINGS.baby_food.variants)
                .sort(function(a, b) {
                    return b - a;
                }) || [12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0],
            form: {
                name: 'mform',
                action: this.data.script,
                params: {
                    'is-copy': 0,
                    retpath: u.getCurrentUrl(),
                    tab: this.data.tab,
                    cid: this.data.campaign.cid,
                    ulogin: this.data.user_login
                }
            },
            cpmYndxFrontpageGroups: cpmYndxFrontpageGroups
        };
    }),

    mode('action-captions')(function() {
        return {
            editBannersNew: iget2('p-campaign', 'edit-banners', 'Редактировать объявления'),
            editGroupsNew: iget2('p-campaign', 'edit-groups', 'Редактировать группы'),
            edit: iget2('p-campaign', 'redaktirovat', 'Редактировать'),
            editDynamic: iget2('p-campaign', 'redaktirovat', 'Редактировать'),
            editPerformance: iget2('p-campaign', 'redaktirovat', 'Редактировать'),
            editMcbanner: iget2('p-campaign', 'redaktirovat', 'Редактировать'),
            editCpmBanner: iget2('p-campaign', 'redaktirovat', 'Редактировать'),
            editContentPromotion: iget2('p-campaign', 'redaktirovat', 'Редактировать'),
            editTags: iget2('p-campaign', 'zadat-obshchie-metki', 'Задать общие метки'),
            editAgeLabels: iget2('p-campaign', 'izmenit-vozrastnoe-ogranichenie', 'Изменить возрастное ограничение'),
            editChildAgeLabels: iget2('p-campaign', 'izmenit-vozrast-dlya-detskogo', 'Изменить возраст для детского питания'),
            copy: iget2('p-campaign', 'kopirovat', 'Копировать'),
            copyDynamic: iget2('p-campaign', 'kopirovat', 'Копировать'),
            copyPerformance: iget2('p-campaign', 'kopirovat', 'Копировать'),
            copyMcbanner: iget2('p-campaign', 'kopirovat', 'Копировать'),
            copyCpmBanner: iget2('p-campaign', 'kopirovat', 'Копировать'),
            copyContentPromotion: iget2('p-campaign', 'kopirovat', 'Копировать'),
            delete: iget2('p-campaign', 'udalit', 'Удалить'),
            stop: iget2('p-campaign', 'ostanovit', 'Остановить'),
            resume: iget2('p-campaign', 'vozobnovit-pokazy', 'Возобновить показы'),
            archive: iget2('p-campaign', 'arhivirovat', 'Архивировать'),
            unarchive: iget2('p-campaign', 'razarhivirovat', 'Разархивировать'),
            sendBK: iget2('p-campaign', 'otpravit-v-bk', 'Отправить в БК'),
            sendMD: iget2('p-campaign', 'peremoderaciya', 'Перемодерация'),
            sendMDCallouts: iget2('p-campaign', 'peremoderaciya-utochneniy', 'Перемодерация уточнений'),
            sendModerate: iget2('p-campaign', 'otpravit-na-moderaciyu', 'Отправить на модерацию'),
            clientSendModerate: iget2('p-campaign', 'otpravit-na-moderaciyu', 'Отправить на модерацию'),
            moderateAccept: iget2('p-campaign', 'moderaciya-prinyat', 'Модерация: принять'),
            moderateAcceptCallouts: iget2('p-campaign', 'moderaciya-prinyat-utochneniya', 'Модерация: принять уточнения'),
            sendOptimize: iget2('p-campaign', 'optimizirovat', 'Оптимизировать'),
            copyBannersToMediaplan: iget2('p-campaign', 'kopirovat-v-mediaplan', 'Копировать в медиаплан'),
            stopAndRemoderateBanner: iget2('p-campaign', 'ostanovit-i-peremoderirovat', 'Остановить и перемодерировать'),
            setAutotargeting: iget2('p-campaign', 'set-autotargeting', 'Настроить автотаргетинг')
        };
    }),

    mode('minus-words')(function() {
        var group = this.group,
            data = this.data,
            blocksTranslations = apply('blocks-translations');

        if ((!data.campaign.readonly || hasLoginRights('superreader_control', 'limited_support_control')) &&
            (group.archive === 'No' || (group.isEmptyGroup && group.archive !== 'Yes'))) {
            group.actions.push({
                custom: {
                    block: 'b-minus-words-control',
                    switcherType: 'link',
                    isSuperReaderControl: hasLoginRights('superreader_control', 'limited_support_control'),
                    mix: {
                        block: 'b-banner-actions-link',
                        elem: 'switcher'
                    },
                    modelParams: {
                        name: u.campaign.getGroupModelName(data.campaign.mediaType),
                        id: group.adgroup_id
                    },
                    requestParams: {
                        for: 'groups',
                        cid: data.campaign.cid,
                        adgroup_id: group.adgroup_id,
                        ulogin: data.FORM.ulogin,
                        onSuccessSave: 1
                    },
                    for: 'groups',
                    switcherText: blocksTranslations.minus,
                    minusWords: group.minus_words
                }
            });
        }
    }),

    mode('blocks-translations')(function() {
        return {
            editBannersNew: iget2('p-campaign', 'edit-banners', 'Редактировать объявления'),
            editGroupsNew: iget2('p-campaign', 'edit-group', 'Редактировать группу'),
            edit: iget2('p-campaign', 'redaktirovat-gruppu', 'Редактировать группу'),
            copy: iget2('p-campaign', 'kopirovat-gruppu', 'Копировать группу'),
            minus: iget2('p-campaign', 'minus-frazy-na-gruppu', 'Минус-фразы на группу'),
            del: iget2('p-campaign', 'udalit-gruppu', 'Удалить группу')
        };
    }),

    mode('delete-group')(function() {
        var group = this.group,
            data = this.data,
            blocksTranslations = apply('blocks-translations');

        group.actions.push({
            url: u.getUrl('deleteAdGroup', withUidPar({
                cid: data.campaign.cid,
                adgroup_ids: group.adgroup_id
            })),
            caption: blocksTranslations.del,
            type: 'confirm',
            js: {
                message: iget2('p-campaign', 'vy-deystvitelno-hotite-udalit', 'Вы действительно хотите удалить группу?')
            }
        });

        group.multi_options['delete'] = hasLoginRights('MassDeleteBanners');

        if ((!data.campaign.readonly || hasLoginRights('superreader_control', 'limited_support_control')) && data.tags_allowed === 'Yes') {
            group.multi_options.editTags = 1;
        }
    }),

    //группа остановлена
    mode('is-group-stoped')(function() {
        return this.group.statusShow !== 'Yes';
    }),

    //группа успешно прошла модерацию
    mode('is-group-moderated')(function() {
        var group = this.group,
            //DIRECT-39276
            //на просмотре кампании пока нет полноценной поддержки групп на серверной части
            banner = this.group.banners[0];

        return (banner.statusModerate === 'Yes' &&
            group.statusModerate === 'Yes' ||
            banner.statusPostModerate === 'Yes' ||
            banner.statusPostModerate === 'Rejected' ||
            (group.statusPostModerate === 'Yes' || group.statusPostModerate === 'Rejected') &&
            banner.statusPostModerate !== 'No');
    }),

    mode('migration')(function() {
        var data = this.data,
            mediaType = data.campaign.mediaType,
            // Редактирование в новом интерфейсе включено
            newEditAllowed = (
                mediaType === 'text' ||
                mediaType === 'cpm_banner' ||
                mediaType === 'performance' ||
                mediaType === 'content_promotion' ||
                mediaType === 'mobile_content' && data.mobile_content_ads_groups_edit_new === 1 ||
                mediaType === 'dynamic' && data.dynamic_ads_groups_edit_new === 1 ||
                mediaType === 'cpm_yndx_frontpage' && data.cpm_yndx_frontpage_ads_groups_edit_new === 1 ||
                mediaType === 'mcbanner'
            ),
            // Редактирование в старом интерфейсе выключено
            oldEditDenied = newEditAllowed && (
                mediaType === 'text' ||
                mediaType === 'cpm_banner' ||
                mediaType === 'performance' ||
                mediaType === 'content_promotion' ||
                mediaType === 'mobile_content' && data.mobile_content_ads_groups_edit_new === 1 ||
                mediaType === 'dynamic' && data.dynamic_ads_groups_edit_new === 1 ||
                mediaType === 'cpm_yndx_frontpage' && data.cpm_yndx_frontpage_ads_groups_edit_new === 1 ||
                mediaType === 'mcbanner'
            ),
            // Копирование через java ручку
            newCopyAllowed = oldEditDenied && (
                mediaType === 'text' ||
                mediaType === 'cpm_banner' ||
                mediaType === 'performance' ||
                mediaType === 'content_promotion' ||
                mediaType === 'mobile_content' && data.mobile_content_ads_groups_edit_new === 1 ||
                mediaType === 'dynamic' && data.dynamic_ads_groups_edit_new === 1 ||
                mediaType === 'cpm_yndx_frontpage' && data.cpm_yndx_frontpage_ads_groups_edit_new === 1 ||
                mediaType === 'mcbanner'
            );

        return {
            oldEditDenied: oldEditDenied,
            newEditAllowed: newEditAllowed,
            newCopyAllowed: newCopyAllowed
        };
    }),

    mode('actions')(function() {
        var data = this.data,
            campaign = data.campaign,
            group = this.group,
            banner = this.group.banners[0],
            mediaType = campaign.mediaType,
            isNotEmptyGroup = group.isNotEmptyGroup,
            isTextGroup = group.adgroup_type === 'text',
            isDynamicGroup = group.adgroup_type === 'dynamic',
            isPerformanceGroup = group.adgroup_type === 'performance',
            isMobileContentGroup = group.adgroup_type === 'mobile_content',
            isMcbannerGroup = group.adgroup_type === 'mcbanner',
            isCpmBannerGroup = u.campaign.isCpm(group.adgroup_type),
            isContentPromotionCampaignMediaType = mediaType === 'content_promotion',
            optimizingNotReady = apply('optimizing-not-ready'),
            blocksTranslations = apply('blocks-translations'),
            editCmd = u.campaign.getEditCmdByMediaType(mediaType),
            groupHasOnlyCpcVideoAndImageAds = u.imageAd.groupHasOnlyCpcVideoAndImageAds(group.group_banners_types),
            hasRetInterests = u._.get(group, 'retargetings', []).some(function(ret) {
                return ret.conditions_type === 'interests';
            }),
            migration = apply('migration'),
            oldEditDenied = migration.oldEditDenied,
            newEditAllowed = migration.newEditAllowed,
            newCopyAllowed = migration.newCopyAllowed,
            clientFeaturesAll = u.consts('clientFeaturesAll'),
            isCreativeFreeInterface = clientFeaturesAll ? clientFeaturesAll.includes('CREATIVE_FREE_INTERFACE') : false;

        group.multi_options = {};
        group.actions = [];

        //DIRECT-53857 предупреждение про мониторинг сайта
        if (group.statusMetricaStop === 'Yes') {
            group.actions.push({
                custom: {
                    block: 'b-metrica-stop-warning'
                }
            });
        }

        //@heliarian в кампания типа "мобильный контент" нет операция связанных с медиапланами
        if (!campaign.currency_archived &&
            !group.isEmptyGroup &&
            !isMobileContentGroup &&
            !isPerformanceGroup &&
            !isMcbannerGroup &&
            !isCpmBannerGroup &&
            !isContentPromotionCampaignMediaType
        ) {
            // для мультивалютного спец архива отрываем все действия
            if (apply('send-optimize')) {
                group.multi_options.sendOptimize = true;
            }

            if (!isDynamicGroup && hasLoginRights('manager_control', 'super_control', 'media_control') &&
                (!group.multi_options.sendOptimize ||
                    (data.optimize_camp && /Accept|Reject|Converted/.test(data.optimize_camp.status))) &&
                !groupHasOnlyCpcVideoAndImageAds) {

                group.multi_options.copyBannersToMediaplan = true;
            }
        }

        if (!isPerformanceGroup && !group.isEmptyGroup && group.is_completed_group && hasLoginRights('AdmSendBKMD') &&
            (banner.statusModerate !== 'New' || group.statusShow !== 'No')) {

            group.multi_options.stopAndRemoderateBanner = true;
        }

        if (group.enable || group.isEmptyGroup && group.archive !== 'Yes') {

            if (!isPerformanceGroup && !group.isEmptyGroup && group.is_completed_group) {
                hasLoginRights('AutoModerate') && (group.multi_options.moderateAccept = true);
                hasLoginRights('AdmSendBKMD') && banner.statusModerate !== 'New' &&
                    (group.multi_options.stopAndRemoderateBanner = true);
            }

            if (!data.campaign.readonly || hasLoginRights('superreader_control', 'limited_support_control')) {
                if (newEditAllowed) {
                    group.actions.push({
                        url: u.getEditGroupInNewInterfaceUrl(false, withUidPar({
                            cid: data.campaign.cid,
                            adgroupId: group.adgroup_id
                        })),
                        caption: blocksTranslations.editGroupsNew
                    });

                    if (!(isPerformanceGroup && isCreativeFreeInterface)) {
                        group.actions.push({
                            url: u.getEditBannersInNewInterfaceUrl(group.bannersCount === 0, withUidPar({
                                cid: data.campaign.cid,
                                adgroupId: group.adgroup_id,
                                bids: group.current_status_bids || []
                            })),
                            caption: blocksTranslations.editBannersNew
                        });
                    }
                }

                if (!oldEditDenied) {
                    group.actions.push({
                        url: u.getUrl(editCmd, withUidPar({
                            cid: data.campaign.cid,
                            banner_status: data.tab,
                            bid: (group.current_status_bids || []).join(','),
                            adgroup_ids: group.adgroup_id,
                            retpath: u.formatUrl({
                                host: data.SCRIPT,
                                query: u.getUrlParams(),
                                hash: group.adgroup_id + ''
                            })
                        })),
                        caption: blocksTranslations.edit + '&hellip;'
                    });

                    if (isDynamicGroup) {
                        group.multi_options.editDynamic = true;
                    } else if (isMcbannerGroup) {
                        group.multi_options.editMcbanner = true;
                    } else if (isContentPromotionCampaignMediaType) {
                        group.multi_options.editContentPromotion = true;
                    } else {
                        group.multi_options.edit = true;
                    }
                }

                if (newEditAllowed) {
                    group.multi_options.editGroupsNew = true;
                    group.multi_options.editBannersNew = true;
                }

                if (isPerformanceGroup && isCreativeFreeInterface) {
                    group.multi_options.editBannersNew = false;
                }
            }

            if (!group.isEmptyGroup &&
                hasLoginRights('manager_control', 'placer_control', 'super_control', 'agency_control') ||
                (hasLoginRights('is_any_client') && !campaign.readonly)) {

                if (newCopyAllowed) {
                    group.actions.push({
                        custom: {
                            block: 'copy-group-link',
                            js: {
                                mediaType: mediaType,
                                campaignId: campaign.cid,
                                adgroupId: group.adgroup_id,
                                copyAndGoEdit: newEditAllowed
                            },
                            content: {
                                block: 'link',
                                mods: {
                                    pseudo: 'yes'
                                },
                                content: blocksTranslations.copy + '&hellip;'
                            }
                        }
                    });
                } else {
                    group.actions.push({
                        url: u.getUrl(editCmd, withUidPar({
                            cid: data.campaign.cid,
                            banner_status: data.tab,
                            bid: (group.current_status_bids || []).join(','),
                            adgroup_ids: group.adgroup_id,
                            is_groups_copy_action: 1
                        })),
                        caption: blocksTranslations.copy + '&hellip;',
                        type: 'copy-advert',
                        js: {
                            limitReached: data.tabclass_all_count == data.MAX_BANNER_LIMIT,
                            limitReachedMessage: iget2(
                                'p-campaign',
                                'dostignuto-maksimalnoe-kolichestvo-grupp',
                                'Достигнуто максимальное количество групп в кампании - {foo}',
                                {
                                    foo: data.MAX_BANNER_LIMIT
                                }
                            )
                        }
                    });
                }

                if (newCopyAllowed) {
                    group.multi_options.copy = true;
                } else if (isDynamicGroup) {
                    group.multi_options.copyDynamic = true;
                } else if (isPerformanceGroup) {
                    group.multi_options.copyPerformance = true;
                } else if (isMcbannerGroup) {
                    group.multi_options.copyMcbanner = true;
                } else if (isCpmBannerGroup) {
                    // Для cpm_banner кампаний у групп cpm_outdoor, cpm_indoor и cpm_geo_pin нет мультикопирования
                    group.multi_options.copyCpmBanner = [
                        'cpm_outdoor',
                        'cpm_indoor',
                        'cpm_geo_pin'
                    ].indexOf(group.cpm_banners_type) === -1;
                } else if (isContentPromotionCampaignMediaType) {
                    group.multi_options.copyContentPromotion = true;
                } else {
                    group.multi_options.copy = true;
                }
            }

            //тоже самое условие есть в data/block/i-direct-easy/i-direct-easy.tt2 и в Common::delete_groups
            if ((group.BannerID == 0 || group.isEmptyGroup) &&
                !data.campaign.readonly &&
                (!apply('is-group-moderated', {
                    group: group
                }) || data.sum <= 0)
               ) {
                apply('delete-group', {
                    group: group
                });
            } else if (!data.campaign.readonly) {
                if (group.is_completed_group) {
                    if (group.statusShow === 'Yes') {
                        group.actions.push({
                            url: isNotEmptyGroup ?
                                u.getUrl('stopAdGroup', withUidPar({
                                    adgroup_ids: group.adgroup_id,
                                    cid: data.campaign.cid
                                })) :
                            u.getUrl('stopBanner', withUidPar({
                                bid: group.bid,
                                cid: data.campaign.cid
                            })),
                            caption: iget2('p-campaign', 'ostanovit', 'Остановить')
                        });

                        group.multi_options.stop = true;
                    }

                    if (apply('is-group-stoped', { group: group })) {
                        group.actions.push({
                            url: isNotEmptyGroup ?
                                u.getUrl('resumeAdGroup', withUidPar({
                                    adgroup_ids: group.adgroup_id,
                                    cid: data.campaign.cid
                                })) :
                            u.getUrl('resumeBanner', withUidPar({
                                bid: group.bid,
                                cid: data.campaign.cid
                            })),
                            mods: {
                                theme: 'red'
                            },
                            caption: iget2('p-campaign', 'vozobnovit-pokazy', 'Возобновить показы')
                        });

                        group.multi_options.resume = true;
                    }
                }
            }
        }

        if (!group.isEmptyGroup) {
            if ((banner.statusModerate === 'New' || group.statusModerate === 'New') &&
                hasLoginRights('SendModerate') &&
                group.archive === 'No' && group.is_completed_group) {

                group.actions.push({
                    url: u.getUrl('sendModerate', withUidPar({
                        bid: group.bid,
                        adgroup_ids: group.adgroup_id,
                        cid: data.campaign.cid
                    })),
                    caption: iget2('p-campaign', 'otpravit-na-moderaciyu', 'Отправить на модерацию'),
                    type: 'confirm',
                    js: {
                        message: iget2('p-campaign', 'vy-deystvitelno-hotite-otpravit', 'Вы действительно хотите отправить группу на модерацию?')
                    }
                });

                group.multi_options.sendModerate = true;
            }

            if (!hasLoginRights('SendModerate') && data.statusModerate !== 'New' && data.allow_edit_camp &&
                data.FORM.tab == 'draft') {

                group.multi_options.clientSendModerate = 1;
            }

            if (!isPerformanceGroup && !isMcbannerGroup && !isCpmBannerGroup && !isContentPromotionCampaignMediaType) {
                if ((!data.campaign.readonly && (data.show_age_control ||
                        (group.banners[0].hash_flags && group.banners[0].hash_flags.age ||
                            hasLoginRights('super_control', 'support_control', 'placer_control'))))) {

                    group.multi_options.editAgeLabels = 1;
                }

                if ((!data.campaign.readonly && (data.show_age_control ||
                        (group.banners[0].hash_flags && group.banners[0].hash_flags.baby_food ||
                            hasLoginRights('super_control', 'support_control', 'placer_control'))))) {

                    group.multi_options.editChildAgeLabels = 1;
                }
            }

            if ((!data.campaign.readonly || hasLoginRights('superreader_control', 'limited_support_control')) && data.tags_allowed === 'Yes') {
                group.multi_options.editTags = 1;
            }
        }

        // https://st.yandex-team.ru/DIRECT-112518#5e42a5842c628f6bbe5ac957
        if ((!isPerformanceGroup && !hasRetInterests) || isTextGroup) {
            apply('minus-words', {
                group: group,
                blocksTranslations: blocksTranslations
            });
        }

        if (!group.isEmptyGroup &&
            banner.statusModerate !== 'New' &&
            group.statusModerate != 'New' &&
            group.archive === 'No' && group.is_completed_group) {

            if (hasLoginRights('AdmSendBKMD', 'is_developer', 'superreader_control')) {
                group.actions.push({
                    url: u.getUrl('admSendBK', withUidPar({
                        bid: group.bid,
                        cid: data.campaign.cid,
                        adgroup_ids: group.adgroup_id
                    })),
                    caption: iget2('p-campaign', 'otpravit-v-bk', 'Отправить в БК'),
                    type: 'confirm',
                    js: {
                        message: iget2('p-campaign', 'vy-deystvitelno-hotite-otpravit-107', 'Вы действительно хотите отправить группу в БК?')
                    }
                });

                group.multi_options.sendBK = true;
            }

            // для смарт-баннеров нет перемодерации
            if (hasLoginRights('AdmSendBKMD', 'is_developer', 'superreader_control', 'manager_control', 'limited_support_control') && !isPerformanceGroup) {
                group.actions.push({
                    url: u.getUrl('admSendMD', withUidPar({
                        bid: group.bid,
                        cid: data.campaign.cid,
                        adgroup_ids: group.adgroup_id
                    })),
                    caption: iget2('p-campaign', 'peremoderaciya', 'Перемодерация'),
                    type: 'confirm',
                    js: {
                        message: iget2('p-campaign', 'vy-deystvitelno-hotite-otpravit-108', 'Вы действительно хотите отправить группу заново на модерацию?')
                    }
                });

                group.multi_options.sendMD = true;
            }
        }

        // Отправить уточнения на перемодерацию
        if (group.group_has_callouts &&
            hasLoginRights('super_control', 'support_control', 'placer_control', 'is_developer', 'superreader_control', 'limited_support_control')) {

            group.actions.push({
                url: u.getUrl('remoderateBannersAdditions', withUidPar({
                    cid: data.campaign.cid,
                    adgroup_ids: group.adgroup_id
                })),
                caption: iget2('p-campaign', 'peremoderaciya-utochneniy', 'Перемодерация уточнений'),
                type: 'confirm',
                js: {
                    message: iget2('p-campaign', 'vy-deystvitelno-hotite-otpravit-109', 'Вы действительно хотите отправить уточнения заново на модерацию?')
                }
            });

            group.multi_options.sendMDCallouts = true;
        }

        if (group.group_has_callouts && hasLoginRights('AutoModerate', 'is_developer')) {
            group.actions.push({
                url: u.getUrl('moderateAcceptBannersAdditions', withUidPar({
                    cid: data.campaign.cid,
                    adgroup_ids: group.adgroup_id
                })),
                caption: iget2('p-campaign', 'moderaciya-prinyat-utochneniya', 'Модерация: принять уточнения'),
                type: 'confirm',
                js: {
                    message: iget2(
                        'p-campaign',
                        'vy-deystvitelno-hotite-prinyat',
                        'Вы действительно хотите ПРИНЯТЬ все уточнения, привязанные к группе БЕЗ модерации?'
                    )
                }
            });

            group.multi_options.moderateAcceptCallouts = true;
        }

        if (group.statusShow === 'No' && (group.BannerID !== 0 || banner.statusModerate !== 'New') &&
                !data.campaign.readonly) {

            if (group.archive === 'No') {
                // добавить архивацию, если не группа или если в группе можно заархивировать все баннеры
                if (!isNotEmptyGroup || group.banners_canarch_quantity === group.banners_quantity) {
                    group.actions.push({
                        caption: isNotEmptyGroup ? iget2('p-campaign', 'arhivirovat-gruppu', 'Архивировать группу') : iget2('p-campaign', 'arhivirovat', 'Архивировать'),
                        url: u.getUrl('archiveBanner', withUidPar({
                            cid: data.campaign.cid,
                            adgroup_ids: group.adgroup_id
                        }))
                    });
                }

                group.multi_options.archive = true;
            } else {
                group.actions.push({
                    caption: isNotEmptyGroup ?
                        // если все баннеры группы заархивированы
                        group.banners_quantity == group.banners_arch_quantity ?
                            iget2('p-campaign', 'razarhivirovat-gruppu', 'Разархивировать группу') :
                            iget2('p-campaign', 'razarhivirovat-vse', 'Разархивировать все') : iget2('p-campaign', 'razarhivirovat', 'Разархивировать'),
                    url: u.getUrl('unarchiveBanner', withUidPar({
                        cid: data.campaign.cid,
                        adgroup_ids: group.adgroup_id,
                        tab: data.FORM.tab
                    })),
                    type: 'unarchive'

                });

                group.multi_options.unarchive = true;
            }
        }

        if (!group.isEmptyGroup && data.optimize_camp && apply('can-user-optimize-campaign') && optimizingNotReady) {
            group.multi_options.sendOptimize = 1;
        }

        if (
                u._.contains(['text', 'mobile_content'], mediaType) &&
                group.archive === 'No' &&
                (!campaign.readonly || hasLoginRights('superreader_control', 'limited_support_control'))
        ) {
            group.multi_options.setAutotargeting = true;
        }
    }),

    mode('can-user-optimize-campaign')(function() {
        var data = this.data;

        return data.optimize_camp &&
            data.optimize_camp.request_id &&
            hasLoginRights('super_control', 'manager_control', 'placer_control', 'media_control');
    }),

    mode('optimizing-not-ready')(function() {
        var data = this.data;

        return data.optimize_camp &&
            data.optimize_camp.request_id &&
            /^(New|InProcess|AutoRequest)$/.test(data.optimize_camp.status);
    }),

    mode('send-optimize')(function() {
        var data = this.data;

        return (data.optimize_camp &&
            (hasLoginRights('super_control', 'manager_control') ||
                (hasLoginRights('media_control') &&
                    (!data.optimize_camp.MediaUID || data.optimize_camp.MediaUID === data.optimize_camp.CurrentUID))) &&
            apply('optimizing-not-ready'));
    }),

    content()(function() {
        var data = this.data,
            form = data.FORM,
            campaignIsArchived = data.archived === 'Yes',
            options = {},
            migration = apply('migration'),
            actionCaptions = apply('action-captions'),
            actionCaptionsKeys = Object.keys(actionCaptions),
            campaign = data.campaign,
            actionsSort = function(a, b) {
                // ставим Оптимизацию для медиапланеров в начало.
                if (data.login_rights.role == 'media') {
                    if (a == 'sendOptimize') return -1;
                    if (b == 'sendOptimize') return 1;
                }

                return actionCaptionsKeys.indexOf(a) - actionCaptionsKeys.indexOf(b);
            },
            massActionFormParams = withUidPar({
                retpath: u.getCurrentUrl(u.getUrlParams()),
                banner_status: data.tab,
                cid: campaign.cid
            }),
            filteredTag = campaign.tags.filter(function(tag) {
                return tag.id == data.FORM.tag;
            }).pop(),
            maxBannersOnTab = Math.max(+data.tabclass_all_count || 0, +data.tabclass_media_count || 0),
            BANNERS_PER_PAGE_THRESHOLD = 10,
            isMobileAppCamp = campaign.mediaType === 'mobile_content',
            showBannersPerPage = +(data.all_banners_num && (maxBannersOnTab > BANNERS_PER_PAGE_THRESHOLD ||
                maxBannersOnTab > data.banners_on_page)),
            showNewDailyBudgetRecommendations =
                data.features_enabled_for_client.show_daily_budget_recommendations_in_old_interface == 1,
            showContentPromotionWarning = campaign.mediaType === 'content_promotion' &&
                !!campaign.groups.filter(function(gr) {
                    return gr.content_promotion_content_type === 'service';
                }).length;

        if (data.optimize_camp) {
            massActionFormParams.optimize_request_id = data.optimize_camp.request_id;
        }

        if (data.tab === 'all' || data.FORM && data.FORM.tag) {
            data.allCbxLabel = iget2('p-campaign', 'vse-gruppy-na-stranice', 'Все группы на странице');
        } else if (data.tab === 'wait') {
            data.allCbxLabel = iget2('p-campaign', 'vse-ozhidayushchie-moderacii-na', 'Все ожидающие модерации на странице');
        } else if (data.tab === 'decline') {
            data.allCbxLabel = iget2('p-campaign', 'vse-otklonyonnye-na-stranice', 'Все отклонённые на странице');
        } else if (data.tab === 'off') {
            data.allCbxLabel = iget2('p-campaign', 'vse-ostanovlennye-na-stranice', 'Все остановленные на странице');
        } else if (data.tab === 'arch') {
            data.allCbxLabel = iget2('p-campaign', 'vse-gruppy-v-arhive', 'Все группы в архиве на странице');
        } else if (data.tab === 'draft') {
            data.allCbxLabel = iget2('p-campaign', 'vse-chernoviki-na-stranice', 'Все черновики на странице');
        } else {
            data.allCbxLabel = iget2('p-campaign', 'vse-aktivnye-na-stranice', 'Все активные на странице');
        }

        data.campaign.groups.forEach(function(group) {
            group.multi_options = {};
            var isGroupEditable = group.cpm_banners_type === 'cpm_audio' ? !!(data.features_enabled_for_operator || {}).cpm_audio : true;

            if (!campaignIsArchived && isGroupEditable) {
                apply('actions', {
                    group: group
                });

                if (!data.campaign.currency_archived) { //для спец архива ничего никому делать нельзя
                    //Собираем информацию о том, что позволительно пользователю
                    Object.keys(group.multi_options).forEach(function(key) {
                        options[key] = true;
                    });
                }

            }
        }, this);

        var sortedOptions = Object.keys(options).sort(actionsSort),
            campaignModelParams = {
                id: data.campaign.cid,
                name: u.campaign.getCampaignModelName(data.campaign.mediaType),
                translocalTreeType: data.translocal_tree_type
            };

        this.massActions = {
            keys: sortedOptions,
            values: sortedOptions.reduce(function(res, key) {
                res[key] = actionCaptions[key];
                return res;
            }, {}),
            banners: data.campaign.groups.reduce(function(res, group) {
                res[group.adgroup_id] = {
                    options: group.multi_options,
                    bid: group.current_status_bids
                };
                return res;
            }, {})
        };

        return [
            u.hasClientFeature('direct_birthday_rebranding') && {
                block: 'b-header-title-portal-dna',
                title: iget2(
                    'p-campaign',
                    'campaign-page-header-title',
                    'Обзор кампании'
                )
            },
            !!data.camp_has_disabled_geo && u._.contains(
                ['text', 'mobile_content', 'mcbanner', 'cpm_banner', 'cpm_deals', 'cpm_yndx_frontpage', 'cpm_price'],
                data.campaign.mediaType
            ) && {
                elem: 'license-warning',
                cid: data.campaign.cid,
                ulogin: data.user_login
            },
            showContentPromotionWarning && { elem: 'content-promotion-warning' },
            {
                block: 'l-page',
                mix: {
                    block: 'p-campaign',
                    elem: 'layout-table'
                },

                mods: {
                    layout: '72-20'
                },

                content: [
                    data.campaign.mediaType === 'performance' && {
                        block: 'b-retargetings-data'
                    },
                    this.isNewHeader ?
                        [
                            {
                                elem: 'row',
                                center: true,
                                ctxCells: {
                                    center: {
                                        content: [
                                            { block: 'b-dna-header' }
                                        ],
                                        attrs: {
                                            colspan: 3
                                        }
                                    }
                                }
                            },
                            {
                                elem: 'row',
                                center: true,
                                ctxCells: {
                                    center: {
                                        content: [
                                            {
                                                block: 'b-day-budget-recommendation-notification',
                                                mix: { block: 'p-campaign', elem: 'day-budget-recommendation-notification' },
                                                ulogin: data.user_login,
                                                cid: data.campaign.cid,
                                                place: 'camp'
                                            }
                                        ],
                                        attrs: {
                                            colspan: 3
                                        }
                                    }
                                }
                            }
                        ] :
                        {
                            elem: 'row',
                            left: true,
                            ctxCells: {
                                left: {
                                    content: [
                                        {
                                            block: 'p-campaign',
                                            elem: 'info',
                                            migration: migration
                                        },
                                        showNewDailyBudgetRecommendations && {
                                            block: 'b-day-budget-recommendation-notification',
                                            mix: { block: 'p-campaign', elem: 'day-budget-recommendation-notification' },
                                            ulogin: data.user_login,
                                            cid: data.campaign.cid,
                                            place: 'camp'
                                        }
                                    ],
                                    attrs: {
                                        colspan: 2
                                    }
                                }
                            },
                            center: {
                                block: 'b-campaign-menu',
                                modelParams: campaignModelParams,
                                options: {
                                    campOptionsViewOnly: data.login_rights.media_control ||
                                        !(data.allow_edit_camp || data.login_rights.limited_support_control),
                                    bannerActions: !filteredTag || filteredTag.uses_count != 0,
                                    campIsArch: data.archived == 'Yes',
                                    specialActions: true,
                                    navMods: {
                                        border: data.cmd != 'showExportedXlsList' ? 'yes' : '',
                                        type: isMobileAppCamp ? 'mobile-content-camp' : 'camp'
                                    },
                                    specialMods: {
                                        type: isMobileAppCamp ? 'mobile-content-camp' : ''
                                    },
                                    bannerMods: {
                                        type: isMobileAppCamp ? 'mobile-content-camp' : ''
                                    },
                                    readonly: data.campaign.readonly,
                                    campMediaType: data.campaign.mediaType
                                },
                                mix: {
                                    block: 'p-campaign',
                                    elem: 'campaign-menu'
                                }
                            }
                        },
                    data.error && {
                        elem: 'row',
                        left: true,
                        center: true,
                        ctxCells: {
                            center: {
                                content: {
                                    block: 'p-campaign',
                                    elem: 'error',
                                    content: u.escapeHTML(data.error)
                                },
                                attrs: {
                                    colspan: 2
                                }
                            }
                        }
                    },
                    {

                        elem: 'row',
                        left: true,
                        mix: [{
                            block: 'p-campaign',
                            elem: 'groups-list'
                        }],
                        ctxCells: {
                            left: {
                                content: {
                                    block: 'p-campaign',
                                    elem: 'under-row',
                                    content: [
                                        {
                                            block: 'b-minus-words-control',
                                            for: 'groups',
                                            elem: 'popup',
                                            isSuperReaderControl: hasLoginRights('superreader_control', 'limited_support_control')
                                        },
                                        {
                                            block: 'b-minus-words-control',
                                            for: 'campaign',
                                            limit: data.CONSTS.CAMPAIGN_MINUS_WORDS_LIMIT,
                                            elem: 'popup',
                                            isSuperReaderControl: hasLoginRights('superreader_control', 'limited_support_control')
                                        },
                                        {
                                            block: 'b-checkboxes-group',
                                            mix: [{
                                                block: 'p-campaign',
                                                elem: 'checkboxes'
                                            }],
                                            js: true,
                                            content: {
                                                block: 'b-layout-table',
                                                mods: {
                                                    layout: '22-78'
                                                },
                                                mix: [{
                                                    block: 'b-groups-list',
                                                    elem: 'table'
                                                }],
                                                content: [
                                                    {
                                                        elem: 'thead',
                                                        content: {
                                                            elem: 'row',
                                                            content: [
                                                                {
                                                                    elem: 'cell',
                                                                    elemMods: { width: '22' },
                                                                    content: ''
                                                                },
                                                                !!this.data.FORM.wp && {
                                                                    elem: 'cell',
                                                                    content: {
                                                                        block: 'p-campaign',
                                                                        elem: 'warnplace',
                                                                        content: [
                                                                            iget2(
                                                                                'p-campaign',
                                                                                'only-groups-with-changed-traffic-volume-show-warning',
                                                                                'Показываются только фразы и группы, по которым были предупреждения о смене объёма трафика!'
                                                                            ),
                                                                            '<br/>',
                                                                            {
                                                                                block: 'link',
                                                                                url: u.getUrl('showCamp', {
                                                                                    cid: this.data.FORM.cid,
                                                                                    ulogin: this.data.FORM.ulogin,
                                                                                    msort: this.data.FORM.msort,
                                                                                    mreverse: this.data.FORM.mreverse,
                                                                                    ws_place: this.data.FORM.ws_place,
                                                                                    ws_cid: this.data.FORM.ws_cid,
                                                                                    ws_time: this.data.FORM.ws_time,
                                                                                    ws_done: this.data.FORM.ws_done,
                                                                                    ws_client: this.data.FORM.ws_client
                                                                                }),
                                                                                content: iget2('p-campaign', 'pokazat-kampaniyu-polnostyu', 'показать кампанию полностью...')
                                                                            },
                                                                            {
                                                                                block: 'b-metrika2',
                                                                                js: {
                                                                                    immediate: {
                                                                                        showCamp: {
                                                                                            'phrases-monitoring': 'show'
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        ]
                                                                    }
                                                                }
                                                            ]
                                                        }
                                                    },
                                                    !!(+data.tabclass_all_count) && {
                                                        elem: 'tbody',
                                                        content: {
                                                            elem: 'row',
                                                            content: [
                                                                {
                                                                    elem: 'cell',
                                                                    elemMods: { width: '22' },
                                                                    content: {
                                                                        block: 'b-campaign-tabs',
                                                                        mods: {
                                                                            empty: 'yes'
                                                                        }
                                                                    }
                                                                },
                                                                {
                                                                    elem: 'cell',
                                                                    content: {
                                                                        block: 'b-campaign-tabs',
                                                                        mods: {
                                                                            empty: 'no',
                                                                            solitary: 'first'
                                                                        },
                                                                        modelParams: campaignModelParams
                                                                    }
                                                                }
                                                            ]
                                                        }
                                                    },
                                                    {
                                                        elem: 'tbody',
                                                        content: [
                                                            {
                                                                elem: 'row',
                                                                content: [
                                                                    {
                                                                        elem: 'cell',
                                                                        content: (Object.keys(options).length > 0) && {
                                                                            block: 'b-groups-list',
                                                                            elem: 'checkbox-wrap',
                                                                            content: {
                                                                                block: 'checkbox',
                                                                                mix: [
                                                                                    {
                                                                                        block: 'b-checkboxes-group',
                                                                                        elem: 'item'
                                                                                    },
                                                                                    {
                                                                                        block: 'b-groups-list',
                                                                                        elem: 'select-all'
                                                                                    }
                                                                                ],
                                                                                checkboxAttrs: {
                                                                                    autocomplete: 'off'
                                                                                },
                                                                                text: this.data.allCbxLabel
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        elem: 'cell',
                                                                        content: [
                                                                            data.tags_allowed == 'Yes' && [
                                                                                data.FORM.tag == -1 ?
                                                                                    {
                                                                                        block: 'p-campaign',
                                                                                        elem: 'filtered-tag',
                                                                                        elemMods: { tags: 'no' },
                                                                                        content: [
                                                                                            /* eslint-disable max-len */
                                                                                            data.campaign.mediaType == 'mcbanner' || data.campaign.mediaType == 'performance' ?
                                                                                                iget2('p-campaign', 'bannery-bez-metok', 'Баннеры без меток') :
                                                                                                iget2('p-campaign', 'obyavleniya-bez-metok', 'Объявления без меток'),
                                                                                            {
                                                                                                elem: 'filtered-tag-count',
                                                                                                content: [
                                                                                                    '&nbsp;',
                                                                                                    data.campaign.untagged_banners_num
                                                                                                ]
                                                                                            }
                                                                                        ]
                                                                                    } :
                                                                                    !!filteredTag && {
                                                                                        block: 'p-campaign',
                                                                                        elem: 'filtered-tag',
                                                                                        content: {
                                                                                            block: 'b-group-tag-button',
                                                                                            mods: {
                                                                                                size: 'big'
                                                                                            },
                                                                                            content: [
                                                                                                filteredTag.value,
                                                                                                {
                                                                                                    elem: 'count',
                                                                                                    content: [
                                                                                                        '&nbsp;',
                                                                                                        filteredTag.uses_count
                                                                                                    ]
                                                                                                }
                                                                                            ]
                                                                                        }
                                                                                    },
                                                                                {
                                                                                    block: 'b-metrika2',
                                                                                    js: {
                                                                                        immediate: {
                                                                                            showCamp: {
                                                                                                'filter-by-tag': 'show'
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            ],

                                                                            /* eslint-disable max-len */
                                                                            (campaign.strategy.name === 'different_places' &&
                                                                                // Для smart кампаний при выбранной стратегии ROI имя стратегии name === 'different_places', что неправильно.
                                                                                // Из-за этого отображается не нужный переключатель.
                                                                                // Исключаем данный переключатель для всех смарт кампаний.
                                                                                campaign.mediaType !== 'performance' &&
                                                                                !u.campaign.isCpm(campaign.mediaType) ||
                                                                                u.consts('isSearchRetargetingEnabled') && campaign.strategy.name != 'different_places' && !+campaign.strategy.is_net_stop && !+campaign.strategy.is_search_stop) && {
                                                                                    block: 'b-campaign-platform-switcher',
                                                                                    modelParams: campaignModelParams
                                                                                },
                                                                            /* eslint-enable max-len */

                                                                            this.data.FORM.tab === 'wait' && {
                                                                                block: 'p-campaign',
                                                                                elem: 'moderation-link',
                                                                                content: [
                                                                                    {
                                                                                        block: 'b-help-link',
                                                                                        mods: {
                                                                                            type: 'modal',
                                                                                            icon: 'left',
                                                                                            margin: 'no',
                                                                                            align: 'baseline',
                                                                                            decoration: 'no'
                                                                                        },
                                                                                        url: u.getHelpUrl(
                                                                                            'moderation-timetable'),
                                                                                        text: iget2(
                                                                                            'p-campaign',
                                                                                            'grafik-raboty-moderacii',
                                                                                            'График работы модерации'
                                                                                        ),
                                                                                        icon: 'alert'
                                                                                    },
                                                                                    this.data.campaign.hasOutDoorGroup ?
                                                                                        {
                                                                                            block: 'b-help-link',
                                                                                            mods: {
                                                                                                type: 'modal',
                                                                                                icon: 'left',
                                                                                                margin: 'no',
                                                                                                align: 'baseline',
                                                                                                decoration: 'no'
                                                                                            },
                                                                                            mix: {
                                                                                                block: this.block,
                                                                                                elem: 'moderation-outdoor'
                                                                                            },
                                                                                            url: u.getHelpUrl(
                                                                                                'modadvert-timetable'),
                                                                                            text: iget2(
                                                                                                'p-campaign',
                                                                                                'moderation-outdoor',
                                                                                                'График работы модерации наружной рекламы'
                                                                                            ),
                                                                                            icon: 'alert'
                                                                                        } :
                                                                                        ''
                                                                                ]
                                                                            },
                                                                            /* eslint-disable max-len */
                                                                            !this.data.view_only ?
                                                                                !u.campaign.isCpm(this.data.campaign.mediaType) &&
                                                                                (/^(autobudget_avg_cpc|autobudget_avg_cpa)_per_(camp|filter)$/.test(this.data.campaign.strategy.name) || !this.data.campaign.strategy.is_autobudget) &&
                                                                                this.data.campaign.has_editable_banners && !campaignIsArchived &&
                                                                                (this.data.allow_edit_camp || hasLoginRights('limited_support_control')) && !hasLoginRights('media_control') && {
                                                                                    block: 'b-online-set-phrases-prices',
                                                                                    mods: {
                                                                                        type: this.data.campaign.mediaType == 'dynamic' ? 'dynamic-groups' : u.beminize(this.data.campaign.mediaType),
                                                                                        performance: this.data.campaign.mediaType === 'performance' ?
                                                                                            ({
                                                                                                autobudget_avg_cpc_per_camp: 'avg-cpc',
                                                                                                autobudget_avg_cpc_per_filter: 'avg-cpc',
                                                                                                autobudget_avg_cpa_per_camp: 'avg-cpa',
                                                                                                autobudget_avg_cpa_per_filter: 'avg-cpa'
                                                                                            })[this.data.campaign.strategy.name] || 'default' : ''
                                                                                    },
                                                                                    js: {
                                                                                        cid: this.data.campaign.cid
                                                                                    },
                                                                                    modelParams: campaignModelParams
                                                                                } :
                                                                                {
                                                                                    block: 'icon-text',
                                                                                    mods: {
                                                                                        theme: 'alert',
                                                                                        size: 'ms'
                                                                                    },
                                                                                    mix: [{
                                                                                        block: 'p-campaign',
                                                                                        elem: 'view-only'
                                                                                    }],
                                                                                    text: [
                                                                                        iget2(
                                                                                            'p-campaign',
                                                                                            'funkcionalnost-stranicy-ogranichena-iz',
                                                                                            'Функциональность страницы ограничена из-за большого объёма данных.'
                                                                                        ),
                                                                                        '<br/>',
                                                                                        iget2(
                                                                                            'p-campaign',
                                                                                            'dlya-standartnogo-otobrazheniya-umenshite',
                                                                                            'Для стандартного отображения – уменьшите количество групп на странице.'
                                                                                        )
                                                                                    ]
                                                                                },
                                                                            /* eslint-enable max-len */
                                                                            {
                                                                                block: 'p-campaign',
                                                                                elem: 'hierarchical-multipliers-warning',
                                                                                hierarchical_multipliers: this.data.hierarchical_multipliers,
                                                                                campaign: this.data.campaign
                                                                            }
                                                                        ]
                                                                    }

                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        block: 'b-groups-list',
                                                        isPreviewHasControls: this.data.allow_edit_camp &&
                                                        !hasLoginRights('media_control', 'superreader_control') &&
                                                        this.data.archived != 'Yes',
                                                        groupModelName: u.campaign.getGroupModelName(
                                                            this.data.campaign.mediaType
                                                        ),
                                                        groups: this.data.campaign.groups
                                                    },
                                                    {
                                                        elem: 'tbody',
                                                        content: {
                                                            elem: 'row',
                                                            content: [
                                                                this.data.bs_rankstat_time && {
                                                                    elem: 'cell',
                                                                    content: {
                                                                        block: 'p-campaign',
                                                                        elem: 'last-update',
                                                                        content: [
                                                                            iget2('p-campaign', 'obnovleno', 'Обновлено'),
                                                                            ': ',
                                                                            this.data.format_date ? //@see i-utils__format-date check-functions:ignore
                                                                                this.data.format_date( // check-functions:ignore
                                                                                    this.data.bs_rankstat_time,
                                                                                    'strftime',
                                                                                    '%d.%m %H:%M'
                                                                                ) :
                                                                                u.moment(
                                                                                    this.data.bs_rankstat_time,
                                                                                    'YYYYMMDDHHmmss'
                                                                                ).format('DD.MM HH:mm')
                                                                        ]
                                                                    }
                                                                },
                                                                !!showBannersPerPage && {
                                                                    elem: 'cell',
                                                                    content: {
                                                                        block: 'b-banners-per-page'
                                                                    }
                                                                }
                                                            ]
                                                        }
                                                    }

                                                ]
                                            }
                                        }
                                    ]
                                },
                                attrs: {
                                    colspan: 4
                                }
                            }
                        }
                    },
                    {
                        elem: 'row',
                        left: true,
                        ctxCells: {
                            left: {
                                // Показываем флоатер в архиве только для случая когда есть непустой пейджер DIRECT-36114
                                content: (campaignIsArchived ? data.pages_num > 1 : true) && {
                                    block: 'b-floater',
                                    mods: {
                                        resizable: 'yes',
                                        'never-fixed': this.data.uatraits.isMobile ? 'yes' : '',
                                        to: 'bottom',
                                        theme: 'grey-always'
                                    },
                                    mix: [{
                                        block: 'p-campaign',
                                        elem: 'floater'
                                    }],
                                    content: [
                                        {
                                            block: 'b-campaign-edit-panel',
                                            js: {
                                                modelParams: campaignModelParams
                                            },
                                            content: [
                                                Object.keys(options).length > 0 && {
                                                    block: 'b-mass-actions',
                                                    modelParams: campaignModelParams,
                                                    mix: [{
                                                        block: 'p-campaign',
                                                        elem: 'mass-actions'
                                                    }],
                                                    mods: {
                                                        type: 'camp',
                                                        disabled: 'yes'
                                                    },
                                                    massActions: this.massActions,
                                                    defOption: iget2('p-campaign', 'vyberite', 'Выберите '),
                                                    form: {
                                                        name: 'mform',
                                                        method: 'POST',
                                                        action: this.data.script,
                                                        params: massActionFormParams,
                                                        cid: massActionFormParams.cid
                                                    },
                                                    newCopyAllowed: migration.newCopyAllowed
                                                },
                                                {
                                                    block: 'b-campaign-edit-panel',
                                                    elem: 'save',
                                                    elemMods: {
                                                        active: !data.campaign.readonly &&
                                                        data.campaign.has_editable_banners ?
                                                            'yes' :
                                                            'no'
                                                    }
                                                },
                                                {
                                                    block: 'b-campaign-info-panel',
                                                    js: {
                                                        modelParams: campaignModelParams
                                                    },
                                                    mods: {
                                                        type: 'errors',
                                                        hidden: 'yes'
                                                    },
                                                    mix: [
                                                        {
                                                            block: 'p-campaign',
                                                            elem: 'info-panel'
                                                        },
                                                        {
                                                            block: 'p-campaign',
                                                            elem: 'errors-panel'
                                                        }
                                                    ]
                                                },
                                                {
                                                    block: 'b-campaign-info-panel',
                                                    js: {
                                                        modelParams: campaignModelParams
                                                    },
                                                    mods: {
                                                        type: 'corrections',
                                                        hidden: 'yes'
                                                    },
                                                    mix: [
                                                        {
                                                            block: 'p-campaign',
                                                            elem: 'info-panel'
                                                        },
                                                        {
                                                            block: 'p-campaign',
                                                            elem: 'corrections-panel'
                                                        }
                                                    ]
                                                },
                                                {
                                                    block: 'p-campaign',
                                                    elem: 'pager',
                                                    content: {
                                                        block: 'b-pager',
                                                        mods: {
                                                            theme: 'embossed'
                                                        },
                                                        currentPage: +data.page,
                                                        pageParam: 'page',
                                                        startFrom: 1,
                                                        totalPages: +data.pages_num,
                                                        perpageCount: +data.banners_per_page,
                                                        pageUrl: u.formatUrl({
                                                            host: data.script,
                                                            query: u.getUrlParams(['page'])
                                                        }),
                                                        content: [
                                                            {
                                                                elem: 'pages'
                                                            }
                                                        ]
                                                    }
                                                }
                                            ]
                                        },
                                        data.need_moderation_doc && {
                                            block: 'b-moderation-doc-informer',
                                            mix: {
                                                block: 'p-campaign',
                                                elem: 'moderation-doc-informer'
                                            },
                                            moderationDocs: data.need_moderation_doc,
                                            mediaType: data.campaign.mediaType
                                        }
                                    ]
                                },
                                attrs: {
                                    colspan: '3'
                                }
                            }
                        }
                    },
                    {
                        block: 'i-model-aggregator',
                        content: [
                            {
                                block: 'i-model',
                                modelParams: u._.extend({}, campaignModelParams, {
                                    data: u._.extend({}, data.campaign, {
                                        start_date: data.start_date || '',
                                        finish_date: data.finish_date || '',
                                        minus_words: data.minus_words,
                                        name: data.name,
                                        is_autobudget: data.campaign.strategy.is_autobudget,
                                        strategy_name: data.campaign.strategy.name,
                                        search_strategy: data.campaign.strategy.search.name,
                                        net_strategy: data.campaign.strategy.net.name,
                                        day_budget: data.campaign.day_budget.sum,
                                        day_budget2: data.campaign.day_budget,
                                        campaignIsArchived: campaignIsArchived,
                                        currentTab: data.tab,
                                        countArchTab: data.tabclass_arch_count,
                                        countOffTab: data.tabclass_off_count,
                                        metrika: {
                                            campaign_goals: Object.keys(data.campaign.campaign_goals || {})
                                                .map(function(id) {
                                                    return data.campaign.campaign_goals[id];
                                                }),
                                            compaign_domains_count: data.compaign_domains_count,
                                            cpa_deviation: !!+(data.campaign.autobudget_cpa_warning &&
                                                data.campaign.autobudget_cpa_warning.cpa_deviation) || false,
                                            apc_deviation: !!+(data.campaign.autobudget_cpa_warning &&
                                                data.campaign.autobudget_cpa_warning.apc_deviation) || false,
                                            ecommerce: data.metrika_has_ecommerce
                                        },
                                        // Показывается ли компания
                                        isCampShows: !data.action.resumeCamp,
                                        strategy2: u['b-campaign-strategy2'].buildStrategy(data.campaign),
                                        tags: data.campaign.tags.map(function(tag) {
                                            return {
                                                id: tag.id,
                                                value: tag.value,
                                                uses_count: tag.uses_count
                                            };
                                        }),
                                        geo: data.geo,
                                        // Данные для построения прогноза стратегии
                                        rf: data.rf,
                                        rfReset: data.rfReset,
                                        multipliersPct: u['i-adjustment-rates-data'].getMultipliersPct(data.hierarchical_multipliers)
                                    })
                                })
                            }
                        ]
                    },
                    {
                        block: 'p-campaign',
                        elem: 'models-data'
                    },
                    {
                        block: 'popup',
                        mix: [{
                            block: 'p-campaign',
                            elem: 'popup'
                        }],
                        mods: {
                            type: 'modal',
                            position: 'fixed',
                            autoclosable: 'no',
                            'body-scroll': 'no',
                            'has-close': 'yes'
                        },
                        underMods: {
                            type: 'paranja'
                        },
                        content: [
                            {
                                elem: 'close'
                            },
                            {
                                elem: 'content',
                                mix: [{
                                    block: 'p-campaign',
                                    elem: 'popup-content'
                                }],
                                content: ''
                            }
                        ]
                    },
                    form['show_moderation_message'] === '1' && {
                        block: 'b-moderation-message-dna',
                        campaignId: campaign.cid
                    }
                ]
            }
        ];

    })
);
