(function() {

    BEM.DOM.decl({ block: 'p-campaign', baseBlock: 'i-glue' }, {
        onSetMod: {
            js: function() {
                this.__base.apply(this, arguments);

                if (this.model.get('mediaType') === 'cpm_yndx_frontpage') {
                    var strategy = this.model.get('strategy2').toJSON(),
                        price = u._.get(strategy, ['options', 'net', 'avg_cpm']);

                    BEM.blocks['cpm-yndx-frontpage-min-price'].initGroupsMinPrice(
                        this.model.get('cid'),
                        this.params.cpmYndxFrontpageGroups,
                        strategy.is_autobudget,
                        price
                    );
                }

                u.graspSelf.call(this, {
                    checkboxesGroup: 'b-checkboxes-group on checkboxes',
                    popup: 'popup on popup',
                    _campaignStrategy: '? b-campaign-strategy2 inside',
                    _bannersToMedia: '? b-banners-to-media inside'
                });

                this._campaignStrategy && this._campaignStrategy.on('ready-to-save', function() {
                    BEM.blocks['b-campaign-edit-panel'].canReload(
                        function() {
                            this._campaignStrategy
                                .saveToServer()
                                .then(function() {
                                    location.href = location.href.split('#')[0];
                                })
                                .fail(function(error) {
                                    BEM.blocks['b-confirm'].alert(error);
                                });
                        }.bind(this),
                        function() {
                            this._campaignStrategy.cancelSaving();
                        }.bind(this));
                }, this);

                if (this._campaignStrategy) {
                    this._campaignStrategy.on('switcher-click', function() {
                        BEM.blocks['b-metrika2'].params({
                            params: {
                                showCamp: {
                                    strategy: 'open'
                                }
                            }
                        });
                    });
                    this._campaignStrategy.on('ready-to-save', function() {
                        BEM.blocks['b-metrika2'].params({
                            params: {
                                showCamp: {
                                    strategy: 'save'
                                }
                            }
                        });
                    });
                }

                this.massActions = this.findBlockOn('mass-actions', 'b-mass-actions');

                this._bannersToMedia && this._bannersToMedia.on('ready-to-copy', function(e, data) {
                    this._copyBannersToMediaplan(data.bids);
                }, this);

                // @deprecated 10.09.2015 by coffeeich
                this.campaign = this.model;

                this.watchGroupMinusWords();
                this.watchCampaignMinusWords();
                this.watchBannerTags();

                this.__self.instance = this;

                var formParams = this.params.form,
                    modelParams = this.params.modelParams,
                    isAutobudget = this.campaign.get('strategy').is_autobudget;

                this.formRequest = BEM.create({ block: 'i-request', mods: { type: 'form' } }, {
                    url: formParams.action,
                    type: formParams.method,
                    name: formParams.name,
                    target: formParams.target
                });

                if (this.massActions) {
                    this.checkboxesGroup.on('change', this.updateMassActions, this);

                    this.massActions.on('editAgeLabels', function(e, adgroupIds) {
                        this.findBlocksInside('b-banner-age-label'); //инициализируем блоки c метками для их перерисовки
                        this.popup
                            .setContent(BEMHTML.apply({
                                block: 'b-banner-age-labels-edit',
                                mix: { block: 'p-campaign', elem: 'popup-inner' },
                                variants: this.params.ageVariants,
                                selectedLength: adgroupIds.length,
                                modelParams: modelParams,
                                mixBlock: 'p-campaign'
                            }))
                            .show();
                    }, this);

                    this.massActions.on('editChildAgeLabels', function(e, adgroupIds) {
                        this.popup
                            .setContent(BEMHTML.apply({
                                block: 'b-banner-baby-food-labels-edit',
                                mix: { block: 'p-campaign', elem: 'popup-inner' },
                                variants: this.params.babyAgeVariants,
                                selectedLength: adgroupIds.length,
                                modelParams: modelParams,
                                mixBlock: 'p-campaign'
                            }))
                            .show();
                    }, this);

                    this.massActions.on('editTags', function(e, adgroupIds) {
                        this.findBlocksInside('b-group-tags'); //инициализируем блоки c тегами, для перерисовки списка тегов
                        this.popup
                            .setContent(BEMHTML.apply({
                                block: 'b-group-tags-groupedit',
                                mix: { block: 'p-campaign', elem: 'popup-inner' },
                                selectedLength: adgroupIds.length,
                                modelParams: modelParams,
                                mixBlock: 'p-campaign',
                                useBanner: this.campaign.get('mediaType') == 'mcbanner' ||
                                    this.campaign.get('mediaType') == 'performance'
                            }))
                            .show();
                    }, this);

                    this.massActions.on('newCopy', function(e, adgroupIds) {
                        u.copyGroups(
                            u.consts('ulogin'),
                            this.model.get('cid'),
                            adgroupIds,
                            false
                        );
                    }.bind(this));

                    this.massActions.on('setAutotargeting', function() {
                        this.popup
                            .setContent(BEMHTML.apply({
                                block: 'b-groups-set-autotargeting',
                                mods: {
                                    view: isAutobudget ?
                                        'auto' :
                                        'manual-beta'
                                },
                                mix: { block: 'p-campaign', elem: 'popup-inner' },
                                js: {
                                    campModelParams: modelParams
                                },
                                mixBlock: 'p-campaign',
                                strategy: this.campaign.get('strategy')
                            }))
                            .show();
                    }, this);
                }

                this._animateInfoPanel(); //@todo: css

                // если у группы был удален/заархивирован лицевой баннер, то мы перемещаемся к данной группе
                this.goToGroup($.cookie('goToGroup'));
            }
        },

        _animateInfoPanel: function() {
            this.errorsPanel = this.findBlockOn('errors-panel', 'b-campaign-info-panel');
            this.correctionsPanel = this.findBlockOn('corrections-panel', 'b-campaign-info-panel');
            this.editPanel = this.findBlockInside('floater', 'b-campaign-edit-panel');

            if (this.editPanel) {
                this.bindToWin('scroll', this._updatePanelDimensions);
                $(window).resize(this._updatePanelDimensions.bind(this));

                this.editPanel.on('save', function() {
                    //скрываем сообщения об ошибках/коррекции, если они были открыты ранее
                    this.errorsPanel && this.errorsPanel.toggle(false);
                    this.correctionsPanel && this.correctionsPanel.toggle(false);
                }, this);

                this.errorsPanel && this.errorsPanel.on('visibility_changed', this._updatePanelDimensions, this);
                this.correctionsPanel &&
                    this.correctionsPanel.on('visibility_changed', this._updatePanelDimensions, this);
            }
        },

        /**
         * Выставляет ширину панели с ошибками в ширину окна, добавляет отступ под место панели
         * @private
         */
        _updatePanelDimensions: function() {
            this.afterCurrentEvent(function() {
                var visiblePanel = this.findBlocksOn('info-panel', 'b-campaign-info-panel').filter(function(panel) {
                    return panel.hasMod('hidden', 'no');
                })[0];

                this.elem('info-panel').css({
                    width: $('body').width() - 200 + 'px' // - 200 - это ширина сайдбара
                });
                this.elem('floater').css({
                    'margin-top': visiblePanel ? visiblePanel.domElem.height() : ''
                });
            });
        },

        /**
         * Обновляет доступные массовые действия на основании выбранных баннеров
         */
        updateMassActions: function() {
            var adgroupIds = this.getSelectedGroups().map(u.getter('getGroupModel')).map(u.getter('get', 'adgroup_id'));

            this.campaign.set('selectedAdgroupIds', adgroupIds);
            this.massActions.updateActions(adgroupIds);

            return this;
        },

        /**
         * Подписка на изменение минус слов баннеров
         * с целью инициализации фраз баннеров
         */
        watchGroupMinusWords: function() {
            BEM.MODEL.on(
                { name: this.campaign.getChildGroupModelName() },
                'minus_words',
                'change',
                function(e) {
                    BEM.blocks['b-groups-list'].initPhrasesLists(e.target.model.get('adgroup_id'))
                },
                this);
        },

        /**
         * Обновляет uses_count в метках кампании
         */
        watchBannerTags: function() {
            var campaign = this.campaign,
                groupModelName = this.campaign.getChildGroupModelName();

            BEM.MODEL.on({ name: groupModelName }, 'tags', 'add', function(e, info) {
                campaign.get('tags').where({ value: info.model.get('value') }).forEach(function(tag) {
                    tag.set('uses_count', tag.get('uses_count') + 1);
                });
                if (e.target.raw().length == 1) {
                    campaign.set('untagged_banners_num', campaign.get('untagged_banners_num') - 1);
                }
            });

            BEM.MODEL.on({ name: groupModelName }, 'tags', 'remove', function(e, info) {
                campaign.get('tags').where({ value: info.model.get('value') }).forEach(function(tag) {
                    tag.set('uses_count', tag.get('uses_count') - 1);
                });
                if (e.target.raw().length === 0) {
                    campaign.set('untagged_banners_num', campaign.get('untagged_banners_num') + 1);
                }
            });
        },

        /**
         * Подписка на изменение единых минус слов для кампании
         * с целью инициализации фраз для всех баннеров
         */
        watchCampaignMinusWords: function() {
            var model = this.model,
                callback = function() {
                    BEM.blocks['b-groups-list'].initPhrasesLists();
                    model.un('minus_words', 'change', callback);
                };

            model.on('minus_words', 'change', callback, this);
        },

        /**
         * Возвращает выбранные в данный момент группы баннеров
         * @returns {BEM[]}
         */
        getSelectedGroups: function() {
            var checkedMap = this.checkboxesGroup.getCheckedMap();

            return this.checkboxesGroup._getCheckboxes()
                .filter(function(el, index) { return checkedMap[index] })
                //@todo закэшировать баннеры в чекбоксах?
                .map(function(el) { return el.findBlockOutside('b-campaign-group') });
        },

        /**
         * Отправляем данные на сервер
         * @param {Object} data данные
         * @param {Object} attrs параметры формы
         */
        submit: function(data, attrs) {
            this.formRequest.submit($.extend({}, this.params.form.params, data), attrs);
        },

        /**
         * Копирование баннеров в медиаплан
         * @param {Array} bids идентификаторы баннеров, которые будут скопированы
         * @private
         */
        _copyBannersToMediaplan: function(bids) {
            this.submit({
                cmd: 'copyBannersToMediaplan',
                bids: bids.join(',')
            });
        },

        /**
         * Перемещает к группе и открывает балун группы.
         *
          * @param {String} adgroupId
         */
        goToGroup: function(adgroupId) {
            if (adgroupId) {
                $.cookie('goToGroup', null);
                var group = this.findBlockInside({
                    block: 'b-campaign-group',
                    modName: 'adgroupId',
                    modVal: adgroupId
                });
                if (group) {
                    window.scrollTo(group.domElem.offsetLeft, group.domElem.offsetLeft);
                    group.toggleGroupPreview();
                }
            }
        }
    });
}());
