u.register({

    'p-campaign': {

        /**
         * Достраивает объекты фильтров до необходимого для работы состояния
         * После внедрения серверных моделей этот метод нужно модифицировать
         * @param {Object} group
         * @param {Object} campaign
         * @param {Object} params
         * @param {Boolean} params.allowEdit
         * @param {Boolean} params.viewOnly
         */
        fulfill: function(group, campaign, params) {
            // разрешено использовать ставку по умолчанию в случаях:
            //  - стратегия CPC на кампанию
            //  - стратегия CPA на кампанию
            //  - для стратегии задан filter_avg_bid (ставка по умолчанию для стратегий CPC/CPA по каждому фильтру)
            var hasDefaultPrice = /^autobudget_avg_(cpc|cpa)_per_camp$/.test(campaign.strategy.name) ||
                    campaign.strategy.net.filter_avg_bid > 0 ||
                    campaign.strategy.search.filter_avg_bid > 0,
                isEditableGroup = params.allowEdit,
                isEditableSettings = !campaign.currency_archived && group.archive !== 'Yes',
                isSettingsCanNotSave = !isEditableGroup && !campaign.currency_archived && group.archive !== 'Yes',
                isEditablePrice = isEditableGroup && !params.viewOnly && group.banners_quantity > 0;

            //todo DIRECT-54675 @heliarian - на сервере будет задача как сведения perfomance_filters и dynamic_filters
            //todo к единому feed_filters, и perf_filter_id и dyn_id к filter_id номер задачи скажет  hrustyashko как выйдет из отпуска
            group.feed_filters = group.adgroup_type === 'dynamic' && !group.main_domain ?
                group.dynamic_conditions :
                group.performance_filters;

            (group.feed_filters || []).forEach(function(filter) {
                var useFilterPrice = !hasDefaultPrice;

                if (hasDefaultPrice) {
                    // использовать (и показывать в интерфейсе) заданную ставку cpc на фильтре, если она имеет значение
                    if (/^autobudget_avg_cpc_per_(camp|filter)$/.test(campaign.strategy.name)) {
                        useFilterPrice = filter.price_cpc > 0;
                    }

                    // использовать (и показывать в интерфейсе) заданную ставку cpc/cpa на фильтре, если она имеет значение
                    if (/^autobudget_avg_cpa_per_(camp|filter)$/.test(campaign.strategy.name)) {
                        useFilterPrice = filter.price_cpc > 0 || filter.price_cpa > 0;
                    }
                }

                filter.filter_name = filter.filter_name || filter.condition_name;
                filter.filter_id = filter.filter_id || filter.dyn_id;

                u._.extend(filter, {
                    currency: campaign.currency,
                    campaign_id: campaign.cid,
                    is_settings_editable: isEditableSettings,
                    is_settings_cant_save: isSettingsCanNotSave,
                    is_price_editable: isEditablePrice,
                    has_default_price: hasDefaultPrice,
                    use_default_price: !useFilterPrice,
                    adgroupModelId: group.modelId,
                    adgroup_type: group.adgroup_type,
                    is_suspended: Boolean(+filter.is_suspended),
                    is_deleted: false
                });
            });
        }

    }

});
