match(function() {
    return this.data.cmd === 'showSubClientCamps';
})(

    block('app-main')(

        mode('preprocess')(function() {
            var data = this.data,
                rights = data.login_rights,
                campaigns = data.campaigns || [];

            data.can = {
                see_original_sum: rights.manager_control || rights.super_control || rights.placer_control ||
                    rights.media_control || rights.support_control
            };

            campaigns.length && campaigns.forEach(function(camp) {
                data.can.showPayColumn ||
                    (data.can.showPayColumn = (camp.action || {}).pay &&
                        !camp.noaction);
            });

            // в i-const__currencies.bemtree.xjst константа pseudo_currency определяется при условии наличия data.usePseudoCurrency
            // u.consts('pseudo_currency') используется в баяне
            data.usePseudoCurrency = false

            return data;
        }),

        mode('page-block')('p-campaigns-subclient')
    ),

    block('b-page').mode('title')(function() {
        return this.data.page_title;
    })
);

block('p-campaigns-subclient')(

    def().match(function() {
        return !this.pageParams;
    })(function() {
        var data = this.data;

        return applyNext({
            pageParams: {
                readonly: true,
                isMy: data.uid == data.UID,
                auxParams: {
                    payCampaign: null
                }
            }
        });
    }),

    content()(function() {
        var data = this.data,
            campaignsByCurrency = data.campaigns_by_currency || {},
            currencies = Object.keys(campaignsByCurrency),
            currenciesLength = currencies.length,
            campaignsListMods = {};

        data.can.showPayColumn && (campaignsListMods.pay = 'yes');

        return [
            (!data.error || data.FORM.error_code) && {
                block: 'b-campaigns-pay-error'
            },
            {
                block: 'l-page',
                mods: {
                    layout: '16-50-30'
                },
                content: {
                    elem: 'row',
                    left: true,
                    center: [
                        {
                            block: 'p-campaigns-subclient',
                            elem: 'header'
                        }
                    ],
                    right: true
                }
            },
            {
                block: 'l-page',
                mods: {
                    layout: '84'
                },
                content: [
                    {
                        elem: 'row',
                        center: [{
                            block: 'p-campaigns-subclient',
                            elem: 'tabs'
                        }]
                    },
                    {
                        elem: 'row',
                        center: [
                            currencies.map(function(currency, index) {
                                return {
                                    block: 'b-campaigns-list',
                                    mods: campaignsListMods,
                                    page: 'campaigns-subclient',
                                    currency: currency,
                                    dontDrawPages: index != currenciesLength - 1,
                                    campaigns: campaignsByCurrency[currency],
                                    countCampaignsLists: currenciesLength
                                };
                            }, this)
                        ]
                    }
                ]
            }
        ];
    })
);
