block('p-campaigns').elem('autopayment-warning')(

    replace()(function() {
        var wallet = this.ctx.wallet,
            walletCid = wallet.wallet_cid,
            autoPaySettings = wallet['autopay_settings'] || {},
            isAutopaymentEnabled = !u.autopayment.params.disabled && autoPaySettings.autopay_mode;

        if (!isAutopaymentEnabled || !wallet.enabled || !autoPaySettings.error ||
            autoPaySettings.autopay_mode == 'none') {

            return '';
        }

        return {
            block: 'b-page-warning',
            mix: {
                block: 'p-campaigns',
                elem: 'autopayment-warning',
                elemMods: {
                    'wallet-cid': walletCid
                }
            },
            id: 'autopayment-warning-' + walletCid,
            pageWarningField: 'autopaymentWarning',
            content: {
                block: 'b-autopayment-info',
                mods: { view: 'page-warning' },
                autoPaySettings: autoPaySettings,
                canResumeAutopay: u.autopayment.params.canResumeAutopay,
                disableEditAutopay: u.autopayment.params.disableEditAutopay,
                currency: this.ctx.currency,
                title: this.ctx.showTitle ? iget2('p-campaigns', 'schet-s', 'Счет: {foo}.', {
                    foo: wallet.wallet_cid
                }) : ''
            }
        };
    })
);
