block('p-campaigns').elem('aux-actions').content()(function() {
    var data = this.data,
        form = data.FORM,
            // для AB-тестирования смотрим на то что есть общий счёт
            // утащил условие из b-wallet-link.bemtree.xjst
        firstCampaign = data.campaigns[0] || {},
        agencyID = +firstCampaign.AgencyID,
        wallet = agencyID ? data.wallet.agencies[agencyID] : data.wallet.self,

        rights = data.login_rights,
        domains = u.consts('domains'),
        ulogin = form.ulogin || data.uname,
        hasAgency = rights.client_have_agency,
        userLogin = {
            ulogin: ulogin
        },
        pageParams = this.pageParams,
        auxParams = pageParams.auxParams,
        isClient = rights.role == 'client' && pageParams.isMy,
        isAgencyUnderSuper = hasLoginRights('super_control') &&
            (auxParams.agencyLogin || hasAgency || data.client_have_agency),
        canUseFeeds = !(data.is_turkish_client || u.consts('domains').tr) ||
            data.has_dynamic_campaigns || data.has_performance_campaigns || hasLoginRights('super_control'),
        canTransferMoney = auxParams.transfer_money && auxParams.camp_count_for_transfer > 1 &&
            auxParams.camp_count_with_sum > 0,
        groups = [],
        groupsIdx = {},
        managersInfo = data.managers_info,
        groupsNames = {
            stat: iget2('p-campaigns', 'statistika', 'Статистика'),
            management: iget2('p-campaigns', 'upravlenie-kampaniyami', 'Управление кампаниями'),
            payments: iget2('p-campaigns', 'byudzhet-i-oplata', 'Бюджет и оплата'),
            lists: iget2('p-campaigns', 'obshchie-spiski', 'Общие списки'),
            additional: iget2('p-campaigns', 'dopolnitelnye-vozmozhnosti', 'Дополнительные возможности'),
            access: iget2('p-campaigns', 'dostup-k-kampaniyam', 'Доступ к кампаниям'),
            'agency-management': iget2('p-campaigns', 'upravlenie-klientami', 'Управление клиентами')

        },
        getOrCreateGroupObject = function(index) {
            var groupObj = groupsIdx[index] !== undefined ? groups[groupsIdx[index]] : {};

            if (groupsIdx[index] === undefined) {
                groupObj.title = groupsNames[index];
                groupObj.links = [];
                groups.push(groupObj);
                groupsIdx[index] = groups.length - 1;
            }

            return groupObj;
        },
        addLink = function(groupName, linkObj) {
            var groupObj = getOrCreateGroupObject(groupName);

            groupObj.links.push(linkObj);
        },
        chief;

    if (data.is_currency_archive) {
        addLink('stat', {
            block: 'link',
            url: u.getUrl('showCampStat', u._.extend({}, userLogin, {
                currency_archive: 1,
                stat_type: 'campdate'
            })),
            content: iget2('p-campaigns', 'statistika-po-starym-kampaniyam', 'Статистика по старым кампаниям в у.е.')
        });
        addLink('stat', {
            block: 'link',
            url: u.getUrl('showCamps', userLogin),
            content: u.currencies.getText(
                    data.work_currency,
                    rights.is_any_client ? 'my_new_campaigns_in' : 'client_new_campaigns_in')
        });
    } else {
        canTransferMoney && addLink('payments', {
            block: 'link',
            url: u.getUrl('transfer', userLogin),
            content: iget2('p-campaigns', 'perenos-sredstv-s-kampanii', 'Перенос средств с кампании на кампанию')
        });

        auxParams.showCampStat && addLink('stat', {
            block: 'link',
            attrs: {
                id: 'all_campaign_stat_link'
            },
            url: u.getUrl('showStat', u._.extend(userLogin, {
                stat_type: 'mol'
            })),
            content: iget2('p-campaigns', 'statistika-po-vsem-kampaniyam', 'Статистика по всем кампаниям')
        });

        (hasLoginRights('super_control', 'superreader_control') && !hasLoginRights('is_super_manager') ||
                (((rights.ViewPdfReports || hasLoginRights('media_control')) &&
                    (hasAgency || rights.client_is_serviced || data.client_have_agency || auxParams.showCampStat) ||
                    (hasLoginRights('manager_control') && rights.client_is_serviced_by_UID)))) && addLink('stat', {
                        block: 'link',
                        url: u.getUrl('newPdfReport', userLogin),
                        content: iget2('p-campaigns', 'zakaz-otchetov', 'Заказ отчетов')
                    });

        (isClient || isAgencyUnderSuper) && !hasLoginRights('media_control') &&
                addLink('lists', {
                    block: 'link',
                    url: u.getUrl('showRetargetingCond', userLogin),
                    content: iget2('p-campaigns', 'usloviya-podbora-auditorii', 'Ретаргетинг и аудитории')
                });

        auxParams.agencyLogin && addLink('agency-management', {
            block: 'link',
            url: u.getUrl('showClients', {
                ulogin: auxParams.agencyLogin
            }),
            content: iget2('p-campaigns', 'spisok-klientov-agentstva', 'Список клиентов агентства')
        });

        if (rights.is_client_chief ||
            hasLoginRights('super_control', 'manager_control', 'superreader_control', 'support_control', 'limited_support_control')) {

            addLink('access', {
                block: 'link',
                url: u.getUrl('showClReps', userLogin),
                content: iget2('p-campaigns', 'zaregistrirovannye-predstaviteli', 'Зарегистрированные представители')
            });
        } else {
            data.client_chief && (chief = {
                email: u.escapeHTML(data.client_chief.email),
                name: u.escapeHTML(data.client_chief.fio) +
                        '&nbsp;(' + u.escapeHTML(data.client_chief.login) + ')'
            });
        }

        hasLoginRights('super_control', 'manager_control', 'support_control') && addLink('management', {
            block: 'b-choose-campaign-type',
            _wrap: false,
            userLogin: userLogin,
            text: iget2('p-campaigns', 'dobavit-kampaniyu-klientu', 'Добавить кампанию клиенту')
        });

        rights.CopyCamp && hasLoginRights('manager_control') && addLink('management', {
            block: 'link',
            url: u.getUrl('copyCamp'),
            content: iget2('p-campaigns', 'skopirovat-kampaniyu', 'Скопировать кампанию')
        });

        (auxParams.edit_camp && !hasLoginRights('media_control') || hasLoginRights('superreader_control')) && !domains.tr &&
            addLink('management', {
                block: 'link',
                url: '/commander/',
                content: iget2('p-campaigns', 'kommander', 'Коммандер')
            });

        (hasLoginRights('manager_control', 'super_control', 'placer_control', 'superplacer_control',
            'superreader_control', 'agency_control') || !hasAgency || data.can_use_xls) &&
                addLink('management', {
                    block: 'link',
                    url: u.getUrl('showExportedXlsList', userLogin),
                    content: iget2('p-campaigns', 'xls-xlsx', 'XLS/XLSX')
                });

        !hasLoginRights('superreader_control') && data.api_enabled_flag &&
            hasLoginRights('super_control', 'is_any_client', 'support_control') &&
                addLink('management', {
                    block: 'link',
                    url: u.getUrl('apiSettings', form.ulogin ? { ulogin: u.escapeHTML(form.ulogin) } : null),
                    content: iget2('p-campaigns', 'api', 'API')
                });

        !isClient && (!isAgencyUnderSuper) && !hasLoginRights('media_control') &&
                addLink('lists', {
                    block: 'link',
                    url: u.getUrl('showRetargetingCond', userLogin),
                    content: iget2('p-campaigns', 'usloviya-podbora-auditorii', 'Ретаргетинг и аудитории')
                });

        canUseFeeds && addLink('lists', {
            block: 'link',
            url: u.getUrl('showFeeds', u._.extend(userLogin, {
                retpath: u.getCurrentUrl()
            })),
            content: iget2('p-campaigns', 'fidy', 'Фиды')
        });

        u.consts('rights').useDynamicMediaCampaigns && addLink('lists', {
            block: 'link',
            url: u.getUrl('showCreatives', u._.extend(userLogin, {
                retpath: u.getCurrentUrl()
            })),
            content: iget2('p-campaigns', 'kreativy-dlya-smart-bannerov', 'Креативы для смарт-баннеров')
        });

        Number(data.is_featureTurboLandingEnabled) === 1 && addLink('lists', {
            block: 'link',
            mix: {
                block: 'b-metrika2',
                js: {
                    nativeEvent: 'click',
                    params: {
                        turbolandingConstructor: {
                            showCamps: {
                                open: true
                            }
                        }
                    }
                }
            },
            url: u.getUrl('showTurboLandings', u._.extend(userLogin, {
                ClientID: data.ClientID
            })),
            content: iget2('p-campaigns', 'turbolandings', 'Конструктор Турбо-страниц')
        });

        addLink('lists', {
            block: 'link',
            url: u.formatUrl({
                path: '/dna/mobile-apps/list',
                query: {
                    ulogin: userLogin.ulogin
                }
            }),
            content: iget2('p-campaigns', 'spisok prilojeniy', 'Список приложений')
        });

        auxParams.campsExist &&
            !hasLoginRights('media_control') && auxParams.cid_for_manage_vcards &&
            addLink('additional', {
                block: 'link',
                url: u.getUrl('manageVCards', {
                    cid: auxParams.cid_for_manage_vcards,
                    ulogin: auxParams.showuid ? ulogin : ''
                }),
                content: iget2('p-campaigns', 'master-zapolneniya-virtualnyh-vizitok', 'Мастер заполнения виртуальных визиток')
            });

        form.tab == 'active' && auxParams.be_shows && !hasLoginRights('media_control') && addLink('stat', {
            block: 'link',
            url: u.getUrl('listWarnPlace', {
                sort: 'addtime',
                reverse: 1,
                ws_place: 0,
                ws_time: '1d',
                ws_cid: 0,
                ws_done: 0,
                ws_client: data.uid != data.UID ? ulogin : '',
                ulogin: hasLoginRights('super_control', 'support_control', 'limited_support_control', 'superreader_control', 'manager_control') ?
                        ulogin : ''
            }),
            content: iget2('p-campaigns', 'traffic-volume-changes-monitoring', 'Мониторинг изменений объёма трафика по фразам')
        });

        hasLoginRights('super_control', 'superreader_control', 'manager_control') &&
                data.work_currency != 'YND_FIXED' && wallet && !!wallet.enabled &&
                addLink('additional', {
                    block: 'link',
                    url: u.getUrl('showExperiments', userLogin),
                    content: iget2('p-campaigns', 'ab-testirovanie', 'AB-тестирование')
                });

        !hasLoginRights('is_any_client', 'agency_control') && rights.is_internal_user &&
            addLink('additional', {
                block: 'link',
                url: u.getUrl('searchDoublesOrderPage', userLogin),
                content: iget2('p-campaigns', 'poisk-dubley-v-klyuchevyh', 'Поиск дублей в ключевых словах')
            });

        data.has_currency_archived_campaigns && addLink('additional', {
            block: 'link',
            url: u.getUrl('showCamps', u._.extend(userLogin, {
                currency_archive: 1
            })),
            content: rights.is_any_client ?
                    iget2('p-campaigns', 'moi-starye-kampanii-v-124', 'Мои старые кампании в у.е.') : iget2('p-campaigns', 'starye-kampanii-klienta-v-125', 'Старые кампании клиента в у.е.')
        });

        rights.EditInternationalization && !hasLoginRights('is_any_client') && addLink('additional', {
            block: 'link',
            url: u.getUrl('i18nTmplList'),
            content: iget2('p-campaigns', 'interfeys-internacionalizacii', 'Интерфейс интернационализации')
        });

        u.consts('lang') === 'ru' &&
            addLink('additional', {
                block: 'link',
                url: u.formatUrl({
                    path: '/dna/log/',
                    query: {
                        ulogin: ulogin
                    }
                }),
                content: [
                    iget2('p-campaigns', 'istoria-izmenenii', 'История изменений'),
                    {
                        block: 'b-beta',
                        mods: { type: 'symbol' }
                    }
                ]
            });

        data.video_constructor_enabled &&
            addLink('additional', {
                block: 'link',
                url: u.formatUrl({
                    path: '/dna/vc/list',
                    query: {
                        ulogin: ulogin
                    }
                }),
                content: [
                    iget2('p-campaigns', 'video-constructor', 'Видеоконструктор'),
                    {
                        block: 'b-beta',
                        mods: { type: 'symbol' }
                    }
                ]
            });
    }

    data.show_moderate_docs_link && addLink('additional', {
        block: 'link',
        url: u.getUrl('showUploadModerationDocs', userLogin),
        content: iget2('p-campaigns', 'zagruzit-dokumenty', 'Загрузить документы')
    });

    return {
        block: 'b-additional-actions',
        mods: {
            bordered: 'yes'
        },
        groups: groups,
        chief: chief,
        inThreeColumns: isAgencyUnderSuper && canTransferMoney,
        manager: managersInfo.manager_FIO ?
            {
                name: managersInfo.manager_FIO,
                email: managersInfo.manager_email
            } :
            undefined
    };
});
