block('p-campaigns').elem('day-budget-warning')(

    replace()(function() {
        var wallet = this.ctx.wallet,
            dayBudgetWarning = wallet.camp_stop_daily_budget_warning || {},
            walletLinkParams = {
                showEditTools: 'day-budget'
            },
            dayBudgetWarningTime = u.moment(dayBudgetWarning.stop_time),
            walletRestr = u.getWalletRestrictions(wallet),
            isOldTheme = this.ctx.isOldTheme,
            place = this.ctx.place || 'camps';

        wallet.agencyID && (walletLinkParams.AgencyID = wallet.agencyID);
        this.ctx.ulogin && (walletLinkParams.ulogin = this.ctx.ulogin);

        return {
            block: 'p-campaigns',
            elem: 'day-budget-warning-body',
            content: [
                {
                    block: 'icon',
                    mix: {
                        block: this.block,
                        elem: 'day-budget-warning-icon'
                    },
                    mods: {
                        'size-18': 'alert-white'
                    }
                },
                {
                    elem: 'day-budget-warning-text',
                    content: [
                        this.ctx.showTitle && iget2('p-campaigns', 'schet-s', 'Счет: {foo}.', {
                            foo: wallet.wallet_cid
                        }) + ' ',
                        u.moment(dayBudgetWarning.msk_today).get('date') === dayBudgetWarningTime.get('date') ?
                            iget2(
                                'p-campaigns',
                                'segodnya-vse-kampanii-obshchego',
                                'Сегодня все кампании общего счёта были остановлены в {foo} по московскому времени. Возможно, вам следует повысить дневное ограничение для общего счёта.',
                                {
                                    foo: dayBudgetWarningTime.format('HH:mm')
                                }
                            ) :
                            iget2(
                                'p-campaigns',
                                'vchera-vse-kampanii-obshchego',
                                'Вчера все кампании общего счёта были остановлены в {foo} по московскому времени. Возможно, вам следует повысить дневное ограничение для общего счёта.',
                                {
                                    foo: dayBudgetWarningTime.format('HH:mm')
                                }
                            )
                    ]
                },
                (walletRestr.isAllowTransferMoney || walletRestr.isAllowedEditCamps) &&
                    !walletRestr.isReadOnlyWallet && {
                        block: 'button2',
                        mods: {
                            theme: 'normal',
                            size: 'm',
                            view: 'default',
                            tone: 'transparent',
                            type: 'link'
                        },
                        mix: {
                            block: 'b-metrika2',
                            js: {
                                event: 'click',
                                params: {
                                    'day-budget-recommendation': {
                                        place: place,
                                        type: isOldTheme ? 'old2' : 'new',
                                        event: 'go-to-wallet'
                                    }
                                },
                                blockName: 'button2'
                            }
                        },
                        text: iget2('p-campaigns', 'izmenit-ogranicheniya', 'Изменить ограничения'),
                        url: u.getUrl('clientWallet', walletLinkParams)
                    }
            ]
        };
    })
);
