block('p-campaigns').elem('header')(

    replace()(function() {

        var data = this.data,
            rights = data.login_rights,
            loginAgency = rights.is_agency_main || rights.is_agency_chief,
            agencyOperation = rights.agency_control && !data.agency_client_relation,
            titleContent = apply('title-page'),
            textContent = (loginAgency || agencyOperation) ?
            apply('sub', {
                agencyOperation: agencyOperation,
                loginAgency: loginAgency
            }) : '',
            errorContext = data.FORM.error_code ? data.error : '';

        return [
            {
                block: 'b-page-title',
                mix: [{
                    block: 'p-campaigns',
                    elem: 'header'
                }],
                title: titleContent,
                text: textContent
            },
            errorContext && {
                block: 'p-campaigns',
                elem: 'header-error',
                content: errorContext
            }
        ];
    }),

    mode('title-page')(function() {
        return this.pageParams.titleCampaigns;
    }),

    match(function() {
        return !this.pageParams.isMy;
    })(
        mode('title-page')(function() {
            return [
                applyNext(),
                ': '
            ];
        }),

        match(function() {
            return this.data.has_access_to_login;
        }).mode('title-page')(function() {
            return [
                applyNext(),
                {
                    block: 'link',
                    url: u.getUrl('modifyUser', {
                        rulogin: this.data.FORM.ulogin,
                        ulogin: this.data.FORM.ulogin,
                        rcmd: 'showCamps'
                    }),
                    content: this.nameUser,
                    mix: {
                        block: 'b-metrika2',
                        js: {
                            nativeEvent: 'click',
                            params: {
                                showCamps: {
                                    title: 'modifyUserLinkClicked'
                                }
                            }
                        }
                    }
                }
            ];
        }),

        match(function() {
            return !this.data.has_access_to_login;
        }).mode('title-page')(function() {
            return [
                applyNext(),
                this.nameUser
            ];
        }),

        match(function() {
            return this.data.statusBlocked == 'Yes';
        }).mode('title-page')(function() {
            return [
                applyNext(),
                ' (' + iget2('p-campaigns', 'zablokirovan', 'заблокирован') + ')'
            ];
        })
    ),

    match(function() {
        return this.loginAgency;
    })(

        mode('sub')(function() {
            return iget2('p-campaigns', 'predstavitel', 'Представитель') + ':&nbsp;';
        }),

        match(function() {
            return this.data.limited_agency;
        }).mode('sub')(function() {
            return [
                applyNext(),
                {
                    block: 'link',
                    mix: {
                        block: 'b-metrika2',
                        js: {
                            nativeEvent: 'click',
                            params: {
                                showCamps: {
                                    title: 'showClientsLinkClick'
                                }
                            }
                        }
                    },
                    url: u.getUrl('showClients', {
                        ulogin: this.data.limited_agency.login
                    }),
                    content: this.data.limited_agency.fio
                }
            ];
        }),

        match(function() {
            return !this.data.limited_agency;
        }).mode('sub')(function() {
            return [
                applyNext(),
                iget2('p-campaigns', 'ne-naznachen', 'не назначен'),
                apply('manageAgency')
            ];
        }),

        mode('manageAgency')(''),

        match(function() {
            return this.data.agency_client_relation;
        }).match(function() {
            return !this.data.agency_client_archived;
        }).mode('manageAgency')(function() {
            return {
                block: 'link',
                mix: {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamps: {
                                title: 'manageClientsOfAgencyLinkClick'
                            }
                        }
                    }
                },
                url: u.getUrl('manageClientsOfAgency'),
                content: iget2('p-campaigns', 'naznachit', 'назначить')
            };
        })
    ),

    match(function() {
        return this.agencyOperation;
    }).mode('sub')(function() {
        return {
            block: 'icon-text',
            mods: { size: 's', theme: 'alert' },
            text: iget2('p-campaigns', 'obsluzhivanie-klienta-zaversheno', 'Обслуживание клиента завершено')
        };
    })
);
