block('p-campaigns').elem('tabs')(

    replace()(function() {
        var data = this.data,
            isService = this.pageParams.isService,
            currentTabs = this.pageParams.currentTabs,
            tabsKeys = data.is_currency_archive ?
                ['converted', 'arch', 'all'] :
                ['active', 'planned', 'arch', 'all'],
            hasCampaignsWithDailyBudgetNotification = !u._.isEmpty(data.daily_budget_notification) &&
                u._.get(data, 'daily_budget_notification.cids', []).length > 0,
            hasCampaignsWithAuctionProbabilityNotification = !u._.isEmpty(data.auction_probability_notification) &&
                u._.get(data, 'auction_probability_notification.cids', []).length > 0;

        // DIRECT-28467 + DIRECT-28817
        !data.is_currency_archive && !currentTabs['planned'] && !isService && tabsKeys.splice(1, 1);

        // если есть проблемные кампании
        if (hasCampaignsWithDailyBudgetNotification || hasCampaignsWithAuctionProbabilityNotification) {
            tabsKeys.push('troubled');
        }

        currentTabs.archived && (currentTabs.arch = currentTabs.archived);

        return {
            block: 'b-list-tabs',
            mods: {
                theme: 'border-bottom'
            },
            mix: {
                block: 'b-metrika2',
                js: {
                    blockName: 'b-list-tabs',
                    event: 'tab-click',
                    params: {
                        ShowCamps: 'Tab_types_campaigns'
                    }
                }
            },
            tabs: {
                keys: tabsKeys,
                countItems: currentTabs,
                extra: {
                    urlParams: function(tabKey, defaultTab) {
                        var obj = {
                            tab: tabKey
                        };

                        data.is_currency_archive && 'converted arch all'.indexOf(this.tabId) != -1 &&
                            (obj.currency_archive = 1);

                        return u.getUrlParams(defaultTab == tabKey ? ['tab', 'cmd'] : ['cmd'], obj);
                    },
                    disabled: function(tabKey, countItems) {
                        return (tabKey === 'all' && countItems[tabKey] < 1) ?
                            'yes' :
                            countItems[tabKey] ? '' : 'yes';
                    }
                }
            },
            links: apply('renderLinks')
        };
    }),

    mode('renderLinks')(function() {
        var data = this.data,
            isProduction = data.is_production,
            rights = data.login_rights,
            ulogin = data.FORM.ulogin,
            urlParams = ulogin ? { ulogin: ulogin } : {},
            isBlocked = data.statusBlocked == 'Yes',
            links = [],
            counterPopupLinks = [];

        // Скидочная политика (специально для Турции) DIRECT-37350
        if (data.yandex_domain == 'yandex.com.tr') {
            links.push({
                block: 'link',
                mix: {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamps: {
                                tabs: {
                                    agencyDiscountLinkClick: true
                                }
                            }
                        }
                    }
                },
                mods: {
                    type: 'action'
                },
                target: '_blank',
                url: iget2('p-campaigns', 'http-advertising-yandex-com', 'http://advertising.yandex.com.tr/price/discount/context.xml'),
                content: [
                    iget2('p-campaigns', 'skidochnaya-politika', 'Скидочная политика'),
                    rights.role == 'agency' ?
                        {
                            block: 'b-help-link',
                            mods: {
                                type: 'modal'
                            },
                            url: u.getHelpUrl('agency-discount')
                        } :
                        ''
                ]
            });
        }

        // Платежи и документы
        if (rights.role == 'client' && !rights.client_have_agency && data.campaigns.length && data.ClientID) {
            links.push({
                block: 'link',
                mix: {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamps: {
                                tabs: {
                                    paymentsAndDocsLinkClick: true
                                }
                            }
                        }
                    }
                },
                mods: {
                    type: 'action'
                },
                url: u.consts('balance-url'),
                content: iget2('p-campaigns', 'platezhi-i-dokumenty', 'Платежи и документы')
            });
        }

        // Настройки пользователя
        data.has_access_to_login_settings && links.push({
            block: 'link',
            mix: {
                block: 'b-metrika2',
                js: {
                    nativeEvent: 'click',
                    params: {
                        showCamps: {
                            tabs: {
                                userSettingsLinkClick: true
                            }
                        }
                    }
                }
            },
            mods: {
                type: 'action'
            },
            url: u.getUrl('userSettings', urlParams),
            content: iget2('p-campaigns', 'nastroyki-polzovatelya', 'Настройки пользователя')
        });

        // Счетчики
        (rights.agency_control || rights.limited_support_control) && counterPopupLinks.push({
            block: 'link',
            mix: {
                block: 'b-metrika2',
                js: {
                    nativeEvent: 'click',
                    params: {
                        showCamps: {
                            tabs: {
                                addCounterLinkClick: true
                            }
                        }
                    }
                }
            },
            mods: {
                type: 'action'
            },
            attrs: {
                target: 'blank'
            },
            url: u.formatUrl({
                host: data.script,
                query: this.extend(urlParams, {
                    cmd: 'yaAddCounter'
                })
            }),
            content: iget2('p-campaigns', 'dobavit-schyotchik', 'Добавить счётчик')
        });

        ((rights.agency_control || rights.limited_support_control) && data.user_ya_counters !== '0' ||
            !rights.agency_control && rights.is_internal_user) && counterPopupLinks.push({
                block: 'link',
                mix: {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamps: {
                                tabs: {
                                    showCountersLinkClick: true
                                }
                            }
                        }
                    }
                },
                mods: {
                    type: 'action'
                },
                attrs: {
                    target: 'blank'
                },
                url: u.formatUrl({
                    host: data.script,
                    query: this.extend(urlParams, {
                        cmd: 'yaShowUserCounters'
                    })
                }),
                content: iget2('p-campaigns', 'schetchiki-klienta', 'Счетчики клиента')
            });

        counterPopupLinks.length && links.push({
            block: 'dropdown',
            content: [
                {
                    block: 'button',
                    mix: [
                        {
                            block: 'dropdown',
                            elem: 'switcher'
                        },
                        {
                            block: 'p-campaigns',
                            elem: 'counter-dropdown-switcher'
                        },
                        {
                            block: 'b-metrika2',
                            js: {
                                event: 'click',
                                blockName: 'button',
                                params: {
                                    showCamps: {
                                        tabs: {
                                            showCountersButtonClick: true
                                        }
                                    }
                                }
                            }
                        }
                    ],
                    mods: {
                        size: 's',
                        pseudo: 'yes',
                        theme: 'normal'
                    },
                    content: iget2('p-campaigns', 'schetchiki-metriki', 'Счетчики метрики') + ': ' + (data.user_ya_counters || 0)
                },
                {
                    elem: 'popup',
                    mix: [{
                        block: 'b-list-tabs',
                        elem: 'counter-popup'
                    }],
                    content: counterPopupLinks.map(function(link) {
                        return {
                            block: 'b-list-tabs',
                            elem: 'item',
                            content: link
                        };
                    })
                }
            ],
            tabItemMix: [{
                block: 'p-campaigns',
                elem: 'counter-dropdown'
            }]
        });

        return links;
    })
);
