match(function() {
    return this.data.cmd === 'showCamps' && !this.data.grid;
})(

    block('app-main')(

        mode('preprocess')(function() {
            var data = this.data,
                rights = data.login_rights,
                notSplitWallet,
                controlManagerSuperPlacer = rights.manager_control || rights.super_control || rights.placer_control,
                agency,
                campsGroupsNames = [],
                campaigns = data.campaigns_filtered_by_tab || [],
                campaignsLength = campaigns.length,
                wallet = data.wallet || {},
                walletSelf = wallet.self || {},
                walletAgencies = wallet.agencies || {};
                //в agencyID может приходить строка '0'
                //agencyID = +data.FORM.AgencyID;

            data.can = {};
            //необходимо, чтобы в i-global записать в константы переменная pseudo_currency
            data.usePseudoCurrency = false;

            if (campaignsLength) {

                campaigns.forEach(function(camp) {
                    var group = '3_self', // Самостоятельное обслуживание
                        action = camp.action || {},
                        actionPay = action.pay;

                    if (camp.AgencyID != '0') {
                        agency = data.agencies_info[camp.AgencyID];
                        group = agency && agency.freedom ?
                            '2_agency_' + camp.AgencyID : // На обслуживании агентства
                            '4_agencyold_' + camp.AgencyID; // На обслуживании агентства (обслуживание завершено)
                    } else if (camp.ManagerUID) {
                        group = '1_carefree'; // На обслуживании менеджером
                    }

                    data.can.showPayColumn || (data.can.showPayColumn = actionPay && !camp.noaction);

                    campsGroupsNames.indexOf(group) == -1 && campsGroupsNames.push(group);
                }, this);

                notSplitWallet = campsGroupsNames.indexOf('1_carefree') != -1 && campsGroupsNames.indexOf('3_self') != -1 &&
                    campsGroupsNames.length == 2 || campsGroupsNames.length == 1;

            } else {
                // Если ни у клиента, ни у агенства нет ОС - блок не отображаем
                notSplitWallet = +walletSelf.wallet_cid || +walletAgencies.wallet_cid;
            }

            data.notSplitWallet = notSplitWallet;

            data.can.see_original_sum = controlManagerSuperPlacer || rights.media_control || rights.support_control;

            return data;
        }),

        mode('page-block')('p-campaigns')
    ),

    block('b-page')(

        def().match(function() {
            return !this.pageParams;
        })(function() {
            var data = this.data,
                form = data.FORM,
                rights = data.login_rights,
                userTotalSum = 0,
                currentTabs = data['text_tabs'],
                isService = false,
                isMy = !(data.uid && data.UID != data.uid),
                titleCampaigns,
                isCurrencyArchive = data.is_currency_archive;

            // Определяем есть ли сервисируемые кампании и общую сумму
            data.campaigns.forEach(function(camp) {
                !isService && camp.ManagerUID && (isService = true);
                userTotalSum += camp.sum;
            });

            // Определяем текущий таб
            form.tab || (form.tab = isCurrencyArchive ? 'converted' : 'active');
            if (form.tab == 'all' && currentTabs.all < 1) {
                form.tab = 'active';
            }
            if (form.tab == 'active' && !currentTabs.active) {
                if (currentTabs.planned && isService && !userTotalSum) {
                    form.tab = 'planned';
                } else {
                    form.tab = currentTabs.archived ? 'arch' : 'all';
                }
            } else if (form.tab == 'planned' && !currentTabs.planned) {
                form.tab = currentTabs.archived ? 'arch' : 'all';
            } else if (form.tab == 'arch' && !currentTabs.archived) {
                form.tab = 'all';
            }

            // Формируем заголовок кампании
            if (isCurrencyArchive) {
                if (form.tab == 'arch') {
                    titleCampaigns = isMy ?
                        iget2('p-campaigns', 'arhiv-moih-staryh-kampaniy', 'Архив моих старых кампаний в у. е.') :
                        iget2('p-campaigns', 'arhiv-staryh-kampaniy-klienta', 'Архив старых кампаний клиента в у. е.');
                } else if (form.tab == 'planned') {
                    titleCampaigns = isMy ?
                        iget2('p-campaigns', 'moi-starye-planiruemye-kampanii', 'Мои старые планируемые кампании в у. е.') :
                        iget2('p-campaigns', 'starye-planiruemye-kampanii-klienta', 'Старые планируемые кампании клиента в у. е.');
                } else {
                    titleCampaigns = isMy ? iget2('p-campaigns', 'moi-starye-kampanii-v', 'Мои старые кампании в у. е.') : iget2('p-campaigns', 'starye-kampanii-klienta-v', 'Старые кампании клиента в у. е.');
                }
            } else {
                if (form.tab == 'arch') {
                    titleCampaigns = isMy ? iget2('p-campaigns', 'arhiv-moih-kampaniy', 'Архив моих кампаний') : iget2('p-campaigns', 'arhiv-kampaniy-klienta', 'Архив кампаний клиента');
                } else if (form.tab == 'planned') {
                    titleCampaigns = isMy ? iget2('p-campaigns', 'moi-planiruemye-kampanii', 'Мои планируемые кампании') : iget2('p-campaigns', 'planiruemye-kampanii-klienta', 'Планируемые кампании клиента');
                } else {
                    titleCampaigns = isMy ? iget2('p-campaigns', 'moi-kampanii', 'Мои кампании') : iget2('p-campaigns', 'kampanii-klienta', 'Кампании клиента');
                }
            }

            return applyNext({
                pageParams: {
                    titleCampaigns: titleCampaigns,
                    currentTabs: currentTabs,
                    isService: isService,
                    isMy: isMy,
                    withSearch: (data.campaigns_filtered_by_tab || []).length > 1,
                    readonly: (rights.media_control || rights.superreader_control),
                    // данные которые нужны для aux-actions, но получаем их проходом по всем кампаниям
                    auxParams: {
                        showCampStat: null,
                        camp_count_for_transfer: null,
                        camp_count_with_sum: null,
                        exists_campaigns_for_edit: null,
                        be_shows: null,
                        cid_for_manage_vcards: null,
                        agencyLogin: null,
                        campsExist: null,
                        // данные из can
                        edit_camp: null,
                        transfer_money: null,
                        payCampaign: null,
                        showuid: null
                    }
                },
                nameUser: u.escapeHTML(data.user_fio) + ' – ' + data.user_login
            });
        }),

        mode('title')(function() {
            return this.pageParams.titleCampaigns;
        }),

        mode('title').match(function() {
            return !this.pageParams.isMy;
        })(function() {
            return [
                applyNext(),
                ': ' + this.nameUser
            ];
        })
    )
);

block('p-campaigns')(
    addJs()(function() {
        var cpmYndxFrontpageCamps = [];

        if (!!+this.data.has_cpm_yndx_frontpage_campaigns && !this.pageParams.readonly) {
            (this.data.campaigns_filtered_by_tab || []).forEach(function(camp) {
                if (camp.mediaType === 'cpm_yndx_frontpage') {
                    // Проверка аналогичная проверке для показа кнопки "Ставка" на стр. списка кампаний
                    // b-campaigns-list-item__actions.bemtree.xjst, строка 227
                    if (
                        (/^(autobudget_avg_cpc|autobudget_avg_cpa)_per_(camp|filter)$/.test(camp.strategy.net.name) || camp.autobudget !== 'Yes') &&
                        camp.archived === 'No' &&
                        camp.allow_edit_camp
                    ) {
                        cpmYndxFrontpageCamps.push(camp.cid);
                    }
                }
            });
        }

        return {
            cpmYndxFrontpageCamps: cpmYndxFrontpageCamps,
            showNewDailyBudgetRecommendations:
                this.data.features_enabled_for_client.show_daily_budget_recommendations_in_old_interface == 1,
            currentTab: this.data.tab || 'active',
            settingsSorted: this.data.FORM.settings_sorted
        };
    }),

    content()(function() {
        var data = this.data,
            wallet = data.wallet,
            dnaPanelHidden = data.COOKIES[u['b-switch-to-dna-panel'].getCookieName()],
            tabCampaigns = data.campaigns_filtered_by_tab || [],
            isCurrencyArchive = data.is_currency_archive,
            // выводим предупреждения для всех счетов, поэтому собираем информацию о всех счетах в массив
            allWalletsArray = [],
            showAnyBudgetLimitNotification = !u._.isEmpty(data.daily_budget_notification) ||
                !u._.isEmpty(data.auction_probability_notification),
            showNewDailyBudgetRecommendations =
                data.features_enabled_for_client.show_daily_budget_recommendations_in_old_interface == 1;

        if (wallet.self) {
            allWalletsArray.push(u._.extend({}, wallet.self));
        }

        allWalletsArray = allWalletsArray.concat(u._.map(wallet.agencies, function(value, key) {
            return u._.extend({}, value, { agencyID: key });
        }));

        var activeWallet = u._.find(allWalletsArray, 'enabled', 1) || {},
            dayBudgetWarning = activeWallet.camp_stop_daily_budget_warning || {},
            dayLimitMessageId = 'day-budget-warning-' + activeWallet.wallet_cid + '-' + dayBudgetWarning.stop_time,
            dayLimitDismissed = data.COOKIES[u['b-page-warning'].generateCookieKey(dayLimitMessageId)] === '1';

        return [
            (!data.error || data.FORM.error_code) && {
                block: 'b-campaigns-pay-error'
            },
            showAnyBudgetLimitNotification && !showNewDailyBudgetRecommendations && {
                elem: 'budget-limit-notification',
                wallet: activeWallet,
                auctionProbability: data.auction_probability_notification,
                dayLimit: {
                    showTitle: allWalletsArray.length > 1
                },
                dayLimitMessageId: dayLimitMessageId,
                dayLimitDismissed: dayLimitDismissed,
                ulogin: data.user_login,
                isOldTheme: true
            },
            !isCurrencyArchive && allWalletsArray
                .map(function(walletInfo) {
                    return [
                        {
                            elem: 'autopayment-warning',
                            wallet: walletInfo,
                            currency: data.work_currency,
                            showTitle: allWalletsArray.length > 1
                        }
                    ];
                }),
            {
                block: 'l-page',
                mods: {
                    layout: '84'
                },
                content: [
                    {
                        elem: 'row',
                        center: [
                            {
                                block: 'p-campaigns',
                                elem: 'top',
                                content: [
                                    {
                                        elem: 'common-info',
                                        content: {
                                            block: 'p-campaigns',
                                            elem: 'common-info-table',
                                            content: [
                                                {
                                                    block: 'p-campaigns',
                                                    elem: 'common-info-row',
                                                    content: [
                                                        {
                                                            block: 'p-campaigns',
                                                            elem: 'common-info-cell',
                                                            mix: { elem: 'header-cell' },
                                                            content: [
                                                                {
                                                                    block: 'p-campaigns',
                                                                    elem: 'header'
                                                                },
                                                                !isCurrencyArchive && {
                                                                    block: 'b-overdraft',
                                                                    mix: {
                                                                        block: 'p-campaigns',
                                                                        elem: 'overdraft'
                                                                    }
                                                                }
                                                            ]
                                                        },
                                                        //на баяне показатель качества не показываем
                                                        !!data.show_account_score && {
                                                            block: 'b-account-score',
                                                            mix: [
                                                                {
                                                                    block: 'b-metrika2',
                                                                    js: {
                                                                        event: 'click',
                                                                        params: {
                                                                            ShowCamps: 'How_improvethe_quality_account'
                                                                        },
                                                                        blockName: 'b-account-score'
                                                                    }
                                                                },
                                                                {
                                                                    block: 'p-campaigns',
                                                                    elem: 'common-info-cell'
                                                                }
                                                            ]
                                                        }
                                                    ]
                                                },
                                                !isCurrencyArchive && data.notSplitWallet && {
                                                    block: 'b-wallet-link',
                                                    mix: {
                                                        block: 'p-campaigns',
                                                        elem: 'common-info-row'
                                                    },
                                                    content: [
                                                        {
                                                            elem: 'wallet-info',
                                                            mix: [
                                                                {
                                                                    block: 'p-campaigns',
                                                                    elem: 'common-info-cell'
                                                                }
                                                            ]
                                                        },
                                                        {
                                                            elem: 'account-info',
                                                            mix: [
                                                                {
                                                                    block: 'p-campaigns',
                                                                    elem: 'common-info-cell'
                                                                },
                                                                {
                                                                    block: 'p-campaigns',
                                                                    elem: 'account-info'
                                                                }
                                                            ]
                                                        }
                                                    ],
                                                    campaigns: tabCampaigns,
                                                    wallet: wallet,
                                                    ulogin: data.user_login,
                                                    currency: data.work_currency
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        block: 'b-teaser',
                                        mods: {
                                            view: 'full',
                                            infoblock: 'no'
                                        },
                                        mix: {
                                            block: 'p-campaigns',
                                            elem: 'teaser'
                                        }
                                    }
                                ]
                            },
                            !!u.consts('rights').allowSwitchToDNA && dnaPanelHidden && {
                                block: 'p-campaigns',
                                elem: 'dna-button'
                            }
                        ]
                    },
                    showAnyBudgetLimitNotification && showNewDailyBudgetRecommendations && {
                        elem: 'row',
                        center: {
                            block: 'p-campaigns',
                            elem: 'budget-limit-notification',
                            wallet: activeWallet,
                            auctionProbability: data.auction_probability_notification,
                            dayLimit: {
                                showTitle: allWalletsArray.length > 1
                            },
                            dayLimitMessageId: dayLimitMessageId,
                            dayLimitDismissed: dayLimitDismissed,
                            ulogin: data.user_login
                        }
                    },
                    {
                        elem: 'row',
                        center: {
                            block: 'p-campaigns',
                            elem: 'tabs'
                        }
                    },
                    {
                        elem: 'row',
                        mix: [
                            {
                                block: 'b-search-on-list',
                                mods: {
                                    type: 'online'
                                }
                            },
                            {
                                block: 'b-metrika2',
                                js: {
                                    event: 'change',
                                    params: {
                                        ShowCamps: 'searchFilter'
                                    },
                                    blockName: 'b-search-on-list'
                                }
                            }
                        ],
                        center: [
                            [
                                !!data.campaigns.length && [
                                    {
                                        block: 'b-offline-set-phrases-prices',
                                        js: {
                                            id: 'b-offline-set-phrases-prices'
                                        },
                                        content: {
                                            elem: 'popup',
                                            directions: ['bottom-left'],
                                            readonly: hasLoginRights('superreader_control')
                                        },
                                        mods: {
                                            multi: 'yes'
                                        },
                                        mix: {
                                            block: 'b-metrika2',
                                            js: {
                                                event: 'cost-set-click',
                                                params: {
                                                    ShowCamps: {
                                                        CPC: {
                                                            Popup: 'Choose'
                                                        }
                                                    }
                                                },
                                                blockName: 'b-offline-set-phrases-prices'
                                            }
                                        }
                                    },
                                    {
                                        block: 'b-offline-set-phrases-prices',
                                        js: {
                                            id: 'b-offline-set-phrases-prices-mcbanner'
                                        },
                                        content: {
                                            elem: 'popup',
                                            elemMods: {
                                                type: 'mcbanner'
                                            },
                                            directions: ['bottom-left']
                                        },
                                        mods: {
                                            multi: 'yes',
                                            type: 'mcbanner'
                                        },
                                        mix: {
                                            block: 'b-metrika2',
                                            js: {
                                                event: 'cost-set-click',
                                                params: {
                                                    ShowCamps: {
                                                        CPC: {
                                                            Popup: 'Choose'
                                                        }
                                                    }
                                                },
                                                blockName: 'b-offline-set-phrases-prices'
                                            }
                                        }
                                    },
                                    {
                                        block: 'b-offline-set-phrases-prices',
                                        js: {
                                            id: 'b-offline-set-phrases-prices-performance'
                                        },
                                        content: {
                                            elem: 'popup',
                                            elemMods: {
                                                type: 'performance'
                                            },
                                            directions: ['bottom-left']
                                        },
                                        mods: {
                                            multi: 'yes',
                                            type: 'performance'
                                        },
                                        mix: {
                                            block: 'b-metrika2',
                                            js: {
                                                event: 'cost-set-click',
                                                params: {
                                                    ShowCamps: {
                                                        CPC: {
                                                            Popup: 'Choose'
                                                        }
                                                    }
                                                },
                                                blockName: 'b-offline-set-phrases-prices'
                                            }
                                        }
                                    },
                                    {
                                        block: 'b-offline-set-phrases-prices',
                                        js: {
                                            id: 'b-offline-set-phrases-prices-dynamic-groups'
                                        },
                                        content: {
                                            elem: 'popup',
                                            elemMods: {
                                                type: 'dynamic-groups'
                                            },
                                            directions: ['bottom-left']
                                        },
                                        mods: {
                                            multi: 'yes',
                                            type: 'dynamic-groups'
                                        },
                                        mix: {
                                            block: 'b-metrika2',
                                            js: {
                                                event: 'cost-set-click',
                                                params: {
                                                    ShowCamps: {
                                                        CPC: {
                                                            Popup: 'Choose'
                                                        }
                                                    }
                                                },
                                                blockName: 'b-offline-set-phrases-prices'
                                            }
                                        }
                                    },
                                    {
                                        block: 'b-offline-set-phrases-prices',
                                        js: {
                                            id: 'b-offline-set-phrases-prices-cpm-banner'
                                        },
                                        content: {
                                            elem: 'popup',
                                            elemMods: {
                                                type: 'cpm-banner'
                                            },
                                            directions: ['bottom-left']
                                        },
                                        mods: {
                                            multi: 'yes',
                                            type: 'cpm-banner'
                                        },
                                        mix: {
                                            block: 'b-metrika2',
                                            js: {
                                                event: 'cost-set-click',
                                                params: {
                                                    ShowCamps: {
                                                        CPC: {
                                                            Popup: 'Choose'
                                                        }
                                                    }
                                                },
                                                blockName: 'b-offline-set-phrases-prices'
                                            }
                                        }
                                    },
                                    {
                                        block: 'b-offline-set-phrases-prices',
                                        js: { id: 'b-offline-set-phrases-prices-cpm-deals' },
                                        content: {
                                            elem: 'popup',
                                            elemMods: { type: 'cpm-deals' },
                                            directions: ['bottom-left']
                                        },
                                        mods: { multi: 'yes', type: 'cpm-deals' },
                                        mix: {
                                            block: 'b-metrika2',
                                            js: {
                                                event: 'cost-set-click',
                                                params: {
                                                    ShowCamps: {
                                                        CPC: { Popup: 'Choose' }
                                                    }
                                                },
                                                blockName: 'b-offline-set-phrases-prices'
                                            }
                                        }
                                    },
                                    {
                                        block: 'b-offline-set-phrases-prices',
                                        js: {
                                            id: 'b-offline-set-phrases-prices-cpm-yndx-frontpage'
                                        },
                                        content: {
                                            elem: 'popup',
                                            elemMods: {
                                                type: 'cpm-yndx-frontpage'
                                            },
                                            directions: ['bottom-left']
                                        },
                                        mods: {
                                            multi: 'yes',
                                            type: 'cpm-yndx-frontpage'
                                        },
                                        mix: {
                                            block: 'b-metrika2',
                                            js: {
                                                event: 'cost-set-click',
                                                params: {
                                                    ShowCamps: {
                                                        CPC: {
                                                            Popup: 'Choose'
                                                        }
                                                    }
                                                },
                                                blockName: 'b-offline-set-phrases-prices'
                                            }
                                        }
                                    },
                                    {
                                        block: 'b-offline-set-phrases-prices',
                                        js: {
                                            id: 'b-offline-set-phrases-prices-content-promotion'
                                        },
                                        content: {
                                            elem: 'popup',
                                            elemMods: {
                                                type: 'content-promotion'
                                            },
                                            directions: ['bottom-left']
                                        },
                                        mods: {
                                            multi: 'yes',
                                            type: 'content-promotion'
                                        },
                                        mix: {
                                            block: 'b-metrika2',
                                            js: {
                                                event: 'cost-set-click',
                                                params: {
                                                    ShowCamps: {
                                                        CPC: {
                                                            Popup: 'Choose'
                                                        }
                                                    }
                                                },
                                                blockName: 'b-offline-set-phrases-prices'
                                            }
                                        }
                                    }
                                ],
                                {
                                    block: 'b-campaigns-list',
                                    page: 'campaigns',
                                    campaigns: tabCampaigns,
                                    splitIntoGroups: true,
                                    withSearch: this.pageParams.withSearch,
                                    noPerpageSelector: true
                                }
                            ],
                            {
                                block: 'p-campaigns',
                                elem: 'aux-actions'
                            }
                        ]
                    }
                ]
            },
            !!u.consts('rights').allowSwitchToDNA && !dnaPanelHidden && {
                block: 'b-switch-to-dna-panel',
                mix: {
                    block: 'p-campaigns',
                    elem: 'switch-to-dna'
                }
            },
            // Получаем данные от export.yandex.ru для отображения кнопки "оплатить Яндекс.Деньгами",
            // данные приходят в ГЛОБАЛЬНОЙ переменной inboxCounters.
            // Убрать это при первой же возможности.
            {
                block: 'b-page',
                elem: 'js',
                url: '//export.yandex.ru/counters-js.xml?services=45'
            }
        ];
    })
);
