BEM.DOM.decl('p-campaigns', {
    onSetMod: {
        js: function() {

            if (this.params.cpmYndxFrontpageCamps.length) {
                BEM.blocks['cpm-yndx-frontpage-min-price'].initCampsMinPrices(
                    this.params.cpmYndxFrontpageCamps
                );
            }

            var metrika = BEM.blocks['b-metrika2'],
                goToDna = this.findBlockInside('switch-to-dna-button', 'button2');

            BEM.blocks['b-metrika2'].params({
                params: {
                    ShowCamps: {
                        ShowCampsPageShown: {
                            tab: this.params.currentTab,
                            filter: this.params.settingsSorted
                        }
                    }
                }
            });

            // При успешной повтороной попытке установить автоплатеж - обновляем
            // все блоки и предупреждения автоплатежа на странице для данного ОС
            BEM.blocks['b-autopayment-info'].on('fixError', function(event, data) {
                BEM.blocks['b-metrika2'].params({
                    params: {
                        ShowCamps: 'autopaymentErrorFixed'
                    }
                });

                this
                    .findBlockInside({
                        block: 'b-autopayment-info',
                        modName: 'wallet-cid',
                        modVal: data.walletCid
                    })
                    .setMod('state', 'on');

                this
                    .findBlockOn(this.elem('autopayment-warning', 'wallet-cid', data.walletCid), 'b-page-warning')
                    .destruct();
            }, this);

            if (goToDna) {
                metrika.reachGoal('NEW_INTERFACE_BUTTON_SHOW');

                goToDna.on('click', function() {
                    metrika.reachGoal('NEW_INTERFACE_BUTTON_ACCEPTED');

                    BEM.blocks['i-switch-to-dna'].doSwitch(true);
                }, this);
            }

            var oldDayBudgetWarning = this.findBlockOn('day-budget-warning-container', 'b-page-warning');

            if (oldDayBudgetWarning) {
                var oldDayBudgetWarningType = this.params.showNewDailyBudgetRecommendations ? 'new' : 'old2';

                BEM.blocks['b-metrika2'].params({
                    params: {
                        'day-budget-recommendation': {
                            type: oldDayBudgetWarningType,
                            place: 'camps',
                            event: 'show'
                        }
                    }
                });

                oldDayBudgetWarning.on('close', function() {
                    BEM.blocks['b-metrika2'].params({
                        params: {
                            'day-budget-recommendation': {
                                type: oldDayBudgetWarningType,
                                place: 'camps',
                                event: 'close'
                            }
                        }
                    });
                });
            }
        }
    }
});
