//@heliarian для cmd = showRegisterLoginPage тоже есть captcha_id, но нужно использовать блок p-new-agency-client
match(function() {
    return this.data.captcha_id;
}).match(function() {
    return this.data.cmd !== 'showRegisterLoginPage';
})(

    block('app-main')(

        mode('preprocess')(function() {
            var data = this.data;

            // указанные страницы рендерятся без шапки и футера
            // поэтому и страница каптчи должна вести себя таким же образом
            if ((/^(editVCard|showContactInfo)$/).test(data.FORM.cmd)) {
                data.contentOnly = true;
            }

            return data;
        }),

        mode('page-block')('p-captcha')
    ),

    block('b-page')(

        mode('content-only')(function() {
            return this.data.contentOnly && 'yes';
        }),

        mode('title')(function() {
            return iget2('p-captcha', 'kontrolnye-simvoly', 'Контрольные символы');
        })
    )

);

block('p-captcha').content()(function() {
    var data = this.data,
        form = data.FORM || {};

    return {
        block: 'l-page',
        mods: {
            layout: '16-60-16'
        },
        content: {
            elem: 'row',
            left: true,
            right: true,
            center: [
                {
                    block: 'b-page-title',
                    content: {
                        elem: 'title',
                        content: iget2('p-captcha', 'kontrolnye-simvoly', 'Контрольные символы')
                    }
                },
                {
                    block: 'b-captcha-form',
                    captchaId: data.captcha_id,
                    captchaUrl: data.captcha_url,
                    action: data.SCRIPT,
                    formData: form,
                    method: this.data.request_method,
                    isInvalid: form.captcha_code !== null && form.captcha_id
                }
            ]
        }
    };
});
