block('p-client-reps').elem('control-links').content()(function() {
    var data = this.data,
        uidUrlParam = {},
        mccEnabled = this.ctx.mccEnabled,
        isFreelancer = this.ctx.isFreelancer,
        hasConnectOrg = this.ctx.hasConnectOrg,
        buildUrlByQuery = function(query) {
            return data.script + '?' + Object.keys(query).map(function(q) {
                return q + '=' + query[q];
            }).join('&');
        };

    if (data.uid_url && data.uid_url.key && data.uid_url.value)
        uidUrlParam[data.uid_url.key] = data.uid_url.value;

    return [

        !hasLoginRights('is_any_client') && {
            block: 'link',
            url: buildUrlByQuery({
                cmd: 'showCamps',
                ulogin: data.chief_rep.login
            }),
            content: iget2('p-client-reps', 'vernutsya-k-kampaniyam-klienta', 'Вернуться к кампаниям клиента')
        },
        '<br/>',
        '<br/>',
        mccEnabled && !hasConnectOrg && !isFreelancer && !hasLoginRights('superreader_control') && {
            block: 'link',
            url: buildUrlByQuery(u._.extend({
                cmd: 'addClientToMCC'
            }, uidUrlParam)),
            content: iget2('p-client-reps', 'add-mcc', 'Добавить клиентского менеджера')
        },
        '<br/>',
        '<br/>',
        !hasConnectOrg && !isFreelancer && !hasLoginRights('superreader_control') && {
            block: 'link',
            url: buildUrlByQuery(u._.extend({
                cmd: 'addClRep'
            }, uidUrlParam)),
            content: iget2('p-client-reps', 'naznachit-novogo-predstavitelya', 'Назначить нового представителя')
        },
        '<br/>',
        '<br/>',
        !hasConnectOrg && !isFreelancer &&
            !hasLoginRights('superreader_control') &&
            hasLoginRights('is_client_chief', 'super_control', 'is_superteamleader', 'is_teamleader', 'support_control') &&
            !!data.reps.length && {
                block: 'link',
                url: buildUrlByQuery(u._.extend({
                    cmd: 'switchClChief'
                }, uidUrlParam)),
                content: iget2('p-client-reps', 'smenit-glavnogo-predstavitelya', 'Сменить "главного" представителя')
            }
    ];
});
