block('p-client-reps').elem('current').content()(function() {
    var data = this.data,
        clientFeatures = data.features_enabled_for_client || {},
        operatorFeatures = data.features_enabled_for_operator_all,
        chiefRep = data.chief_rep,
        reps = data.reps = data.client_reps || [],
        controlClients = data.mcc && data.mcc.control_clients || [],
        hasReps = reps.length > 0,
        mccEnabled = operatorFeatures && operatorFeatures.includes('CLIENT_MCC'),
        hasMccClients = mccEnabled && controlClients.length > 0,
        mccColumns = [
            {
                key: 'login',
                title: iget2('p-client-reps', 'login', 'Логин'),
                transformData: function(client) {
                    return {
                        block: 'p-client-reps',
                        elem: 'table-login',
                        elemMods: { chief: client.is_chief ? 'yes' : '' },
                        content: client.login
                    };
                }
            },
            {
                key: 'fio',
                title: iget2('p-client-reps', 'fio', 'ФИО'),
                transformData: function(client) {
                    return u.escapeHTML(client.fio);
                }
            }
        ],
        isFreelancer = data.freelancer_info && data.login_rights.is_freelancer,
        hasConnectOrg = data.has_connect_organization,
        canEdit = !hasConnectOrg && !hasLoginRights('superreader_control') && !isFreelancer,
        rightsEnabled = clientFeatures.readonly_reps,
        buildColumns = function(isChief) {
            return [
                {
                    key: 'login',
                    title: iget2('p-client-reps', 'login', 'Логин'),
                    transformData: function(client) {
                        return {
                            block: 'p-client-reps',
                            elem: 'table-login',
                            elemMods: { chief: client.is_chief ? 'yes' : '' },
                            content: client.login
                        };
                    }
                },
                rightsEnabled && !isChief && {
                    key: 'rep_type',
                    title: iget2('p-client-reps', 'access', 'Доступ'),
                    transformData: function(client) {
                        var access = client.rep_type;

                        if (access === 'readonly') {
                            return iget2('p-client-reps', 'access-readonly', 'Только чтение');
                        }

                        return iget2('p-client-reps', 'access-main', 'Полный доступ');
                    }
                },
                {
                    key: 'FIO',
                    title: iget2('p-client-reps', 'fio', 'ФИО'),
                    transformData: function(client) {
                        return u.escapeHTML(client.FIO);
                    }
                },
                {
                    key: 'email',
                    title: iget2('p-client-reps', 'e-mail', 'E-mail'),
                    transformData: function(client) {
                        return {
                            block: 'link',
                            url: 'mailto:' + client.email,
                            content: client.email
                        };
                    }
                },
                {
                    key: 'phone',
                    title: iget2('p-client-reps', 'telefon', 'Телефон')
                }
            ].filter(Boolean)
        },
        baseColumns = buildColumns(true),
        columns = buildColumns(),
        buildUrlByQuery = function(query) {
            return data.script + '?' + Object.keys(query).map(function(q) {
                return q + '=' + query[q];
            }).join('&');
        },
        buildUserSettingsUrl = function(login) {
            // метод возвращает URL для ссылки на редактирвование
            // пользователя по его логину
            var query = {
                cmd: 'userSettings',
                ulogin: login,
                rcmd: 'showClReps'
            };

            if (data.FORM.ulogin || !hasLoginRights('is_any_client'))
                query.rulogin = u.escapeHTML(data.FORM.ulogin);

            return buildUrlByQuery(query);
        };

    // Первый элемент в baseColumns проверяет этот флаг,
    // Если true то ставит модификатор и рисует жирным шрифтом
    chiefRep.is_chief = true;

    if (canEdit) {
        columns.push({
            title: '',
            transformData: function(client) {
                var editLinks = [];

                if ((!client.is_chief || !hasLoginRights('client_control')))
                    editLinks.push({
                        block: 'link',
                        mix: [{
                            block: 'p-client-reps',
                            elem: 'edit-link'
                        }],
                        url: buildUserSettingsUrl(client.login),
                        content: iget2('p-client-reps', 'redaktirovat-128', 'редактировать')
                    });

                if (!client.is_chief)
                    editLinks.push({
                        block: 'link',
                        mix: [{
                            block: 'p-client-reps',
                            elem: 'remove'
                        }],
                        url: buildUrlByQuery({
                            cmd: 'deleteClRep',
                            ulogin: client.login
                        }),
                        content: iget2('p-client-reps', 'udalit-129', 'удалить')
                    });

                return editLinks;
            }
        });

        mccColumns.push({
            title: '',
            transformData: function(client) {
                var editLinks = [];

                if (!client.is_chief)
                    editLinks.push({
                        block: 'link',
                        mix: [{
                            block: 'p-client-reps',
                            elem: 'remove-mcc'
                        }],
                        url: buildUrlByQuery({
                            cmd: 'deleteClientFromMCC',
                            mcc_client_login: client.login
                        }),
                        content: iget2('p-client-reps', 'udalit-129', 'удалить')
                    });

                return editLinks;
            }
        });
    }

    return [
        hasConnectOrg ? {
            elem: 'warning',
            content: {
                block: 'icon-text',
                mods: {
                    theme: 'info',
                    size: 'ms'
                },
                text: iget2('p-client-reps', 'pereydite-v-connect',
                    'Для управления представителями перейдите в {link}', { link: {
                        block: 'link',
                        url: 'https://connect.yandex.ru/',
                        content: iget2('p-client-reps', 'yandex-connect', 'Яндекс.Коннект')
                    } })
            }
        } : '',
        {
            elem: 'subtitle',
            content: iget2('p-client-reps', 'glavnyy-predstavitel', 'Главный представитель')
        },
        {
            elem: 'table',
            columns: baseColumns.concat({
                title: '',
                transformData: function(client) {
                    return !isFreelancer && canEdit ?
                        {
                            block: 'link',
                            url: buildUserSettingsUrl(client.login),
                            content: iget2('p-client-reps', 'redaktirovat-128', 'редактировать')
                        } :
                        '';
                }
            }),
            rows: [chiefRep]
        },
        hasReps && {
            elem: 'subtitle',
            content: iget2('p-client-reps', 'predstaviteli', 'Представители')
        },
        hasReps && {
            elem: 'table',
            elemMods: {
                'has-num-column': 'yes',
                sortable: 'server'
            },
            numColTitle: '&#8470;',
            columns: columns,
            rows: reps
        },
        hasMccClients && {
            elem: 'subtitle',
            content: iget2('p-client-reps', 'mcc', 'Клиентский менеджер')
        },
        hasMccClients && {
            elem: 'table',
            elemMods: {
                'has-num-column': 'yes',
                sortable: 'server'
            },
            numColTitle: '&#8470;',
            columns: mccColumns,
            rows: controlClients
        },
        {
            elem: 'control-links',
            isFreelancer: isFreelancer,
            hasConnectOrg: hasConnectOrg,
            mccEnabled: mccEnabled
        }
    ];
});
