block('p-client-reps').elem('old').content()(function() {
    var data = this.data,
        ulogin = data.FORM.ulogin,
        canEdit = !hasLoginRights('superreader_control'),
        columns = [
            {
                key: 'login',
                title: iget2('p-client-reps', 'login', 'Логин'),
                transformData: function(client) {
                    return u.escapeHTML(client.login);
                }
            },
            {
                key: 'fio',
                title: iget2('p-client-reps', 'fio', 'ФИО'),
                transformData: function(client) {
                    return u.escapeHTML(client.fio);
                }
            },
            {
                key: 'email',
                title: iget2('p-client-reps', 'e-mail', 'E-mail'),
                transformData: function(client) {
                    return u.escapeHTML(client.email);
                }
            }
        ],
        buildUrlByQuery = function(query) {
            return data.script + '?' + Object.keys(query).map(function(q) {
                return q + '=' + query[q];
            }).join('&');
        };

    if (canEdit)
        columns.push({
            title: '',
            transformData: function(client) {
                if (!client.is_free_for_rep)
                    return '';

                var query = {
                    cmd: 'addClRep',
                    cl_login: client.login,
                    save: 1,
                    use_deleted: 1,
                    rcmd: 'showClReps'
                };

                if (ulogin) {
                    query.rulogin = ulogin;
                    if (!hasLoginRights('is_any_client'))
                        query.ulogin = ulogin;
                }

                return {
                    block: 'link',
                    content: iget2('p-client-reps', 'vosstanovit', 'восстановить'),
                    url: buildUrlByQuery(query)
                };
            }
        });

    return {
        elem: 'table',
        elemMods: {
            sortable: 'server',
            'has-num-column': 'yes'
        },
        columns: columns,
        rows: data.deleted_client_reps,
        anchor: 'old'
    };
});

// Для случая когда нет удаленных
block('p-client-reps').elem('old').match(function() {
    return this.data.deleted_client_reps.length === 0;
}).content()(function() {
    return iget2('p-client-reps', 'udalennyh-predstaviteley-net', 'Удаленных представителей нет');
});
