match(function() { return this.data.cmd === 'clientWalletPayment' })(

    block('app-main')(
        mode('page-block')('p-client-wallet-payment'),
        mode('is-footer-enabled')(false),
        mode('is-header-enabled')(false),
        mode('hide-chat-on-page')(true)
    ),

    block('b-page')(
        mode('content-only')(true),
        mode('title')(function() { return iget2('p-client-wallet-payment', 'client-wallet-payment-title', 'Пополнение общего счёта'); })
    )
);

block('p-client-wallet-payment')(

    js()(true),

    content()(function() {
        var data = this.data,
            //в agencyID может приходить строка '0'
            agencyID = +data.FORM.AgencyID,
            paymentSum = +data.FORM.paymentSum,
            wallet = agencyID ? data.wallet.agencies[agencyID] : data.wallet.self,
            clientNds = data.client_nds;

        wallet.agencyID = agencyID;

        return {
            block: 'b-pay',
            mods: {
                nds: +clientNds &&
                !u._.contains(['YND_FIXED', 'BYN', 'KZT'], data.work_currency) ? 'yes' : 'no'
            },
            isTouch: Boolean(+data.FORM.touch),
            isPageContentView: true,
            wallet: wallet,
            clientNDS: clientNds,
            userLogin: u.consts('ulogin'),
            cid: wallet.wallet_cid,
            offerSumToPay: wallet.offer_sum_to_pay,
            paymentSumFromGetParam: isNaN(paymentSum) ? undefined : paymentSum,
            isIframeContent: true,
            isOfferAccepted: this.data.is_offer_accepted
        };
    })
);
