/**
 * @param ctx.wallet
 */
block('p-client-wallet').elem('body')(

    replace()(function() {
        var data = this.data,
            wallet = this.ctx.wallet,
            showEditTools = data.FORM.showEditTools,
            walletRestrictions = u.getWalletRestrictions(wallet);

        return [
            {
                block: 'l-page',
                elem: 'row',
                left: true,
                lgap: true,
                center: [
                    {
                        block: 'p-client-wallet',
                        elem: 'header',
                        content: [
                            {
                                elem: 'title',
                                walletCid: wallet.wallet_cid
                            },
                            // завязываемся на isAllowTransferMoney и isAllowedEditCamps потому как без них будет недоступно болшее кол-во настроек
                            !walletRestrictions.isAllowTransferMoney && !walletRestrictions.isAllowedEditCamps && {
                                elem: 'header-notice',
                                content: iget2('p-client-wallet', 'dlya-nastroyki-obshchego-schyota', 'Для настройки общего счёта обратитесь в ваше агентство')
                            },
                            {
                                elem: 'header-links',
                                isWalletEnabled: wallet.enabled
                            }
                        ]
                    }
                ],
                rgap: true,
                right: true
            },
            {
                block: 'l-page',
                elem: 'row',
                left: true,
                lgap: true,
                center: {
                    block: 'b-client-wallet',
                    mix: { block: this.block, elem: 'wallet-controls' },
                    client: {
                        currentCurrency: data.work_currency,
                        nds: data.client_nds
                    },
                    wallet: wallet,
                    walletRestrictions: walletRestrictions,
                    autopaySettings: u._.get(data, 'autopay.autopay_settings', {}),
                    switchOffLimitInfo: this.ctx.switchOffLimitInfo,
                    showEditTools: showEditTools
                },
                rgap: true,
                right: true
            },
            {
                block: 'l-page',
                elem: 'row',
                left: true,
                lgap: true,
                center: {
                    block: 'b-costs-campaigns',
                    mix: {
                        block: this.block,
                        elem: 'outlay'
                    },
                    currentCurrency: data.work_currency,
                    outlay: wallet.outlay
                },
                rgap: true,
                right: true
            }
        ];
    }),

    match(function() { return !this.ctx.wallet.enabled }).replace()(function() {
        return [
            {
                block: 'l-page',
                elem: 'row',
                left: true,
                lgap: true,
                center: {
                    block: 'p-client-wallet',
                    elem: 'header',
                    content: {
                        elem: 'title',
                        walletCid: this.ctx.wallet.wallet_cid
                    }
                },
                rgap: true,
                right: true
            },
            {
                block: 'l-page',
                elem: 'row',
                left: true,
                lgap: true,
                center: {
                    block: 'b-enable-wallet',
                    wallet: this.ctx.wallet,
                    buttons: this.ctx.buttons
                },
                rgap: true,
                right: true
            }
        ];
    })
);
