block('p-client-wallet').elem('header-links')(
    content()(function() {
        var links = [
            {
                text: iget2('p-client-wallet', 'payments-and-docs', 'Платежи и документы'),
                url: u.consts('balance-url'),
                goal: {
                    name: 'PAYMENTS_AND_DOCUMENTS_CLICK',
                    urlKey: 'URL_payments_and_documents_click'
                }
            },
            {
                text: iget2('p-client-wallet', 'payment-methods', 'Способы оплаты'),
                url: u.getCommonHelpUrl('/direct/payments/payment-methods.html'),
                goal: {
                    name: 'PAYMENT_METHODS_CLICK',
                    urlKey: 'URL_payment_methods_click'
                }
            },
            {
                text: iget2('p-client-wallet', 'payment-questions', 'Вопросы по оплате'),
                url: u.getCommonHelpUrl('/direct/payments/faq.html'),
                goal: {
                    name: 'PAYMENT_QUESTIONS_CLICK',
                    urlKey: 'URL_payment_questions_click'
                }
            }
            ],
            isWalletEnabled = this.ctx.isWalletEnabled;

        return links.map(function(link) {
            return {
                block: 'link',
                mods: {
                    theme: 'normal',
                    disabled: isWalletEnabled ? '' : 'yes'
                },
                mix: [{
                    block: 'p-client-wallet',
                    elem: 'header-link',
                    js: {
                        goal: link.goal,
                    }
                }],
                target: '_blank',
                content: link.text,
                url: link.url
            };
        });
    }),
    js()(true)
);
