match(function() { return this.data.cmd === 'clientWallet' })(

    block('app-main').mode('page-block')('p-client-wallet'),

    block('b-page').mode('title')(function() { return iget2('p-client-wallet', 'obshchiy-schyot', 'Общий счёт'); })

);

block('p-client-wallet')(

    js()(function() {
        var data = this.data;

        return {
            walletDayBudgetLimitToPopUp: data.FORM.show_day_budget_limit,
            walletSwitchOffLimitToPopUp: data.FORM.show_wallet_switch_off_limit
        };
    }),

    content()(function() {
        var data = this.data,
            //в agencyID может приходить строка '0'
            agencyID = +data.FORM.AgencyID,
            wallet = agencyID ? data.wallet.agencies[agencyID] : data.wallet.self,
            switchOffLimitInfoParams = data.autooverdraft_params || {},
            buttonsJSON = {
                block: 'button',
                mods: { size: 's' },
                content: iget2('p-client-wallet', 'vernutsya-k-spisku-kampaniy', 'Вернуться к списку кампаний'),
                url: u.getUrl('showCamps', { ulogin: u.consts('ulogin') })
            },
            switchOffLimitInfoMinValue = Number(switchOffLimitInfoParams.auto_overdraft_lower_limit),
            switchOffLimitInfoMaxValue = Number(switchOffLimitInfoParams.auto_overdraft_upper_limit),
            switchOffLimitInfoMaxValueWithoutNds =
                Number(switchOffLimitInfoParams.auto_overdraft_upper_limit_without_nds),
            switchOffLimitInfo = {
                value: Number(wallet.auto_overdraft_lim_without_nds),
                valueWithNds: Number(wallet.auto_overdraft_lim),
                minValue: switchOffLimitInfoMinValue,
                maxValue: switchOffLimitInfoMaxValue,
                maxValueWithoutNds: switchOffLimitInfoMaxValueWithoutNds,
                resetEnabled: Boolean(data.autooverdraft_reset_enabled),
                isEditable: !(+switchOffLimitInfoParams.is_banned) && switchOffLimitInfoMaxValue !== 0,
                isNdsAvailable: !wallet.is_fake_nds
            };

        wallet.agencyID = agencyID;

        return [
            {
                block: 'l-page',
                mods: { layout: '12-60-16' },
                content: [
                    {
                        block: this.block,
                        elem: 'body',
                        wallet: wallet,
                        switchOffLimitInfo: switchOffLimitInfo,
                        // при выключенном ОС кнопка рисуется внутри настроек ОС
                        buttons: wallet.enabled || buttonsJSON
                    },
                    // при включенном ОС кнопка рисуется под настройками ОС
                    wallet.enabled ? {
                        elem: 'row',
                        left: true,
                        lgap: true,
                        center: {
                            block: 'p-client-wallet',
                            elem: 'return',
                            content: buttonsJSON
                        }
                    } :
                    ''
                ]
            }
        ];
    })
);
